/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard.view.catalogpanel;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.dashboard.DBDashboardContext;
import org.jkiss.dbeaver.model.dashboard.DBDashboardFolder;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardItemConfiguration;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardProviderDescriptor;
import org.jkiss.dbeaver.model.dashboard.registry.DashboardRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TreeContentProvider;
import org.jkiss.utils.ArrayUtils;

public class DashboardCatalogPanelTreeContentProvider
extends TreeContentProvider {
    private final DBPDataSourceContainer dataSourceContainer;
    private final Function<DashboardItemConfiguration, Boolean> itemFilter;
    private final DBPProject project;

    public DashboardCatalogPanelTreeContentProvider(DBPDataSourceContainer dataSourceContainer, DBPProject project, Function<DashboardItemConfiguration, Boolean> itemFilter) {
        this.dataSourceContainer = dataSourceContainer;
        this.itemFilter = itemFilter;
        this.project = project;
    }

    public Object[] getElements(Object inputElement) {
        Object[] elements = super.getElements(inputElement);
        if (elements == null) {
            return new Object[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (Object element : elements) {
            Object[] children = this.getChildren(element);
            if (children.length <= 0) continue;
            result.add(element);
        }
        return result.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        block7: {
            try {
                DBDashboardContext context = this.dataSourceContainer != null ? new DBDashboardContext(this.dataSourceContainer) : new DBDashboardContext(this.project);
                if (parentElement instanceof DBDashboardFolder) {
                    DBDashboardFolder df = (DBDashboardFolder)parentElement;
                    List subFolders = df.loadSubFolders((DBRProgressMonitor)new VoidProgressMonitor(), context);
                    ArrayList<DashboardItemConfiguration> dashboards = new ArrayList<DashboardItemConfiguration>(df.loadDashboards((DBRProgressMonitor)new VoidProgressMonitor(), context));
                    dashboards.sort(Comparator.comparing(DashboardItemConfiguration::getTitle));
                    return ArrayUtils.concatArrays((Object[])subFolders.toArray(), (Object[])dashboards.toArray());
                }
                if (!(parentElement instanceof DashboardProviderDescriptor)) break block7;
                DashboardProviderDescriptor dpd = (DashboardProviderDescriptor)parentElement;
                ArrayList children = new ArrayList();
                if (dpd.isSupportsFolders()) {
                    try {
                        UIUtils.runInProgressDialog(monitor -> children.addAll(dpd.getInstance().loadRootFolders(monitor, dpd, context)));
                    }
                    catch (InvocationTargetException e) {
                        DBWorkbench.getPlatformUI().showError("Folders load error", null, e.getTargetException());
                    }
                    return children.toArray();
                }
                ArrayList<DashboardItemConfiguration> predefineDashboardItemConfigurations = new ArrayList<DashboardItemConfiguration>(DashboardRegistry.getInstance().getDashboardItems(dpd, (DBPNamedObject)this.dataSourceContainer, false));
                if (this.itemFilter != null) {
                    predefineDashboardItemConfigurations.removeIf(this.itemFilter::apply);
                }
                predefineDashboardItemConfigurations.sort(Comparator.comparing(DashboardItemConfiguration::getTitle));
                return predefineDashboardItemConfigurations.toArray();
            }
            catch (DBException e) {
                DBWorkbench.getPlatformUI().showError("Error reading dashboard info", null, (Throwable)e);
            }
        }
        return new Object[0];
    }

    public boolean hasChildren(Object element) {
        return element instanceof DashboardProviderDescriptor || element instanceof DBDashboardFolder;
    }
}

