/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dashboard;

import java.text.NumberFormat;
import java.time.Duration;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.StandardTickUnitSource;
import org.jfree.chart.axis.TickUnitSource;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.dashboard.DBDashboardValueType;
import org.jkiss.utils.ByteNumberFormat;

public class DashboardUIUtils {
    private static final Log log = Log.getLog(DashboardUIUtils.class);

    public static long parseDuration(String duration, long defValue) {
        if (!((String)duration).startsWith("PT")) {
            duration = "PT" + (String)duration;
        }
        duration = ((String)duration).replace(" ", "");
        try {
            Duration newDuration = Duration.parse((CharSequence)duration);
            return newDuration.toMillis();
        }
        catch (Exception e1) {
            return defValue;
        }
    }

    public static String formatDuration(long duration) {
        return Duration.ofMillis(duration).toString().substring(2);
    }

    public static TickUnitSource getTickUnitsSource(DBDashboardValueType valueType) {
        return switch (valueType) {
            case DBDashboardValueType.decimal -> new NumberTickUnitSource(false);
            case DBDashboardValueType.integer, DBDashboardValueType.percent -> new NumberTickUnitSource(true);
            case DBDashboardValueType.bytes -> new NumberTickUnitSource(true, (NumberFormat)new ByteNumberFormat());
            default -> new StandardTickUnitSource();
        };
    }
}

