/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.transformers;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDContentCached;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.data.ProxyValueHandler;
import org.jkiss.dbeaver.model.impl.data.transformers.TransformerPresentationAttribute;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class UUIDAttributeTransformer
implements DBDAttributeTransformer {
    private static final String PROP_TYPE = "type";
    private static final String PROP_CASE = "case";
    private static final String PROP_UPPER_CASE = "Upper case";

    @Override
    public void transformAttribute(@NotNull DBCSession session, @NotNull DBDAttributeBinding attribute, @NotNull List<Object[]> rows, @NotNull Map<String, Object> options) throws DBException {
        boolean isUpperCase = CommonUtils.equalObjects((Object)options.get(PROP_CASE), (Object)PROP_UPPER_CASE);
        UUIDVersion uuidVersion = this.getUUIDVersion(options);
        attribute.setPresentationAttribute(new TransformerPresentationAttribute(attribute, "UUID", -1, DBPDataKind.BINARY));
        attribute.setTransformHandler(new UUIDValueHandler(this, attribute.getValueHandler(), uuidVersion, isUpperCase));
    }

    private UUIDVersion getUUIDVersion(Map<String, Object> options) {
        return (UUIDVersion)CommonUtils.valueOf(UUIDVersion.class, (String)CommonUtils.toString((Object)options.get(PROP_TYPE)), (Enum)UUIDVersion.Version1);
    }

    static enum UUIDVersion {
        Version1,
        Version2,
        Ordered;

    }

    private class UUIDValueHandler
    extends ProxyValueHandler {
        private UUIDVersion uuidVersion;
        private boolean isUpperCase;

        public UUIDValueHandler(UUIDAttributeTransformer uUIDAttributeTransformer, DBDValueHandler target, UUIDVersion uuidVersion, boolean isUpperCase) {
            super(target);
            this.uuidVersion = uuidVersion;
            this.isUpperCase = isUpperCase;
        }

        @Override
        @NotNull
        public String getValueDisplayString(@NotNull DBSTypedObject column, @Nullable Object value, @NotNull DBDDisplayFormat format) {
            byte[] bytes = null;
            if (value instanceof byte[]) {
                bytes = (byte[])value;
            } else if (value instanceof DBDContentCached) {
                Object cachedValue = ((DBDContentCached)value).getCachedValue();
                if (cachedValue instanceof byte[]) {
                    bytes = (byte[])cachedValue;
                } else if (cachedValue instanceof String) {
                    String string = (String)cachedValue;
                    bytes = string.getBytes();
                }
            }
            if (bytes != null) {
                if (bytes.length < 16) {
                    throw new IllegalArgumentException("UUID length must be at least 16 bytes (actual length = " + bytes.length + ")");
                }
                if (this.uuidVersion == UUIDVersion.Ordered) {
                    long mostSigBits = ((long)bytes[4] << 56) + ((long)(bytes[5] & 0xFF) << 48) + ((long)(bytes[6] & 0xFF) << 40) + ((long)(bytes[7] & 0xFF) << 32) + ((long)(bytes[2] & 0xFF) << 24) + (long)((bytes[3] & 0xFF) << 16) + (long)((bytes[0] & 0xFF) << 8) + (long)((bytes[1] & 0xFF) << 0);
                    long leastSigBits = ((long)bytes[8] << 56) + ((long)(bytes[9] & 0xFF) << 48) + ((long)(bytes[10] & 0xFF) << 40) + ((long)(bytes[11] & 0xFF) << 32) + ((long)(bytes[12] & 0xFF) << 24) + (long)((bytes[13] & 0xFF) << 16) + (long)((bytes[14] & 0xFF) << 8) + (long)((bytes[15] & 0xFF) << 0);
                    if (this.isUpperCase) {
                        return new UUID(mostSigBits, leastSigBits).toString().toUpperCase(Locale.ENGLISH);
                    }
                    return new UUID(mostSigBits, leastSigBits).toString();
                }
                if (this.uuidVersion == UUIDVersion.Version2) {
                    try {
                        if (this.isUpperCase) {
                            return GeneralUtils.getMixedEndianUUIDFromBytes(bytes).toString().toUpperCase(Locale.ENGLISH);
                        }
                        return GeneralUtils.getMixedEndianUUIDFromBytes(bytes).toString();
                    }
                    catch (Exception e) {
                        return String.valueOf(value);
                    }
                }
                try {
                    if (this.isUpperCase) {
                        return GeneralUtils.getUUIDFromBytes(bytes).toString().toUpperCase(Locale.ENGLISH);
                    }
                    return GeneralUtils.getUUIDFromBytes(bytes).toString();
                }
                catch (Exception e) {
                    return String.valueOf(value);
                }
            }
            return super.getValueDisplayString(column, value, format);
        }
    }
}

