/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.sql.parser.SQLIdentifierDetector;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.actions.exec.SQLNativeExecutorDescriptor;
import org.jkiss.dbeaver.ui.actions.exec.SQLNativeExecutorRegistry;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLPresentationDescriptor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLEditorPropertyTester
extends PropertyTester {
    static final Log log = Log.getLog(SQLEditorPropertyTester.class);
    public static final String NAMESPACE = "org.jkiss.dbeaver.ui.editors.sql";
    public static final String PROP_CAN_EXECUTE = "canExecute";
    public static final String PROP_CAN_EXECUTE_NATIVE = "canExecuteNative";
    public static final String PROP_CAN_EXPLAIN = "canExplain";
    public static final String PROP_CAN_NAVIGATE = "canNavigate";
    public static final String PROP_CAN_EXPORT = "canExport";
    public static final String PROP_HAS_ACTIVE_QUERY = "hasActiveQuery";
    public static final String PROP_HAS_SELECTION = "hasSelection";
    public static final String PROP_IS_ACTIVE_QUERY_RUNNING = "isActiveQueryRunning";
    public static final String PROP_FOLDING_SUPPORTED = "foldingSupported";
    public static final String PROP_FOLDING_ENABLED = "foldingEnabled";
    private static final String OVERLAY_ID_DATA_KEY = "org.eclipse.ui.internal.findreplace.overlay.FindReplaceOverlay.id";
    private static final Set<String> OVERLAY_ID_INPUTS = Set.of("replaceInput", "searchInput");

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (!(receiver instanceof SQLEditor)) {
            return false;
        }
        SQLEditor editor = (SQLEditor)((Object)receiver);
        StyledText editorControl = editor.getEditorControl();
        if (editorControl == null) {
            return false;
        }
        boolean hasConnection = editor.getDataSourceContainer() != null;
        switch (property) {
            case "canExecute": {
                SQLPresentationDescriptor descriptor = editor.getActivePresentationDescriptor();
                SQLPresentationDescriptor.QueryMode mode = descriptor != null ? descriptor.getQueryMode() : SQLPresentationDescriptor.QueryMode.MULTIPLE;
                return switch (CommonUtils.toString((Object)expectedValue)) {
                    case "statement" -> {
                        if (mode != SQLPresentationDescriptor.QueryMode.NONE && SQLEditorPropertyTester.isFocusNotInFindReplaceOverlay()) {
                            yield true;
                        }
                        yield false;
                    }
                    case "script" -> {
                        if (mode == SQLPresentationDescriptor.QueryMode.MULTIPLE) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }
            case "canExecuteNative": {
                try {
                    if (editor.getDataSourceContainer() == null) {
                        return false;
                    }
                    SQLNativeExecutorDescriptor executorDescriptor = SQLNativeExecutorRegistry.getInstance().getExecutorDescriptor(editor.getDataSourceContainer());
                    return executorDescriptor != null && executorDescriptor.getNativeExecutor() != null;
                }
                catch (DBException exception) {
                    log.error((Object)"Error checking native execution", (Throwable)exception);
                    return false;
                }
            }
            case "canExplain": {
                return hasConnection && GeneralUtils.adapt((Object)editor.getDataSource(), DBCQueryPlanner.class) != null;
            }
            case "canNavigate": {
                ISelectionProvider selectionProvider = editor.getSelectionProvider();
                if (selectionProvider == null) {
                    return false;
                }
                ITextSelection selection = (ITextSelection)selectionProvider.getSelection();
                IDocument document = editor.getDocument();
                return selection != null && document != null && !new SQLIdentifierDetector(editor.getSyntaxManager().getDialect(), editor.getSyntaxManager().getStructSeparator(), editor.getSyntaxManager().getIdentifierQuoteStrings()).extractIdentifier(document, (IRegion)new Region(selection.getOffset(), selection.getLength()), editor.getRuleManager()).isEmpty();
            }
            case "canExport": {
                return hasConnection && editor.hasActiveQuery();
            }
            case "hasActiveQuery": {
                return editor.hasActiveQuery();
            }
            case "hasSelection": {
                ISelection selection = editor.getSelectionProvider().getSelection();
                return selection instanceof ITextSelection && ((ITextSelection)selection).getLength() > 0;
            }
            case "isActiveQueryRunning": {
                return editor.isActiveQueryRunning();
            }
            case "foldingEnabled": {
                return editor.isFoldingEnabled();
            }
            case "foldingSupported": {
                return editor.getProjectionAnnotationModel() != null;
            }
        }
        return false;
    }

    private static boolean isFocusNotInFindReplaceOverlay() {
        Display display = UIUtils.getDisplay();
        Control focus = display.getFocusControl();
        if (focus != null && !focus.isDisposed() && focus.getParent() != null && !focus.getParent().isDisposed()) {
            String sid;
            Object id = focus.getParent().getData(OVERLAY_ID_DATA_KEY);
            return !(id instanceof String && OVERLAY_ID_INPUTS.contains(sid = (String)id));
        }
        return true;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.ui.editors.sql." + propName));
    }
}

