/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.e4;

import java.lang.reflect.Method;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.AbstractTableInformationControl;
import org.eclipse.e4.ui.internal.workbench.renderers.swt.BasicPartList;
import org.eclipse.e4.ui.model.application.ui.MDirtyable;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.e4.ui.workbench.swt.internal.copy.SearchPattern;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.SearchCellLabelProvider;
import org.jkiss.dbeaver.ui.UIUtils;

public class DBeaverPartList
extends BasicPartList {
    private static final Log log = Log.getLog(DBeaverPartList.class);
    private final StackRenderer renderer;

    public DBeaverPartList(@Nullable Shell parent, int shellStyle, int treeStyler, @NotNull EPartService partService, @NotNull MElementContainer<?> input, @NotNull StackRenderer renderer, boolean mru) {
        super(parent, shellStyle, treeStyler, partService, input, renderer, mru);
        this.renderer = renderer;
    }

    protected TableViewer createTableViewer(Composite parent, int style) {
        Table table = new Table(parent, 4 | style & 0xFFFFFFFD);
        table.setLayoutData((Object)new GridData(1, 1, false, false));
        TableViewer viewer = new TableViewer(table);
        viewer.addFilter((ViewerFilter)new NamePatternFilter());
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setLabelProvider((IBaseLabelProvider)new CellLabelProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
        return viewer;
    }

    @Nullable
    private SearchPattern getMatcher() {
        try {
            Method method = AbstractTableInformationControl.class.getDeclaredMethod("getMatcher", new Class[0]);
            method.setAccessible(true);
            return (SearchPattern)method.invoke((Object)this, new Object[0]);
        }
        catch (Throwable e) {
            log.error((Object)"Error retrieving part list matcher", e);
            return null;
        }
    }

    @Nullable
    private String getPattern() {
        SearchPattern matcher = this.getMatcher();
        if (matcher == null) {
            return null;
        }
        return matcher.getPattern().replaceAll("^\\*|\\*$", "");
    }

    private class NamePatternFilter
    extends ViewerFilter {
        private NamePatternFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            String pattern = DBeaverPartList.this.getPattern();
            if (pattern == null) {
                return true;
            }
            ILabelProvider provider = (ILabelProvider)((ContentViewer)viewer).getLabelProvider();
            String name = provider.getText(element);
            return SearchCellLabelProvider.matches((String)pattern, (String)name);
        }
    }

    private class CellLabelProvider
    extends SearchCellLabelProvider {
        private final Font italicFont = UIUtils.modifyFont((Font)Display.getDefault().getSystemFont(), (int)2);
        private final Font italicBoldFont = UIUtils.modifyFont((Font)Display.getDefault().getSystemFont(), (int)3);

        @Nullable
        public String getPattern() {
            return DBeaverPartList.this.getPattern();
        }

        @NotNull
        public String getText(@NotNull Object element) {
            if (element instanceof MDirtyable && ((MDirtyable)element).isDirty()) {
                return "*" + ((MUILabel)element).getLocalizedLabel();
            }
            return ((MUILabel)element).getLocalizedLabel();
        }

        @Nullable
        public Font getFont(Object element) {
            if (this.isShowing(element)) {
                return null;
            }
            return this.italicFont;
        }

        @NotNull
        public Font getMatchFont(@NotNull Object element) {
            if (this.isShowing(element)) {
                return this.boldFont;
            }
            return this.italicBoldFont;
        }

        @NotNull
        public Image getImage(@NotNull Object element) {
            return DBeaverPartList.this.renderer.getImage((MUILabel)element);
        }

        public String getToolTipText(Object element) {
            return DBeaverPartList.this.renderer.getToolTip((MUILabel)element);
        }

        public void dispose() {
            this.italicFont.dispose();
            this.italicBoldFont.dispose();
            super.dispose();
        }

        private boolean isShowing(@NotNull Object element) {
            CTabItem item = DBeaverPartList.this.renderer.findItemForPart((MPart)element);
            return item != null && item.isShowing();
        }
    }
}

