/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model.plan;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.ext.mysql.model.MySQLDataSource;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanAbstract;
import org.jkiss.dbeaver.ext.mysql.model.plan.MySQLPlanNodeJSON;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.utils.CommonUtils;

public class MySQLPlanJSON
extends MySQLPlanAbstract {
    private final String[] nodePropNames = new String[]{"ordering_operation", "grouping_operation", "nested_loop", "table", "attached_subqueries", "optimized_away_subqueries", "materialized_from_subquery", "duplicates_removal"};
    private static final Gson gson = new Gson();
    private List<MySQLPlanNodeJSON> rootNodes;

    public MySQLPlanJSON(JDBCSession session, String query) throws DBCException {
        super((MySQLDataSource)session.getDataSource(), query);
        try (JDBCPreparedStatement dbStat = session.prepareStatement(this.getPlanQueryString());
             JDBCResultSet dbResult = dbStat.executeQuery();){
            ArrayList<MySQLPlanNodeJSON> nodes = new ArrayList<MySQLPlanNodeJSON>();
            dbResult.next();
            String jsonPlan = dbResult.getString(1);
            JsonObject planObject = (JsonObject)gson.fromJson(jsonPlan, JsonObject.class);
            JsonObject queryBlock = planObject.getAsJsonObject("query_block");
            MySQLPlanNodeJSON rootNode = new MySQLPlanNodeJSON(null, "select", queryBlock);
            if (CommonUtils.isEmpty(rootNode.getNested()) && rootNode.getProperty("message") != null) {
                throw new DBCException("Can't explain plan: " + String.valueOf(rootNode.getProperty("message")));
            }
            nodes.add(rootNode);
            this.rootNodes = nodes;
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    public MySQLPlanJSON(MySQLDataSource dataSource, String query, List<MySQLPlanNodeJSON> rootNodes) {
        super(dataSource, query);
        this.rootNodes = rootNodes;
    }

    public Object getPlanFeature(String feature) {
        if (this.dataSource.isMariaDB() ? "plan.rows".equals(feature) : "plan.cost".equals(feature) || "plan.rows".equals(feature)) {
            return true;
        }
        return super.getPlanFeature(feature);
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() {
        return "EXPLAIN FORMAT=JSON " + this.query;
    }

    public List<MySQLPlanNodeJSON> getPlanNodes(Map<String, Object> options) {
        return this.rootNodes;
    }
}

