/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.cubrid.model.CubridDataSource;
import org.jkiss.dbeaver.ext.cubrid.model.CubridShard;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class CubridShardManager
extends SQLObjectEditor<CubridShard, GenericStructContainer> {
    private static final String PROP_SHARD_TYPE = "shardType";
    private static final String PROP_SHARD_VALUE = "shardValue";
    private static final String SHARD_TYPE_ID = "SHARD ID";

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) {
        int shardValue;
        CubridShard shard = (CubridShard)command.getObject();
        CubridDataSource dataSource = shard.getDataSource();
        DBPConnectionConfiguration connectionInfo = dataSource.getContainer().getConnectionConfiguration();
        try {
            shardValue = Integer.parseInt(shard.getValue());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Shard value must be a numeric value.");
        }
        if (SHARD_TYPE_ID.equals(shard.getName()) && (shardValue < 0 || shardValue > 1)) {
            throw new IllegalArgumentException("The maximum allowed Shard ID is 1. Please enter a valid value.");
        }
        connectionInfo.setProperty(PROP_SHARD_TYPE, shard.getName());
        connectionInfo.setProperty(PROP_SHARD_VALUE, shard.getValue());
    }

    public boolean canCreateObject(@NotNull Object container) {
        return false;
    }

    public boolean canDeleteObject(@NotNull CubridShard object) {
        return false;
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 0L;
    }

    public DBSObjectCache<? extends DBSObject, CubridShard> getObjectsCache(CubridShard object) {
        return null;
    }

    protected CubridShard createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) throws DBException {
        return null;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand command, @NotNull Map<String, Object> options) {
    }
}

