/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.ui.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.wizard.IWizardPage;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferPageDescriptor;
import org.jkiss.dbeaver.tools.transfer.ui.registry.DataTransferPageType;
import org.jkiss.utils.ArrayUtils;

public class DataTransferNodeConfiguratorDescriptor
extends AbstractDescriptor {
    private static final Log log = Log.getLog(DataTransferNodeConfiguratorDescriptor.class);
    @NotNull
    private final String id;
    private final List<DataTransferPageDescriptor> pageTypes = new ArrayList<DataTransferPageDescriptor>();

    DataTransferNodeConfiguratorDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("node");
        this.loadNodeConfigurations(config);
    }

    void loadNodeConfigurations(IConfigurationElement config) {
        HashMap<String, DataTransferPageDescriptor> pagesById = new HashMap<String, DataTransferPageDescriptor>();
        ArrayList<Map.Entry<String, DataTransferPageDescriptor>> replacements = new ArrayList<Map.Entry<String, DataTransferPageDescriptor>>();
        for (IConfigurationElement iConfigurationElement : ArrayUtils.safeArray((Object[])config.getChildren("page"))) {
            String id = iConfigurationElement.getAttribute("id");
            if (id == null || id.isEmpty()) {
                log.warn((Object)("Page descriptor without id: " + config.getContributor().getName()));
            }
            DataTransferPageDescriptor descriptor = new DataTransferPageDescriptor(iConfigurationElement);
            pagesById.put(id, descriptor);
            String replaces = iConfigurationElement.getAttribute("replaces");
            if (replaces == null || replaces.isEmpty()) continue;
            replacements.add(Map.entry(replaces, descriptor));
        }
        for (Map.Entry entry : replacements) {
            pagesById.put((String)entry.getKey(), (DataTransferPageDescriptor)((Object)entry.getValue()));
        }
        this.pageTypes.clear();
        this.pageTypes.addAll(new HashSet(pagesById.values()));
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    List<DataTransferPageDescriptor> patPageDescriptors() {
        return this.pageTypes;
    }

    public DataTransferPageDescriptor getPageDescriptor(IWizardPage page) {
        for (DataTransferPageDescriptor pd : this.pageTypes) {
            if (!pd.getPageClass().getImplName().equals(page.getClass().getName())) continue;
            return pd;
        }
        return null;
    }

    public IWizardPage[] createWizardPages(IWizardPage[] existingPages, boolean consumerOptional, boolean producerOptional, boolean settingsPage) {
        ArrayList<IWizardPage> pages = new ArrayList<IWizardPage>();
        for (DataTransferPageDescriptor page : this.pageTypes) {
            if (page.isConsumerSelector() && !consumerOptional || page.isProducerSelector() && !producerOptional || settingsPage != (page.getPageType() == DataTransferPageType.SETTINGS)) continue;
            try {
                AbstractDescriptor.ObjectType type = page.getPageClass();
                type.checkObjectClass(IWizardPage.class);
                Class pageClass = type.getObjectClass();
                boolean added = false;
                if (!ArrayUtils.isEmpty((Object[])existingPages)) {
                    IWizardPage[] iWizardPageArray = existingPages;
                    int n = existingPages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWizardPage ep = iWizardPageArray[n2];
                        if (pageClass == ep.getClass()) {
                            pages.add(ep);
                            added = true;
                            break;
                        }
                        ++n2;
                    }
                }
                if (added) continue;
                pages.add((IWizardPage)type.createInstance(IWizardPage.class));
            }
            catch (Throwable e) {
                log.error((Object)"Can't create wizard page", e);
            }
        }
        return pages.toArray(new IWizardPage[0]);
    }

    public String toString() {
        return this.id;
    }
}

