from datetime import datetime
from typing import Any, Dict, Optional

from github.GithubObject import CompletableGithubObject
from github.Issue import Issue
from github.NotificationSubject import NotificationSubject
from github.PullRequest import PullRequest
from github.Repository import Repository

class Notification(CompletableGithubObject):
    def _initAttributes(self) -> None: ...
    def _useAttributes(self, attributes: Dict[str, Any]) -> None: ...
    @property
    def id(self) -> str: ...
    @property
    def last_read_at(self) -> datetime: ...
    def mark_as_read(self) -> None: ...
    @property
    def reason(self) -> str: ...
    @property
    def repository(self) -> Repository: ...
    @property
    def subject(self) -> NotificationSubject: ...
    @property
    def subscription_url(self) -> str: ...
    @property
    def unread(self) -> Optional[bool]: ...
    @property
    def updated_at(self) -> Optional[datetime]: ...
    @property
    def url(self) -> Optional[str]: ...
    def get_pull_request(self) -> PullRequest: ...
    def get_issue(self) -> Issue: ...
