/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlTypeNameSpec;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Litmus;

public class SqlMapTypeNameSpec
extends SqlTypeNameSpec {
    private final SqlDataTypeSpec keyType;
    private final SqlDataTypeSpec valType;

    public SqlMapTypeNameSpec(SqlDataTypeSpec keyType, SqlDataTypeSpec valType, SqlParserPos pos) {
        super(new SqlIdentifier(SqlTypeName.MAP.getName(), pos), pos);
        this.keyType = keyType;
        this.valType = valType;
    }

    public SqlDataTypeSpec getKeyType() {
        return this.keyType;
    }

    public SqlDataTypeSpec getValType() {
        return this.valType;
    }

    @Override
    public RelDataType deriveType(SqlValidator validator) {
        boolean keyCanBeNullable = validator.getTypeFactory().getTypeSystem().mapKeysCanBeNullable();
        RelDataType kType = this.keyType.deriveType(validator, keyCanBeNullable);
        RelDataType valueType = this.valType.deriveType(validator, true);
        return validator.getTypeFactory().createMapType(kType, valueType);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.keyword("MAP");
        SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.FUN_CALL, "<", ">");
        writer.sep(",");
        this.keyType.unparse(writer, leftPrec, rightPrec);
        if (Boolean.TRUE.equals(this.keyType.getNullable())) {
            writer.keyword("NULL");
        }
        writer.sep(",");
        this.valType.unparse(writer, leftPrec, rightPrec);
        if (Boolean.TRUE.equals(this.valType.getNullable())) {
            writer.keyword("NULL");
        }
        writer.endList(frame);
    }

    @Override
    public boolean equalsDeep(SqlTypeNameSpec spec, Litmus litmus) {
        if (!(spec instanceof SqlMapTypeNameSpec)) {
            return litmus.fail("{} != {}", this, spec);
        }
        SqlMapTypeNameSpec that = (SqlMapTypeNameSpec)spec;
        if (!this.keyType.equalsDeep((SqlNode)that.keyType, litmus)) {
            return litmus.fail("{} != {}", this, spec);
        }
        if (!this.valType.equalsDeep((SqlNode)that.valType, litmus)) {
            return litmus.fail("{} != {}", this, spec);
        }
        return litmus.succeed();
    }
}

