/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.HttpTokensState;
import software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState;
import software.amazon.awssdk.services.ec2.model.InstanceMetadataTagsState;
import software.amazon.awssdk.services.ec2.model.ManagedBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceMetadataDefaultsResponse
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceMetadataDefaultsResponse> {
    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpTokens").getter(InstanceMetadataDefaultsResponse.getter(InstanceMetadataDefaultsResponse::httpTokensAsString)).setter(InstanceMetadataDefaultsResponse.setter(Builder::httpTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens").unmarshallLocationName("httpTokens").build()}).build();
    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HttpPutResponseHopLimit").getter(InstanceMetadataDefaultsResponse.getter(InstanceMetadataDefaultsResponse::httpPutResponseHopLimit)).setter(InstanceMetadataDefaultsResponse.setter(Builder::httpPutResponseHopLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit").unmarshallLocationName("httpPutResponseHopLimit").build()}).build();
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HttpEndpoint").getter(InstanceMetadataDefaultsResponse.getter(InstanceMetadataDefaultsResponse::httpEndpointAsString)).setter(InstanceMetadataDefaultsResponse.setter(Builder::httpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint").unmarshallLocationName("httpEndpoint").build()}).build();
    private static final SdkField<String> INSTANCE_METADATA_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceMetadataTags").getter(InstanceMetadataDefaultsResponse.getter(InstanceMetadataDefaultsResponse::instanceMetadataTagsAsString)).setter(InstanceMetadataDefaultsResponse.setter(Builder::instanceMetadataTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataTags").unmarshallLocationName("instanceMetadataTags").build()}).build();
    private static final SdkField<String> MANAGED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedBy").getter(InstanceMetadataDefaultsResponse.getter(InstanceMetadataDefaultsResponse::managedByAsString)).setter(InstanceMetadataDefaultsResponse.setter(Builder::managedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy").unmarshallLocationName("managedBy").build()}).build();
    private static final SdkField<String> MANAGED_EXCEPTION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedExceptionMessage").getter(InstanceMetadataDefaultsResponse.getter(InstanceMetadataDefaultsResponse::managedExceptionMessage)).setter(InstanceMetadataDefaultsResponse.setter(Builder::managedExceptionMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedExceptionMessage").unmarshallLocationName("managedExceptionMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_TOKENS_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, HTTP_ENDPOINT_FIELD, INSTANCE_METADATA_TAGS_FIELD, MANAGED_BY_FIELD, MANAGED_EXCEPTION_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceMetadataDefaultsResponse.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String httpTokens;
    private final Integer httpPutResponseHopLimit;
    private final String httpEndpoint;
    private final String instanceMetadataTags;
    private final String managedBy;
    private final String managedExceptionMessage;

    private InstanceMetadataDefaultsResponse(BuilderImpl builder) {
        this.httpTokens = builder.httpTokens;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.httpEndpoint = builder.httpEndpoint;
        this.instanceMetadataTags = builder.instanceMetadataTags;
        this.managedBy = builder.managedBy;
        this.managedExceptionMessage = builder.managedExceptionMessage;
    }

    public final HttpTokensState httpTokens() {
        return HttpTokensState.fromValue(this.httpTokens);
    }

    public final String httpTokensAsString() {
        return this.httpTokens;
    }

    public final Integer httpPutResponseHopLimit() {
        return this.httpPutResponseHopLimit;
    }

    public final InstanceMetadataEndpointState httpEndpoint() {
        return InstanceMetadataEndpointState.fromValue(this.httpEndpoint);
    }

    public final String httpEndpointAsString() {
        return this.httpEndpoint;
    }

    public final InstanceMetadataTagsState instanceMetadataTags() {
        return InstanceMetadataTagsState.fromValue(this.instanceMetadataTags);
    }

    public final String instanceMetadataTagsAsString() {
        return this.instanceMetadataTags;
    }

    public final ManagedBy managedBy() {
        return ManagedBy.fromValue(this.managedBy);
    }

    public final String managedByAsString() {
        return this.managedBy;
    }

    public final String managedExceptionMessage() {
        return this.managedExceptionMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.httpTokensAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMetadataTagsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedExceptionMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMetadataDefaultsResponse)) {
            return false;
        }
        InstanceMetadataDefaultsResponse other = (InstanceMetadataDefaultsResponse)obj;
        return Objects.equals(this.httpTokensAsString(), other.httpTokensAsString()) && Objects.equals(this.httpPutResponseHopLimit(), other.httpPutResponseHopLimit()) && Objects.equals(this.httpEndpointAsString(), other.httpEndpointAsString()) && Objects.equals(this.instanceMetadataTagsAsString(), other.instanceMetadataTagsAsString()) && Objects.equals(this.managedByAsString(), other.managedByAsString()) && Objects.equals(this.managedExceptionMessage(), other.managedExceptionMessage());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceMetadataDefaultsResponse").add("HttpTokens", (Object)this.httpTokensAsString()).add("HttpPutResponseHopLimit", (Object)this.httpPutResponseHopLimit()).add("HttpEndpoint", (Object)this.httpEndpointAsString()).add("InstanceMetadataTags", (Object)this.instanceMetadataTagsAsString()).add("ManagedBy", (Object)this.managedByAsString()).add("ManagedExceptionMessage", (Object)this.managedExceptionMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HttpTokens": {
                return Optional.ofNullable(clazz.cast(this.httpTokensAsString()));
            }
            case "HttpPutResponseHopLimit": {
                return Optional.ofNullable(clazz.cast(this.httpPutResponseHopLimit()));
            }
            case "HttpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointAsString()));
            }
            case "InstanceMetadataTags": {
                return Optional.ofNullable(clazz.cast(this.instanceMetadataTagsAsString()));
            }
            case "ManagedBy": {
                return Optional.ofNullable(clazz.cast(this.managedByAsString()));
            }
            case "ManagedExceptionMessage": {
                return Optional.ofNullable(clazz.cast(this.managedExceptionMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HttpTokens", HTTP_TOKENS_FIELD);
        map.put("HttpPutResponseHopLimit", HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD);
        map.put("HttpEndpoint", HTTP_ENDPOINT_FIELD);
        map.put("InstanceMetadataTags", INSTANCE_METADATA_TAGS_FIELD);
        map.put("ManagedBy", MANAGED_BY_FIELD);
        map.put("ManagedExceptionMessage", MANAGED_EXCEPTION_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceMetadataDefaultsResponse, T> g) {
        return obj -> g.apply((InstanceMetadataDefaultsResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String httpTokens;
        private Integer httpPutResponseHopLimit;
        private String httpEndpoint;
        private String instanceMetadataTags;
        private String managedBy;
        private String managedExceptionMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMetadataDefaultsResponse model) {
            this.httpTokens(model.httpTokens);
            this.httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            this.httpEndpoint(model.httpEndpoint);
            this.instanceMetadataTags(model.instanceMetadataTags);
            this.managedBy(model.managedBy);
            this.managedExceptionMessage(model.managedExceptionMessage);
        }

        public final String getHttpTokens() {
            return this.httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        @Override
        public final Builder httpTokens(HttpTokensState httpTokens) {
            this.httpTokens(httpTokens == null ? null : httpTokens.toString());
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return this.httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getHttpEndpoint() {
            return this.httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        @Override
        public final Builder httpEndpoint(InstanceMetadataEndpointState httpEndpoint) {
            this.httpEndpoint(httpEndpoint == null ? null : httpEndpoint.toString());
            return this;
        }

        public final String getInstanceMetadataTags() {
            return this.instanceMetadataTags;
        }

        public final void setInstanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
        }

        @Override
        public final Builder instanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
            return this;
        }

        @Override
        public final Builder instanceMetadataTags(InstanceMetadataTagsState instanceMetadataTags) {
            this.instanceMetadataTags(instanceMetadataTags == null ? null : instanceMetadataTags.toString());
            return this;
        }

        public final String getManagedBy() {
            return this.managedBy;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        @Override
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public final Builder managedBy(ManagedBy managedBy) {
            this.managedBy(managedBy == null ? null : managedBy.toString());
            return this;
        }

        public final String getManagedExceptionMessage() {
            return this.managedExceptionMessage;
        }

        public final void setManagedExceptionMessage(String managedExceptionMessage) {
            this.managedExceptionMessage = managedExceptionMessage;
        }

        @Override
        public final Builder managedExceptionMessage(String managedExceptionMessage) {
            this.managedExceptionMessage = managedExceptionMessage;
            return this;
        }

        public InstanceMetadataDefaultsResponse build() {
            return new InstanceMetadataDefaultsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceMetadataDefaultsResponse> {
        public Builder httpTokens(String var1);

        public Builder httpTokens(HttpTokensState var1);

        public Builder httpPutResponseHopLimit(Integer var1);

        public Builder httpEndpoint(String var1);

        public Builder httpEndpoint(InstanceMetadataEndpointState var1);

        public Builder instanceMetadataTags(String var1);

        public Builder instanceMetadataTags(InstanceMetadataTagsState var1);

        public Builder managedBy(String var1);

        public Builder managedBy(ManagedBy var1);

        public Builder managedExceptionMessage(String var1);
    }
}

