
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *  The method renameNode renames an existing node. When the specified node was created 
 *  from a different document than this document, a WRONG_DOCUMENT_ERR exception is thrown.
 *  
 *  Invoke the renameNode method on a new Document node to rename a new attribute node
 *  created in the original Document, but later adopted by this new document node.  The 
 *  ownerDocument attribute of this attribute has now changed, such that the attribute node is considered to 
 *         be created from this new document node. Verify that no exception is thrown upon renaming and verify
 *         the new nodeName of this attribute node. 
* @author IBM
* @author Neil Delima
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-renameNode">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#Document3-renameNode</a>
*/
public final class documentrenamenode09 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public documentrenamenode09(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {

      org.w3c.domts.DocumentBuilderSetting[] settings = 
          new org.w3c.domts.DocumentBuilderSetting[] {
org.w3c.domts.DocumentBuilderSetting.namespaceAware
        };
        DOMTestDocumentBuilderFactory testFactory = factory.newInstance(settings);
        setFactory(testFactory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", false);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      Document newDoc;
      DOMImplementation domImpl;
      Attr attr;
      Node renamedNode;
      Node adopted;
      DocumentType nullDocType = null;

      String attrNodeName;
      doc = (Document) load("hc_staff", false);
      domImpl = doc.getImplementation();
      newDoc = domImpl.createDocument("http://www.w3.org/DOM/Test", "dom:newD", nullDocType);
      attr = doc.createAttributeNS("http://www.w3.org/DOM/Test", "test");
      adopted = newDoc.adoptNode(attr);
      renamedNode = newDoc.renameNode(attr, "http://www.w3.org/2000/xmlns/", "xmlns:xmlns");
      attrNodeName = renamedNode.getNodeName();
      assertEquals("documentrenamenode09_1", "xmlns:xmlns", attrNodeName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/documentrenamenode09";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(documentrenamenode09.class, args);
   }
}

