/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.xop;

import java.io.IOException;
import javax.activation.DataHandler;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.xop.AbstractXOPDecodingFilterHandler;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.om.OMAttachmentAccessor;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.impl.intf.TextContent;

final class XOPDecodingFilterHandler
extends AbstractXOPDecodingFilterHandler {
    private final OMAttachmentAccessor attachmentAccessor;

    XOPDecodingFilterHandler(XmlHandler parent, OMAttachmentAccessor attachmentAccessor) {
        super(parent);
        this.attachmentAccessor = attachmentAccessor;
    }

    @Override
    protected Object buildCharacterData(String contentID) {
        return new TextContent(contentID, new DataHandlerProviderImpl(this.attachmentAccessor, contentID), true);
    }

    private static class DataHandlerProviderImpl
    implements DataHandlerProvider {
        private final OMAttachmentAccessor attachmentAccessor;
        private final String contentID;

        public DataHandlerProviderImpl(OMAttachmentAccessor attachmentAccessor, String contentID) {
            this.attachmentAccessor = attachmentAccessor;
            this.contentID = contentID;
        }

        @Override
        public DataHandler getDataHandler() throws IOException {
            DataHandler dh = this.attachmentAccessor.getDataHandler(this.contentID);
            if (dh == null) {
                throw new OMException("No MIME part found for content ID '" + this.contentID + "'");
            }
            return dh;
        }
    }

    private static enum State {
        AFTER_START_ELEMENT,
        CONTENT_SEEN,
        IN_XOP_INCLUDE,
        AFTER_XOP_INCLUDE;

    }
}

