/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;

public final class MetricName {
    private final String name;
    private final String group;
    private final String description;
    private Map<String, String> tags;
    private int hash = 0;

    public MetricName(String name, String group, String description, Map<String, String> tags) {
        this.name = Utils.notNull(name);
        this.group = Utils.notNull(group);
        this.description = Utils.notNull(description);
        this.tags = Utils.notNull(tags);
    }

    @Deprecated
    public MetricName(String name, String group, String description, String ... keyValue) {
        this(name, group, description, MetricName.getTags(keyValue));
    }

    private static Map<String, String> getTags(String ... keyValue) {
        if (keyValue.length % 2 != 0) {
            throw new IllegalArgumentException("keyValue needs to be specified in pairs");
        }
        HashMap<String, String> tags = new HashMap<String, String>();
        for (int i = 0; i < keyValue.length; i += 2) {
            tags.put(keyValue[i], keyValue[i + 1]);
        }
        return tags;
    }

    @Deprecated
    public MetricName(String name, String group, Map<String, String> tags) {
        this(name, group, "", tags);
    }

    @Deprecated
    public MetricName(String name, String group, String description) {
        this(name, group, description, new HashMap<String, String>());
    }

    @Deprecated
    public MetricName(String name, String group) {
        this(name, group, "", new HashMap<String, String>());
    }

    public String name() {
        return this.name;
    }

    public String group() {
        return this.group;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String description() {
        return this.description;
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        this.hash = result = 31 * result + (this.tags == null ? 0 : this.tags.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetricName other = (MetricName)obj;
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.tags == null ? other.tags != null : !this.tags.equals(other.tags));
    }

    public String toString() {
        return "MetricName [name=" + this.name + ", group=" + this.group + ", description=" + this.description + ", tags=" + this.tags + "]";
    }
}

