/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.tools;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.util.FileUtils;
import org.eclipse.core.runtime.Path;

public class BatchRuleEvaluator {
    private static AnalysisEngine ae;
    private static String engineFile;
    private static String tempDir;
    private static String foldRootDirectory;
    private static int foldCount;
    private static CAS sharedCAS;

    public static AnalysisEngine getAnalysisEngine() {
        if (ae == null) {
            String descriptorFile = engineFile;
            TextRulerToolkit.log("loading AE...");
            ae = TextRulerToolkit.loadAnalysisEngine(descriptorFile);
            Path path = new Path(tempDir + "/results" + ".ruta");
            ae.setConfigParameterValue("mainScript", (Object)path.removeFileExtension().lastSegment());
            ae.setConfigParameterValue("scriptPaths", (Object)new String[]{path.removeLastSegments(1).toPortableString()});
            ae.setConfigParameterValue("reloadScript", (Object)true);
            try {
                ae.reconfigure();
            }
            catch (ResourceConfigurationException e) {
                TextRulerPlugin.error(e);
                return null;
            }
        }
        return ae;
    }

    private static File[] getXMIFileFromFolder(String folderName) {
        File folder = new File(folderName);
        File[] files = folder.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xmi");
            }
        });
        return files;
    }

    public static void main(String[] args) {
        tempDir = "/testinput/temp/";
        engineFile = "/Users/tobi/Documents/UniLaptop/Diplomarbeit/TestDataSets/withPosTags/Subset100/10fold/desc/lp2ergebnisrandomgiantEngine.xml";
        foldRootDirectory = "/Users/tobi/Documents/UniLaptop/Diplomarbeit/TestDataSets/withPosTags/9010_middle/";
        foldCount = 1;
        String[] slotNames = new String[]{"org.apache.uima.ml.types.etime", "org.apache.uima.ml.types.stime", "org.apache.uima.ml.types.location", "org.apache.uima.ml.types.speaker"};
        String[] algIDs = new String[]{"optimizedLP2"};
        for (int foldNumber = 0; foldNumber < foldCount; ++foldNumber) {
            for (String slotName : slotNames) {
                for (String algID : algIDs) {
                    BatchRuleEvaluator.runRules(foldNumber, slotName, algID);
                }
            }
        }
    }

    public static void runRules(int foldNumber, String slotName, String algorithmID) {
        File[] inputFiles;
        BatchRuleEvaluator.getAnalysisEngine();
        TextRulerToolkit.log("Testing Fold Number " + foldNumber + "\t  Slot: " + slotName + "\t  Algorithm: " + algorithmID);
        String inputFolder = foldRootDirectory + foldNumber + "/testing/withouttags/";
        String rulesFile = foldRootDirectory + foldNumber + "/learnResults/" + slotName + "/" + algorithmID + "/results" + ".ruta";
        String scriptFile = tempDir + "results" + ".ruta";
        File oldScriptFile = new File(scriptFile);
        if (oldScriptFile.exists() && !oldScriptFile.delete()) {
            TextRulerToolkit.log("ERROR DELETING OLD SCRIPT FILE: " + scriptFile);
            return;
        }
        if (!new File(rulesFile).exists()) {
            TextRulerToolkit.log("\tSKIPPED, no rules file not found!");
            return;
        }
        try {
            FileUtils.copyFile((File)new File(rulesFile), (File)new File(tempDir));
        }
        catch (IOException e) {
            TextRulerPlugin.error(e);
            return;
        }
        String outputFolder1 = foldRootDirectory + foldNumber + "/testing/markedFromRules";
        String outputFolder2 = foldRootDirectory + foldNumber + "/testing/markedFromRules/" + slotName;
        String outputFolder = foldRootDirectory + foldNumber + "/testing/markedFromRules/" + slotName + "/" + algorithmID;
        new File(outputFolder1).mkdir();
        new File(outputFolder2).mkdir();
        new File(outputFolder).mkdir();
        for (File inputFile : inputFiles = BatchRuleEvaluator.getXMIFileFromFolder(inputFolder)) {
            sharedCAS = TextRulerToolkit.readCASfromXMIFile(inputFile, ae, sharedCAS);
            try {
                ae.process(sharedCAS);
            }
            catch (AnalysisEngineProcessException e) {
                TextRulerPlugin.error(e);
                return;
            }
            TextRulerToolkit.writeCAStoXMIFile(sharedCAS, TextRulerToolkit.addTrailingSlashToPath(outputFolder) + "fromRules_" + inputFile.getName());
        }
    }

    static {
        foldCount = 0;
    }
}

