/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.rapier;

import java.util.ArrayList;
import org.apache.uima.ruta.textruler.core.TextRulerBasicLearner;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerRulePattern;
import org.apache.uima.ruta.textruler.core.TextRulerSingleSlotRule;
import org.apache.uima.ruta.textruler.core.TextRulerStatisticsCollector;
import org.apache.uima.ruta.textruler.core.TextRulerTarget;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.learner.rapier.RapierRuleItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RapierRule
extends TextRulerSingleSlotRule {
    protected double priority = 0.0;
    protected RapierRule parent1 = null;
    protected RapierRule parent2 = null;
    protected int parent1PreFiller_n = 0;
    protected int parent2PreFiller_n = 0;
    protected int parent1PostFiller_n = 0;
    protected int parent2PostFiller_n = 0;

    protected RapierRule(RapierRule copyFrom) {
        super(copyFrom);
        this.priority = copyFrom.priority;
        this.parent1 = copyFrom.parent1;
        this.parent2 = copyFrom.parent2;
        this.parent1PreFiller_n = copyFrom.parent1PreFiller_n;
        this.parent2PreFiller_n = copyFrom.parent2PreFiller_n;
        this.parent1PostFiller_n = copyFrom.parent1PostFiller_n;
        this.parent2PostFiller_n = copyFrom.parent2PostFiller_n;
    }

    @Override
    public RapierRule copy() {
        return new RapierRule(this);
    }

    public RapierRule(TextRulerBasicLearner parentAlgorithm, TextRulerTarget target) {
        super(parentAlgorithm, target);
    }

    public boolean producesOnlyValidFillers() {
        return this.coveringStatistics.getTotalCoveredExamples() > 0 && this.coveringStatistics.getCoveredNegativesCount() == 0;
    }

    public double noiseValue() {
        int p = this.coveringStatistics.getCoveredPositivesCount();
        int n = this.coveringStatistics.getCoveredNegativesCount();
        return (double)(p - n) / (double)(p + n);
    }

    public static double log2(double z) {
        return Math.log(z) / Math.log(2.0);
    }

    @Override
    public void setCoveringStatistics(TextRulerStatisticsCollector c) {
        super.setCoveringStatistics(c);
        int p = c.getCoveredPositivesCount();
        int n = c.getCoveredNegativesCount();
        if (p < 1) {
            TextRulerToolkit.log("ERROR, A RULE MAY NOT COVER ZERO POSITIVE EXAMPLES! WHAT'S WRONG ?");
            TextRulerToolkit.log("\tRULE: " + this.getRuleString());
            this.priority = Double.MAX_VALUE;
        } else {
            this.priority = this.calculateRuleSize() / ((double)p * 100.0) - RapierRule.log2((double)(p + 1) / (double)(p + n + 2));
            if (this.priority > 10000.0 && p > 0) {
                TextRulerToolkit.log("STRANGE RULE PRIORITY ! CHECK THIS!");
            }
        }
    }

    public double getPriority() {
        return this.priority;
    }

    public RapierRule getParent1() {
        return this.parent1;
    }

    public RapierRule getParent2() {
        return this.parent2;
    }

    public void setParent1(RapierRule p) {
        this.parent1 = p;
    }

    public void setParent2(RapierRule p) {
        this.parent2 = p;
    }

    public int getParent1PreFiller_n() {
        return this.parent1PreFiller_n;
    }

    public int getParent2PreFiller_n() {
        return this.parent2PreFiller_n;
    }

    public void setParent1PreFiller_n(int n) {
        this.parent1PreFiller_n = n;
    }

    public void setParent2PreFiller_n(int n) {
        this.parent2PreFiller_n = n;
    }

    public int getParent1PostFiller_n() {
        return this.parent1PostFiller_n;
    }

    public int getParent2PostFiller_n() {
        return this.parent2PostFiller_n;
    }

    public void setParent1PostFiller_n(int n) {
        this.parent1PostFiller_n = n;
    }

    public void setParent2PostFiller_n(int n) {
        this.parent2PostFiller_n = n;
    }

    public double calculateRuleSize() {
        double result = 0.0;
        for (TextRulerRuleItem ri : this.slotPattern.preFillerPattern) {
            result += (double)((RapierRuleItem)ri).getRuleSizePoints();
        }
        for (TextRulerRuleItem ri : this.slotPattern.fillerPattern) {
            result += (double)((RapierRuleItem)ri).getRuleSizePoints();
        }
        for (TextRulerRuleItem ri : this.slotPattern.postFillerPattern) {
            result += (double)((RapierRuleItem)ri).getRuleSizePoints();
        }
        return result / 100.0;
    }

    public boolean hasListItemAtBorder() {
        int cnt = this.totalItemCount();
        if (cnt == 0) {
            return false;
        }
        RapierRuleItem ri = (RapierRuleItem)this.getRuleItemWithIndex(0);
        if (ri.isListItem()) {
            return true;
        }
        if (cnt <= 1) {
            return false;
        }
        ri = (RapierRuleItem)this.getRuleItemWithIndex(cnt - 1);
        return ri.isListItem();
    }

    public ArrayList<RapierRule> createAllTestRules() {
        if (!this.hasListItemAtBorder()) {
            return null;
        }
        ArrayList<RapierRule> result = new ArrayList<RapierRule>();
        RapierRule strippedRule = this.copy();
        int leftType = 0;
        RapierRuleItem left = null;
        if (this.slotPattern.preFillerPattern.size() > 0) {
            leftType = 1;
            left = (RapierRuleItem)this.slotPattern.preFillerPattern.get(0);
            if (left.isListItem()) {
                strippedRule.getPreFillerPattern().remove(0);
            }
        } else if (this.slotPattern.fillerPattern.size() > 0) {
            leftType = 2;
            left = (RapierRuleItem)this.slotPattern.fillerPattern.get(0);
            if (left.isListItem()) {
                strippedRule.getFillerPattern().remove(0);
            }
        } else if (this.slotPattern.postFillerPattern.size() > 0) {
            leftType = 3;
            left = (RapierRuleItem)this.slotPattern.postFillerPattern.get(0);
            if (left.isListItem()) {
                strippedRule.getPostFillerPattern().remove(0);
            }
        }
        if (left != null && !left.isListItem()) {
            left = null;
            leftType = 0;
        }
        int rightType = 0;
        RapierRuleItem right = null;
        if (this.totalItemCount() > 1) {
            if (this.slotPattern.postFillerPattern.size() > 0) {
                rightType = 1;
                right = (RapierRuleItem)this.slotPattern.postFillerPattern.get(this.slotPattern.postFillerPattern.size() - 1);
                if (right.isListItem()) {
                    strippedRule.getPostFillerPattern().remove(strippedRule.getPostFillerPattern().size() - 1);
                }
            } else if (this.slotPattern.fillerPattern.size() > 0) {
                rightType = 2;
                right = (RapierRuleItem)this.slotPattern.fillerPattern.get(this.slotPattern.fillerPattern.size() - 1);
                if (right.isListItem()) {
                    strippedRule.getFillerPattern().remove(strippedRule.getFillerPattern().size() - 1);
                }
            } else if (this.slotPattern.postFillerPattern.size() > 0) {
                rightType = 3;
                right = (RapierRuleItem)this.slotPattern.preFillerPattern.get(this.slotPattern.preFillerPattern.size() - 1);
                if (right.isListItem()) {
                    strippedRule.getPreFillerPattern().remove(strippedRule.getPreFillerPattern().size() - 1);
                }
            }
        }
        if (right != null && !right.isListItem()) {
            right = null;
            rightType = 0;
        }
        if (left == null && right == null) {
            TextRulerToolkit.logIfDebug("HOW CAN THIS BE ?");
            return null;
        }
        int leftCount = left != null ? left.listLen() : 0;
        int rightCount = right != null ? right.listLen() : 0;
        int leftStart = leftCount > 0 && !left.listBeginsAtZero() ? 1 : 0;
        int rightStart = rightCount > 0 && !right.listBeginsAtZero() ? 1 : 0;
        for (int leftI = leftStart; leftI <= leftCount; ++leftI) {
            for (int rightI = rightStart; rightI <= rightCount; ++rightI) {
                RapierRuleItem theItem;
                int i;
                TextRulerRulePattern thePattern;
                RapierRule newRule = strippedRule.copy();
                if (leftI > 0) {
                    thePattern = null;
                    if (leftType == 1) {
                        thePattern = newRule.getPreFillerPattern();
                    } else if (leftType == 2) {
                        thePattern = newRule.getFillerPattern();
                    } else if (leftType == 3) {
                        thePattern = newRule.getPostFillerPattern();
                    }
                    for (i = 0; i < leftI; ++i) {
                        theItem = left.copy();
                        theItem.setListLen(0);
                        thePattern.add(0, theItem);
                    }
                }
                if (rightI > 0) {
                    thePattern = null;
                    if (rightType == 1) {
                        thePattern = newRule.getPostFillerPattern();
                    } else if (rightType == 2) {
                        thePattern = newRule.getFillerPattern();
                    } else if (rightType == 3) {
                        thePattern = newRule.getPreFillerPattern();
                    }
                    for (i = 0; i < rightI; ++i) {
                        theItem = right.copy();
                        theItem.setListLen(0);
                        thePattern.add(theItem);
                    }
                }
                newRule.setNeedsCompile(true);
                if (newRule.totalItemCount() <= 0) continue;
                result.add(newRule);
            }
        }
        return result;
    }

    @Override
    public String getRulesFileContent() {
        String theString;
        if (this.hasListItemAtBorder()) {
            ArrayList<RapierRule> rules = this.createAllTestRules();
            theString = "// " + this.getRuleString() + "\n\n";
            for (RapierRule r : rules) {
                theString = theString + r.getRuleString() + "\n";
            }
        } else {
            theString = this.getRuleString() + "\n";
        }
        return this.algorithm.getTMFileHeaderString() + theString;
    }

    public boolean isInitialRule() {
        return this.parent1 == null || this.parent2 == null;
    }

    protected boolean compressFirstOccurenceOfSubsequentEqualPatternLists(TextRulerRulePattern p) {
        for (int i = 0; i < p.size() - 1; ++i) {
            RapierRuleItem it1 = (RapierRuleItem)p.get(i);
            RapierRuleItem it2 = (RapierRuleItem)p.get(i + 1);
            if (!it1.toStringAsNonPatternList().equals(it2.toStringAsNonPatternList()) || !it1.isListItem() && !it2.isListItem()) continue;
            boolean fromZero = it1.listBeginsAtZero() && it2.listBeginsAtZero();
            int listLen = (it1.isListItem() ? it1.listLen() : 1) + (it2.isListItem() ? it2.listLen() : 1);
            it1.setListLen(listLen);
            it1.setListBeginsAtZero(fromZero);
            p.remove(i + 1);
            return true;
        }
        return false;
    }

    public void combineSenselessPatternListItems() {
        boolean thisRoundCompressed;
        boolean didCompress = false;
        do {
            thisRoundCompressed = this.compressFirstOccurenceOfSubsequentEqualPatternLists(this.slotPattern.preFillerPattern);
            thisRoundCompressed |= this.compressFirstOccurenceOfSubsequentEqualPatternLists(this.slotPattern.fillerPattern);
            didCompress |= (thisRoundCompressed |= this.compressFirstOccurenceOfSubsequentEqualPatternLists(this.slotPattern.postFillerPattern));
        } while (thisRoundCompressed);
        if (didCompress) {
            this.setNeedsCompile(true);
        }
    }
}

