/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.whisk.generic;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.textruler.core.TextRulerAnnotation;
import org.apache.uima.ruta.textruler.core.TextRulerRule;
import org.apache.uima.ruta.textruler.core.TextRulerRuleItem;
import org.apache.uima.ruta.textruler.core.TextRulerWordConstraint;
import org.apache.uima.ruta.textruler.learner.whisk.generic.WhiskRule;

public class WhiskRuleItem
implements TextRulerRuleItem {
    private TextRulerWordConstraint wordConstraint;
    private boolean isStarWildCard = false;
    private boolean hideRegExp = true;
    private boolean hideFeature = true;
    protected List<MLWhiskOtherConstraint> otherConstraints = new ArrayList<MLWhiskOtherConstraint>();
    private List<String> activeFeatures = new ArrayList<String>();

    public WhiskRuleItem() {
        this.wordConstraint = null;
    }

    public static WhiskRuleItem newWildCardItem() {
        WhiskRuleItem i = new WhiskRuleItem();
        i.setIsStarWildCard(true);
        return i;
    }

    public WhiskRuleItem(WhiskRuleItem copyFrom) {
        if (copyFrom.wordConstraint != null) {
            this.wordConstraint = copyFrom.wordConstraint.copy();
        }
        this.isStarWildCard = copyFrom.isStarWildCard;
        this.hideRegExp = copyFrom.hideRegExp;
        for (MLWhiskOtherConstraint c : copyFrom.otherConstraints) {
            this.otherConstraints.add(c.copy());
        }
        this.activeFeatures = new ArrayList<String>(copyFrom.getActivatedFeatures());
    }

    public WhiskRuleItem(TextRulerAnnotation tokenAnnotation) {
        this.setWordConstraint(new TextRulerWordConstraint(tokenAnnotation));
    }

    public void setWordConstraint(TextRulerWordConstraint c) {
        this.wordConstraint = c;
    }

    public TextRulerWordConstraint getWordConstraint() {
        return this.wordConstraint;
    }

    @Override
    public TextRulerRuleItem copy() {
        return new WhiskRuleItem(this);
    }

    @Override
    public String getStringForRuleString(TextRulerRule rule, TextRulerRuleItem.MLRuleItemType type, int numberInPattern, int patternSize, int numberInRule, int ruleSize, int slotIndex) {
        Object result = "";
        WhiskRule whiskRule = (WhiskRule)rule;
        boolean isMarkingItem = type == TextRulerRuleItem.MLRuleItemType.FILLER && numberInPattern == 0;
        ArrayList<CallSite> constraints = new ArrayList<CallSite>();
        Object anchor = null;
        if (this.wordConstraint != null) {
            if (this.wordConstraint.isRegExpConstraint()) {
                anchor = this.wordConstraint.typeShortName();
                if (!this.hideRegExp) {
                    constraints.add((CallSite)((Object)("REGEXP(\"" + this.wordConstraint + "\")")));
                }
            } else {
                anchor = this.wordConstraint.toString();
            }
        }
        MLWhiskOtherConstraint anchorConstraint = null;
        if (anchor == null) {
            for (MLWhiskOtherConstraint c : this.otherConstraints) {
                if (!c.canBeAnchorConstraint()) continue;
                anchorConstraint = c;
                break;
            }
        }
        for (MLWhiskOtherConstraint oc : this.otherConstraints) {
            if (oc == anchorConstraint) continue;
            if (oc.canBeAnchorConstraint()) {
                constraints.add((CallSite)((Object)("IS(" + oc + ")")));
                continue;
            }
            constraints.add((CallSite)((Object)("PARTOF(" + oc + ")")));
        }
        if (anchor == null) {
            anchor = anchorConstraint != null ? anchorConstraint.toString() : "ALL";
        }
        for (String featureString : this.activeFeatures) {
            String string = this.wordConstraint.getTokenAnnotation().getFeatureMap().get(featureString);
            if (string == null) continue;
            constraints.add((CallSite)((Object)("FEATURE(\"" + featureString + "\", " + string + ")")));
        }
        if (constraints.size() > 0) {
            Object cStr = "";
            for (String string : constraints) {
                if (((String)cStr).length() > 0) {
                    cStr = (String)cStr + ", ";
                }
                cStr = (String)cStr + string;
            }
            result = (String)result + "{" + (String)cStr;
            if (!isMarkingItem) {
                result = (String)result + "}";
            }
        }
        if (isMarkingItem) {
            if (constraints.size() == 0) {
                result = (String)result + "{";
            }
            result = (String)result + "->MARKONCE(" + whiskRule.getMarkName(slotIndex);
            if (patternSize > 1) {
                result = (String)result + ", " + (numberInRule + 1) + ", " + (numberInRule + patternSize);
            }
            result = (String)result + ")}";
        }
        if (this.isStarWildCard && ((String)(anchor = (String)anchor + "*?")).equals("ALL*?")) {
            anchor = "#";
        }
        return (String)anchor + (String)result;
    }

    public void setIsStarWildCard(boolean flag) {
        this.isStarWildCard = flag;
    }

    public boolean isStarWildCard() {
        return this.isStarWildCard;
    }

    @Override
    public boolean equals(TextRulerRuleItem o) {
        WhiskRuleItem it = (WhiskRuleItem)o;
        if (this.wordConstraint != null && !this.wordConstraint.equals(it.wordConstraint)) {
            return false;
        }
        return this.isStarWildCard == it.isStarWildCard;
    }

    @Override
    public String toString() {
        return this.getStringForRuleString(null, null, 0, 0, 0, 0, 0);
    }

    public void setHideRegExp(boolean flag) {
        this.hideRegExp = flag;
    }

    public boolean isHideRegExp() {
        return this.hideRegExp;
    }

    public void addOtherConstraint(MLWhiskOtherConstraint c) {
        if (!this.otherConstraints.contains(c)) {
            this.otherConstraints.add(c);
        }
    }

    public List<MLWhiskOtherConstraint> getOtherConstraints() {
        return this.otherConstraints;
    }

    public int constraintPoints() {
        int result = 0;
        if (this.wordConstraint != null) {
            result += this.hideRegExp ? 1 : 3;
        }
        if (this.wordConstraint != null) {
            result += this.hideFeature ? 1 : 3;
        }
        return result += this.otherConstraints.size();
    }

    public boolean isHideFeature() {
        return this.hideFeature;
    }

    public void setHideFeature(boolean hideFeature) {
        this.hideFeature = hideFeature;
    }

    public void activateFeature(String stringValue) {
        this.activeFeatures.add(stringValue);
    }

    public void deactivateFeature(String stringValue) {
        this.activeFeatures.remove(stringValue);
    }

    public List<String> getActivatedFeatures() {
        return this.activeFeatures;
    }

    public static class MLWhiskOtherConstraint {
        TextRulerAnnotation tokenAnnotation;
        TextRulerAnnotation constraintAnnotation;
        boolean canBeAnchor;
        Type type;

        public MLWhiskOtherConstraint(TextRulerAnnotation tokenAnnotation, TextRulerAnnotation constraintAnnotation) {
            this.tokenAnnotation = tokenAnnotation;
            this.constraintAnnotation = constraintAnnotation;
            this.type = constraintAnnotation.getType();
            this.canBeAnchor = tokenAnnotation.getBegin() == constraintAnnotation.getBegin() && tokenAnnotation.getEnd() == constraintAnnotation.getEnd();
        }

        public boolean isTMBasicTypeTokenConstraint() {
            return this.tokenAnnotation == this.constraintAnnotation;
        }

        public boolean canBeAnchorConstraint() {
            return this.canBeAnchor;
        }

        public boolean equals(Object o) {
            MLWhiskOtherConstraint co = (MLWhiskOtherConstraint)o;
            return this.toString().equals(co.toString()) && this.canBeAnchor == co.canBeAnchor;
        }

        public int hashCode() {
            return this.toString().hashCode() * (this.canBeAnchor ? 2 : 1);
        }

        public String toString() {
            return this.type.getShortName();
        }

        public MLWhiskOtherConstraint copy() {
            return new MLWhiskOtherConstraint(this.tokenAnnotation, this.constraintAnnotation);
        }
    }
}

