/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.tree;

import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.FSFeatureTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.FSTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.PrimitiveFeatureTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.TypeTreeNode;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class ToolTipListener
implements Listener {
    private static final String TOOLTIP_TEXT_END = "\nEnd: ";
    private static final String TOOLTIP_TEXT_BEGIN = "Begin: ";
    private Shell tip = null;
    private Label label = null;
    private Tree tree;

    public ToolTipListener(Tree tree) {
        this.tree = tree;
    }

    public void handleEvent(Event event) {
        switch (event.type) {
            case 1: 
            case 5: 
            case 12: {
                if (this.tip == null) break;
                this.tip.dispose();
                this.tip = null;
                this.label = null;
                break;
            }
            case 32: {
                TreeItem item = this.tree.getItem(new Point(event.x, event.y));
                if (item == null) break;
                Object text = "";
                if (item.getData() instanceof FSFeatureTreeNode) {
                    node = (FSFeatureTreeNode)item.getData();
                    text = "Type: " + ((FSTreeNode)node).getType();
                } else if (item.getData() instanceof AnnotationTreeNode) {
                    AnnotationFS annot = ((AnnotationTreeNode)item.getData()).getAnnotation();
                    text = TOOLTIP_TEXT_BEGIN + annot.getBegin() + TOOLTIP_TEXT_END + annot.getEnd();
                } else if (item.getData() instanceof PrimitiveFeatureTreeNode) {
                    node = (PrimitiveFeatureTreeNode)item.getData();
                    text = "Type: " + ((PrimitiveFeatureTreeNode)node).getType();
                } else if (item.getData() instanceof TypeTreeNode) {
                    TypeTreeNode ttn = (TypeTreeNode)item.getData();
                    text = "Type: " + ttn.getName();
                }
                if (this.tip != null && !this.tip.isDisposed()) {
                    this.tip.dispose();
                }
                this.tip = new Shell(Display.getCurrent().getActiveShell(), 540676);
                this.tip.setBackground(Display.getCurrent().getSystemColor(29));
                FillLayout layout = new FillLayout();
                layout.marginWidth = 2;
                this.tip.setLayout((Layout)layout);
                this.label = new Label((Composite)this.tip, 0);
                this.label.setForeground(Display.getCurrent().getSystemColor(28));
                this.label.setBackground(Display.getCurrent().getSystemColor(29));
                this.label.setText((String)text);
                Point size = this.tip.computeSize(-1, -1);
                Rectangle rect = item.getBounds(0);
                Point pt = this.tree.toDisplay(rect.x, rect.y);
                this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                this.tip.setVisible(true);
            }
        }
    }
}

