/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.net.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.ServerAddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.semconv.SemanticAttributes;
import javax.annotation.Nullable;

public final class InternalNetClientAttributesExtractor<REQUEST, RESPONSE> {
    private final NetClientAttributesGetter<REQUEST, RESPONSE> getter;
    private final AddressAndPortExtractor<REQUEST> logicalAddressAndPortExtractor;
    private final boolean emitOldHttpAttributes;

    public InternalNetClientAttributesExtractor(NetClientAttributesGetter<REQUEST, RESPONSE> getter, AddressAndPortExtractor<REQUEST> fallbackAddressAndPortExtractor, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.logicalAddressAndPortExtractor = new ServerAddressAndPortExtractor<REQUEST>(getter, fallbackAddressAndPortExtractor);
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        if (this.emitOldHttpAttributes) {
            String sockFamily;
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_TRANSPORT, (Object)this.getter.getTransport(request, response));
            String peerName = this.logicalAddressAndPortExtractor.extract(request).getAddress();
            String sockPeerAddr = this.getter.getServerSocketAddress(request, response);
            if (sockPeerAddr != null && !sockPeerAddr.equals(peerName) && (sockFamily = this.getter.getSockFamily(request, response)) != null && !"inet".equals(sockFamily)) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.NET_SOCK_FAMILY, (Object)sockFamily);
            }
        }
    }
}

