Title: JavaEE Examples
Notice:    Licensed to the Apache Software Foundation (ASF) under one
           or more contributor license agreements.  See the NOTICE file
           distributed with this work for additional information
           regarding copyright ownership.  The ASF licenses this file
           to you under the Apache License, Version 2.0 (the
           "License"); you may not use this file except in compliance
           with the License.  You may obtain a copy of the License at
           .
             http://www.apache.org/licenses/LICENSE-2.0
           .
           Unless required by applicable law or agreed to in writing,
           software distributed under the License is distributed on an
           "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
           KIND, either express or implied.  See the License for the
           specific language governing permissions and limitations
           under the License.

If there is a particular example that you do not see here please feel free to [ask](mailto:dev@tomee.apache.org?subject=Example+request), the odds are good that someone will create it for you.  
All the examples show source code, but some are better documented than others.
If you need a little more help understanding an example then please drop us a [line](mailto:dev@tomee.apache.org?subject=Example+request) or visit us on IRC freenode.net #openejb

{row
{span-one-third
###Session Beans
[simple-singleton](simple-singleton/README.html)  
[simple-stateful](simple-stateful/README.html)  
[simple-stateless](simple-stateless/README.html)  
[simple-stateless-with-descriptor](simple-stateless-with-descriptor/README.html)  
}
{span-one-third
###EntityManagers
[injection-of-entitymanager](injection-of-entitymanager/README.html)  
[jpa-eclipselink](jpa-eclipselink/README.html)  
[jpa-hibernate](jpa-hibernate/README.html)  
[jpa-enumerated](jpa-enumerated/README.html)  
}
{span-one-third
###CDI
[cdi-basic](cdi-basic/README.html)  
[cdi-request-scope](cdi-request-scope/README.html)  
[cdi-application-scope](cdi-application-scope/README.html)  
[simple-cdi-interceptor](simple-cdi-interceptor/README.html)  
[cdi-produces-disposes](cdi-produces-disposes/README.html)  
[decorators](decorators/README.html)  
[cdi-alternative-and-stereotypes](cdi-alternative-and-stereotypes/README.html)  
}
}
{row
{span-one-third
###EJB
[access-timeout](access-timeout/README.html)  
[async-methods](async-methods/README.html)  
[schedule-expression](schedule-expression/README.html)  
[schedule-methods](schedule-methods/README.html)  
[interceptors](interceptors/README.html)  
[async-postconstruct](async-postconstruct/README.html)  
}
{span-one-third
###REST
[simple-rest](simple-rest/README.html)  
[rest-example](rest-example/README.html)  
[rest-example-with-application](rest-example-with-application/README.html)  
[rest-on-ejb](rest-on-ejb/README.html)  
[rest-xml-json](rest-example/README.html)  
}
{span-one-third
###Web Services
[simple-webservice](simple-webservice/README.html)  
[webservice-handlerchain](webservice-handlerchain/README.html)  
[webservice-holder](webservice-holder/README.html)  
[webservice-attachments](webservice-attachments/README.html)  
[webservice-inheritance](webservice-inheritance/README.html)  
[webservice-security](webservice-security/README.html)  
[webservice-ws-security](webservice-ws-security/README.html)  
}
}
{row
{span-one-third
###JMS and MDBs
[injection-of-connectionfactory](injection-of-connectionfactory/README.html)  
[simple-mdb-with-descriptor](simple-mdb-with-descriptor/README.html)  
[simple-mdb](simple-mdb/README.html)  
}
{span-one-third
### Transactions
[testing-transactions](testing-transactions/README.html)  
[transaction-rollback](transaction-rollback/README.html)  
[applicationexception](applicationexception/README.html)  
}
{span-one-third
### Security
[testing-security-3](testing-security-3/README.html)  
[testing-security-2](testing-security-2/README.html)  
[testing-security](testing-security/README.html)  
}
}
{row
{span-one-third
###DataSources
[injection-of-datasource](injection-of-datasource/README.html)  
[datasource-ciphered-password](datasource-ciphered-password/README.html)  
[dynamic-datasource-routing](dynamic-datasource-routing/README.html)  
[resources-declared-in-webapp](resources-declared-in-webapp/README.html)  
}
{span-one-third
###Referencing EJBs
[injection-of-ejbs](injection-of-ejbs/README.html)  
[lookup-of-ejbs-with-descriptor](lookup-of-ejbs-with-descriptor/README.html)  
[lookup-of-ejbs](lookup-of-ejbs/README.html)  
}
{span-one-third
###Environment Entries
[injection-of-env-entry](injection-of-env-entry/README.html)  
[custom-injection](custom-injection/README.html)  
}
}
{row
{span-one-third
###Java EE Connectors
[quartz-app](quartz-app/README.html)  
}
{span-one-third
###Testing Techniques
[alternate-descriptors](alternate-descriptors/README.html)  
[application-composer](application-composer/README.html)  
[testcase-injection](testcase-injection/README.html)  
[ear-testing](ear-testing/README.html)  
}
{span-one-third
### Frameworks
[spring-data-proxy-meta](spring-data-proxy-meta/README.html)  
[spring-data-proxy](spring-data-proxy/README.html)  
[struts](struts/README.html)  
}
}
{row
{span-one-third
###Meta-Annotations
[access-timeout-meta](access-timeout-meta/README.html)  
[schedule-methods-meta](schedule-methods-meta/README.html)  
[testing-security-meta](testing-security-meta/README.html)  
[movies-complete-meta](movies-complete-meta/README.html)  
[movies-complete](movies-complete/README.html)  
}
{span-one-third
### Proxy Beans
[dynamic-dao-implementation](dynamic-dao-implementation/README.html)  
[dynamic-implementation](dynamic-implementation/README.html)  
[dynamic-proxy-to-access-mbean](dynamic-proxy-to-access-mbean/README.html)  
[spring-data-proxy](spring-data-proxy/README.html)   
}
{span-one-third
###EJB Legacy
[cmp2-entitybeans](simple-cmp2/README.html)  
[component-interfaces](component-interfaces/README.html)  
}
}
{row
{span-one-third
### Other Features
[mbean-auto-registration](mbean-auto-registration/README.html)  
[bean-validation-design-by-contract](bean-validation-design-by-contract/README.html)  
[telephone-stateful](telephone-stateful/README.html)  
[troubleshooting](troubleshooting/README.html)  
}
{span-two-thirds
###Misc
[applet](applet/README.html)  
[ejb-examples](ejb-examples/README.html)  
[ejb-webservice](ejb-webservice/README.html)  
[jsf-cdi-and-ejb](jsf-cdi-and-ejb/README.html)  
[jsf-managedBean-and-ejb](jsf-managedBean-and-ejb/README.html)  
[moviefun](moviefun/README.html)  
[helloworld-weblogic](helloworld-weblogic/README.html)  
[polling-parent](polling-parent/README.html)  
}
}