/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi.concurrency;

import jakarta.annotation.Priority;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import org.apache.openejb.core.ivm.naming.NamingException;
import org.apache.openejb.resource.thread.ManagedExecutorServiceImplFactory;
import org.apache.openejb.threads.impl.ManagedExecutorServiceImpl;

@Interceptor
@Asynchronous
@Priority(value=5)
public class AsynchronousInterceptor {
    public static final String MP_ASYNC_ANNOTATION_NAME = "org.eclipse.microprofile.faulttolerance.Asynchronous";
    private final Map<Method, Exception> validationCache = new ConcurrentHashMap<Method, Exception>();

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        ManagedExecutorServiceImpl mes;
        Exception exception = this.validationCache.computeIfAbsent(ctx.getMethod(), this::validate);
        if (exception != null) {
            throw exception;
        }
        Asynchronous asynchronous = ctx.getMethod().getAnnotation(Asynchronous.class);
        try {
            mes = ManagedExecutorServiceImplFactory.lookup(asynchronous.executor());
        }
        catch (IllegalArgumentException | NamingException e) {
            throw new RejectedExecutionException("Cannot lookup ManagedExecutorService", e);
        }
        CompletableFuture future = mes.newIncompleteFuture();
        mes.execute(() -> {
            try {
                Asynchronous.Result.setFuture((CompletableFuture)future);
                CompletionStage result = (CompletionStage)ctx.proceed();
                if (result == null || result == future) {
                    future.complete(result);
                    Asynchronous.Result.setFuture(null);
                    return;
                }
                result.whenComplete((resultInternal, err) -> {
                    if (resultInternal != null) {
                        future.complete(resultInternal);
                    } else if (err != null) {
                        future.completeExceptionally((Throwable)err);
                    }
                    Asynchronous.Result.setFuture(null);
                });
            }
            catch (Exception e) {
                future.completeExceptionally(e);
                Asynchronous.Result.setFuture(null);
            }
        });
        return ctx.getMethod().getReturnType() == Void.TYPE ? null : future;
    }

    private Exception validate(Method method) {
        if (this.hasMpAsyncAnnotation(method.getAnnotations()) || this.hasMpAsyncAnnotation(method.getDeclaringClass().getAnnotations())) {
            return new UnsupportedOperationException("Combining " + Asynchronous.class.getName() + " and org.eclipse.microprofile.faulttolerance.Asynchronous on the same method/class is not supported");
        }
        Asynchronous asynchronous = method.getAnnotation(Asynchronous.class);
        if (asynchronous == null) {
            return new UnsupportedOperationException("Asynchronous annotation must be placed on a method");
        }
        Class<?> returnType = method.getReturnType();
        if (returnType != Void.TYPE && returnType != CompletableFuture.class && returnType != CompletionStage.class) {
            return new UnsupportedOperationException("Asynchronous annotation must be placed on a method that returns either void, CompletableFuture or CompletionStage");
        }
        return null;
    }

    private boolean hasMpAsyncAnnotation(Annotation[] declaredAnnotations) {
        return Arrays.stream(declaredAnnotations).map(it -> it.annotationType().getName()).anyMatch(it -> it.equals(MP_ASYNC_ANNOTATION_NAME));
    }
}

