/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt;

import jakarta.servlet.FilterRegistration;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.ws.rs.core.Application;
import java.util.Set;
import org.apache.tomee.microprofile.jwt.MPJWTFilter;
import org.eclipse.microprofile.auth.LoginConfig;

@HandlesTypes(value={LoginConfig.class})
public class MPJWTInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        if (classes == null || classes.isEmpty()) {
            return;
        }
        for (Class<?> clazz : classes) {
            LoginConfig loginConfig = clazz.getAnnotation(LoginConfig.class);
            if (loginConfig.authMethod() == null && !"MP-JWT".equals(loginConfig.authMethod()) || !Application.class.isAssignableFrom(clazz)) continue;
            FilterRegistration.Dynamic mpJwtFilter = ctx.addFilter("mp-jwt-filter", MPJWTFilter.class);
            mpJwtFilter.setAsyncSupported(true);
            mpJwtFilter.addMappingForUrlPatterns(null, false, new String[]{"/*"});
            break;
        }
    }
}

