/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class Escapes {
    private static final CharSequenceTranslator UNESCAPE_JAVA = new AggregateTranslator(new OctalUnescaper(), new UnicodeUnescaper(), new LookupTranslator(new String[][]{{"\\b", "\b"}, {"\\n", "\n"}, {"\\t", "\t"}, {"\\f", "\f"}, {"\\r", "\r"}}), new LookupTranslator(new String[][]{{"\\\\", "\\"}, {"\\\"", "\""}, {"\\'", "'"}, {"\\", ""}}));

    private Escapes() {
    }

    public static int unescapeJava(CharSequence from, int offset, Writer output) {
        return UNESCAPE_JAVA.translate(from, offset, output);
    }

    public static class LookupTranslator
    implements CharSequenceTranslator {
        private final Map<String, String> lookupMap = new HashMap<String, String>();
        private final Set<Character> prefixSet = new HashSet<Character>();
        private final int shortest;
        private final int longest;

        private LookupTranslator(String[][] lookup) {
            int _shortest = Integer.MAX_VALUE;
            int _longest = 0;
            if (lookup != null) {
                for (String[] seq : lookup) {
                    this.lookupMap.put(seq[0].toString(), seq[1].toString());
                    this.prefixSet.add(Character.valueOf(seq[0].charAt(0)));
                    int sz = seq[0].length();
                    if (sz < _shortest) {
                        _shortest = sz;
                    }
                    if (sz <= _longest) continue;
                    _longest = sz;
                }
            }
            this.shortest = _shortest;
            this.longest = _longest;
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) {
            if (this.prefixSet.contains(Character.valueOf(input.charAt(index)))) {
                int max = this.longest;
                if (index + this.longest > input.length()) {
                    max = input.length() - index;
                }
                for (int i = max; i >= this.shortest; --i) {
                    CharSequence subSeq = input.subSequence(index, index + i);
                    String result = this.lookupMap.get(subSeq.toString());
                    if (result == null) continue;
                    try {
                        out.write(result);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                    return i;
                }
            }
            return 0;
        }
    }

    public static class UnicodeUnescaper
    implements CharSequenceTranslator {
        @Override
        public int translate(CharSequence input, int index, Writer out) {
            if (input.charAt(index) == '\\' && index + 1 < input.length() && input.charAt(index + 1) == 'u') {
                int i = 2;
                while (index + i < input.length() && input.charAt(index + i) == 'u') {
                    ++i;
                }
                if (index + i < input.length() && input.charAt(index + i) == '+') {
                    ++i;
                }
                if (index + i + 4 <= input.length()) {
                    CharSequence unicode = input.subSequence(index + i, index + i + 4);
                    try {
                        int value = Integer.parseInt(unicode.toString(), 16);
                        out.write((char)value);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IllegalArgumentException("Unable to parse unicode value: " + unicode, nfe);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                    return i + 4;
                }
                throw new IllegalArgumentException("Less than 4 hex digits in unicode value: '" + input.subSequence(index, input.length()) + "' due to end of CharSequence");
            }
            return 0;
        }
    }

    private static class OctalUnescaper
    implements CharSequenceTranslator {
        private OctalUnescaper() {
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) {
            int remaining = input.length() - index - 1;
            StringBuilder builder = new StringBuilder();
            if (input.charAt(index) == '\\' && remaining > 0 && this.isOctalDigit(input.charAt(index + 1))) {
                int next = index + 1;
                int next2 = index + 2;
                int next3 = index + 3;
                builder.append(input.charAt(next));
                if (remaining > 1 && this.isOctalDigit(input.charAt(next2))) {
                    builder.append(input.charAt(next2));
                    if (remaining > 2 && this.isZeroToThree(input.charAt(next)) && this.isOctalDigit(input.charAt(next3))) {
                        builder.append(input.charAt(next3));
                    }
                }
                try {
                    out.write(Integer.parseInt(builder.toString(), 8));
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                return 1 + builder.length();
            }
            return 0;
        }

        private boolean isOctalDigit(char ch) {
            return ch >= '0' && ch <= '7';
        }

        private boolean isZeroToThree(char ch) {
            return ch >= '0' && ch <= '3';
        }
    }

    private static class AggregateTranslator
    implements CharSequenceTranslator {
        private final CharSequenceTranslator[] translators;

        private AggregateTranslator(CharSequenceTranslator ... translators) {
            this.translators = translators;
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) {
            for (CharSequenceTranslator translator : this.translators) {
                int consumed = translator.translate(input, index, out);
                if (consumed == 0) continue;
                return consumed;
            }
            return 0;
        }
    }

    protected static interface CharSequenceTranslator {
        public int translate(CharSequence var1, int var2, Writer var3);
    }
}

