/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.naming.context;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import org.apache.xbean.naming.context.AbstractContext;
import org.apache.xbean.naming.context.ContextAccess;
import org.apache.xbean.naming.context.ContextFederation;
import org.apache.xbean.naming.context.VirtualSubcontext;

public abstract class AbstractFederatedContext
extends AbstractContext {
    private final ContextFederation contextFederation;
    private final AbstractFederatedContext masterContext;

    public AbstractFederatedContext() {
        this("", ContextAccess.MODIFIABLE);
    }

    public AbstractFederatedContext(String nameInNamespace) {
        this(nameInNamespace, ContextAccess.MODIFIABLE);
    }

    public AbstractFederatedContext(String nameInNamespace, ContextAccess contextAccess) {
        super(nameInNamespace, contextAccess);
        this.masterContext = this;
        this.contextFederation = new ContextFederation(this);
    }

    public AbstractFederatedContext(String nameInNamespace, ContextAccess contextAccess, Set<Context> federatedContexts) {
        super(nameInNamespace, contextAccess);
        this.masterContext = this;
        this.contextFederation = new ContextFederation(this, federatedContexts);
    }

    public AbstractFederatedContext(AbstractFederatedContext masterContext, String nameInNamespace) throws NamingException {
        super(nameInNamespace, masterContext.getContextAccess());
        this.masterContext = masterContext;
        this.contextFederation = this.masterContext.contextFederation.createSubcontextFederation(nameInNamespace, this);
    }

    @Override
    protected Object faultLookup(String stringName, Name parsedName) {
        Object value = this.contextFederation.lookup(parsedName);
        if (value != null) {
            return value;
        }
        return super.faultLookup(stringName, parsedName);
    }

    @Override
    protected Object getDeepBinding(String name) {
        try {
            Object value = this.contextFederation.getFederatedBinding(name);
            if (value instanceof Context) {
                return null;
            }
            return value;
        }
        catch (NamingException e) {
            return null;
        }
    }

    @Override
    protected Object getBinding(String name) throws NamingException {
        Object value = this.contextFederation.getFederatedBinding(name);
        if (value instanceof Context) {
            return this.createNestedSubcontext(name, this.getBindings(name));
        }
        if (value == null) {
            value = this.getWrapperBindings().get(name);
        }
        return value;
    }

    @Override
    protected final Map<String, Object> getBindings() throws NamingException {
        return this.getBindings("");
    }

    protected final Map<String, Object> getBindings(String name) throws NamingException {
        Map<String, Object> bindings = this.contextFederation.getFederatedBindings(name);
        bindings.putAll(this.getWrapperBindings());
        return bindings;
    }

    protected abstract Map<String, Object> getWrapperBindings() throws NamingException;

    @Override
    protected boolean addBinding(String name, Object value, boolean rebind) throws NamingException {
        if (!(value instanceof Context) || this.isNestedSubcontext(value)) {
            return this.contextFederation.addBinding(name, value, rebind);
        }
        if (!this.isNestedSubcontext(value)) {
            Context federatedContext = (Context)value;
            Object existingValue = this.getBinding(name);
            if (existingValue != null) {
                if (!(existingValue instanceof AbstractFederatedContext)) {
                    throw new NameAlreadyBoundException(name);
                }
                AbstractFederatedContext nestedContext = (AbstractFederatedContext)existingValue;
                AbstractFederatedContext.addFederatedContext(nestedContext, federatedContext);
                return true;
            }
            AbstractFederatedContext nestedContext = (AbstractFederatedContext)this.createNestedSubcontext(name, Collections.emptyMap());
            AbstractFederatedContext.addFederatedContext(nestedContext, federatedContext);
            return this.addBinding(name, nestedContext, rebind);
        }
        return false;
    }

    @Override
    protected boolean removeBinding(String name, boolean removeNotEmptyContext) throws NamingException {
        return this.contextFederation.removeBinding(name);
    }

    protected static void addFederatedContext(AbstractFederatedContext wrappingContext, Context innerContext) throws NamingException {
        wrappingContext.contextFederation.addContext(innerContext);
        for (Map.Entry<String, Object> entry : wrappingContext.getWrapperBindings().entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof AbstractFederatedContext)) continue;
            AbstractFederatedContext nestedContext = (AbstractFederatedContext)value;
            Name parsedName = wrappingContext.getNameParser().parse(name);
            Name nameInNamespace = wrappingContext.getNameInNamespace(parsedName);
            VirtualSubcontext virtualSubcontext = new VirtualSubcontext(nameInNamespace, innerContext);
            AbstractFederatedContext.addFederatedContext(nestedContext, virtualSubcontext);
        }
    }

    protected static void removeFederatedContext(AbstractFederatedContext wrappingContext, Context innerContext) throws NamingException {
        wrappingContext.contextFederation.removeContext(innerContext);
        for (Map.Entry<String, Object> entry : wrappingContext.getWrapperBindings().entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (!(value instanceof AbstractFederatedContext)) continue;
            AbstractFederatedContext nestedContext = (AbstractFederatedContext)value;
            Name parsedName = wrappingContext.getNameParser().parse(name);
            Name nameInNamespace = wrappingContext.getNameInNamespace(parsedName);
            VirtualSubcontext virtualSubcontext = new VirtualSubcontext(nameInNamespace, innerContext);
            AbstractFederatedContext.removeFederatedContext(nestedContext, virtualSubcontext);
        }
    }

    @Override
    public boolean isNestedSubcontext(Object value) {
        if (value instanceof AbstractFederatedContext) {
            AbstractFederatedContext context = (AbstractFederatedContext)value;
            return this.getMasterContext() == context.getMasterContext();
        }
        return false;
    }

    protected AbstractFederatedContext getMasterContext() {
        return this.masterContext;
    }
}

