/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.impl.controller.chunk;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.batchee.container.impl.controller.chunk.CheckpointType;

public class CheckpointData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long _jobInstanceId;
    private CheckpointType type;
    private String stepName;
    private byte[] restartToken;

    public CheckpointData(long jobInstanceId, String stepname, CheckpointType ckType) {
        if (stepname != null && ckType != null) {
            this._jobInstanceId = jobInstanceId;
            this.type = ckType;
            this.stepName = stepname;
            try {
                this.restartToken = "NOTSET".getBytes("UTF8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Doesn't support UTF-8", e);
            }
        } else {
            throw new RuntimeException("Invalid parameters to CheckpointData jobInstanceId: " + this._jobInstanceId + " BDS: " + ckType + " stepName: " + stepname);
        }
    }

    public long getjobInstanceId() {
        return this._jobInstanceId;
    }

    public void setjobInstanceId(long id) {
        this._jobInstanceId = id;
    }

    public CheckpointType getType() {
        return this.type;
    }

    public void setType(CheckpointType ckType) {
        this.type = ckType;
    }

    public String getStepName() {
        return this.stepName;
    }

    public void setStepName(String name) {
        this.stepName = name;
    }

    public byte[] getRestartToken() {
        return this.restartToken;
    }

    public void setRestartToken(byte[] token) {
        this.restartToken = token;
    }

    public String toString() {
        String restartString;
        try {
            restartString = new String(this.restartToken, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            restartString = "<bytes not UTF-8>";
        }
        return " jobInstanceId: " + this._jobInstanceId + " stepId: " + this.stepName + " bdsName: " + this.type.name() + " restartToken: [UTF8-bytes: " + restartString;
    }
}

