/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.jsr223;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.jsr223.Customizer;
import org.apache.tinkerpop.gremlin.jsr223.GremlinLangScriptEngineFactory;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptContext;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineFactory;
import org.apache.tinkerpop.gremlin.jsr223.VariableResolverCustomizer;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinAntlrToJava;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinQueryParser;
import org.apache.tinkerpop.gremlin.language.grammar.VariableResolver;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;

public class GremlinLangScriptEngine
extends AbstractScriptEngine
implements GremlinScriptEngine {
    private volatile GremlinScriptEngineFactory factory;
    private final Function<Map<String, Object>, VariableResolver> variableResolverMaker;

    public GremlinLangScriptEngine() {
        this(new Customizer[0]);
    }

    public GremlinLangScriptEngine(Customizer ... customizers) {
        List<Customizer> listOfCustomizers = Arrays.asList(customizers);
        Optional<Customizer> opt = listOfCustomizers.stream().filter(c -> c instanceof VariableResolverCustomizer).findFirst();
        this.variableResolverMaker = opt.isPresent() ? ((VariableResolverCustomizer)opt.get()).getVariableResolverMaker() : VariableResolver.DirectVariableResolver::new;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GremlinScriptEngineFactory getFactory() {
        if (this.factory == null) {
            GremlinLangScriptEngine gremlinLangScriptEngine = this;
            synchronized (gremlinLangScriptEngine) {
                if (this.factory == null) {
                    this.factory = new GremlinLangScriptEngineFactory();
                }
            }
        }
        return this.factory;
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        Object o = context.getAttribute("g");
        if (!(o instanceof GraphTraversalSource)) {
            throw new IllegalArgumentException("g is of type " + o.getClass().getSimpleName() + " and is not an instance of TraversalSource");
        }
        Bindings m = context.getBindings(100);
        GremlinAntlrToJava antlr = new GremlinAntlrToJava((GraphTraversalSource)o, this.variableResolverMaker.apply(m));
        try {
            return GremlinQueryParser.parse(script, antlr);
        }
        catch (Exception ex) {
            throw new ScriptException(ex);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.readFully(reader), context);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    protected ScriptContext getScriptContext(Bindings nn) {
        GremlinScriptContext ctxt = new GremlinScriptContext(this.context.getReader(), this.context.getWriter(), this.context.getErrorWriter());
        Bindings gs = this.getBindings(200);
        if (gs != null) {
            ctxt.setBindings(gs, 200);
        }
        if (nn == null) {
            throw new NullPointerException("Engine scope Bindings may not be null.");
        }
        ctxt.setBindings(nn, 100);
        return ctxt;
    }

    private String readFully(Reader reader) throws ScriptException {
        char[] arr = new char[8192];
        StringBuilder buf = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                buf.append(arr, 0, numChars);
            }
        }
        catch (IOException exp) {
            throw new ScriptException(exp);
        }
        return buf.toString();
    }
}

