/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.AttributeKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class IdleConnectionHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(IdleConnectionHandler.class);
    public static final AttributeKey<IdleStateEvent> IDLE_STATE_EVENT = AttributeKey.valueOf((String)"idleStateEvent");

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            logger.info("Detected IdleStateEvent {} - closing channel {}", (Object)e, (Object)ctx.channel().id().asShortText());
            ctx.channel().attr(IDLE_STATE_EVENT).set((Object)e);
            ctx.close();
        }
    }
}

