/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.Seedable;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public class SeedStrategy
extends AbstractTraversalStrategy<TraversalStrategy.DecorationStrategy>
implements TraversalStrategy.DecorationStrategy {
    private final long seed;
    public static final String ID_SEED = "seed";

    private SeedStrategy(long seed) {
        this.seed = seed;
    }

    public long getSeed() {
        return this.seed;
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        List<Seedable> seedableSteps = TraversalHelper.getStepsOfAssignableClass(Seedable.class, traversal);
        for (Seedable seedableStepsToReset : seedableSteps) {
            seedableStepsToReset.resetSeed(this.seed);
        }
    }

    public static SeedStrategy create(Configuration configuration) {
        if (!configuration.containsKey(ID_SEED)) {
            throw new IllegalArgumentException("SeedStrategy configuration requires a 'seed' value");
        }
        return new SeedStrategy(Long.parseLong(configuration.getProperty(ID_SEED).toString()));
    }

    @Override
    public Configuration getConfiguration() {
        Configuration conf = super.getConfiguration();
        conf.setProperty(ID_SEED, (Object)this.seed);
        return conf;
    }

    public static Builder build() {
        return new Builder();
    }

    public static class Builder {
        private long seed = 0L;

        public Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public SeedStrategy create() {
            return new SeedStrategy(this.seed);
        }
    }
}

