/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;

public class HasContainer
implements Serializable,
Cloneable,
Predicate<Element> {
    private String key;
    private P predicate;
    private final boolean testingIdString;

    public HasContainer(String key, P<?> predicate) {
        this.key = key;
        this.predicate = predicate;
        this.testingIdString = this.isStringTestable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean test(Element element) {
        if (this.key != null) {
            if (this.key.equals(T.id.getAccessor())) {
                return this.testingIdString ? this.testIdAsString(element) : this.testId(element);
            }
            if (this.key.equals(T.label.getAccessor())) {
                return this.testLabel(element);
            }
        }
        Iterator itty = element.properties(this.key);
        try {
            while (itty.hasNext()) {
                if (!this.testValue(itty.next())) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            CloseableIterator.closeIterator(itty);
        }
        return false;
    }

    @Override
    public final boolean test(Property property) {
        if (this.key != null) {
            if (this.key.equals(T.value.getAccessor())) {
                return this.testValue(property);
            }
            if (this.key.equals(T.key.getAccessor())) {
                return this.testKey(property);
            }
        }
        if (property instanceof Element) {
            return this.test((Element)((Object)property));
        }
        return false;
    }

    protected boolean testId(Element element) {
        return this.predicate.test(element.id());
    }

    protected boolean testIdAsString(Element element) {
        return this.predicate.test(element.id().toString());
    }

    protected boolean testLabel(Element element) {
        return this.predicate.test(element.label());
    }

    protected boolean testValue(Property property) {
        return this.predicate.test(property.value());
    }

    protected boolean testKey(Property property) {
        return this.predicate.test(property.key());
    }

    public final String toString() {
        return Objects.toString(this.key) + "." + this.predicate;
    }

    public HasContainer clone() {
        try {
            HasContainer clone = (HasContainer)super.clone();
            clone.predicate = this.predicate.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public int hashCode() {
        return (this.key != null ? this.key.hashCode() : 0) ^ (this.predicate != null ? this.predicate.hashCode() : 0);
    }

    public final String getKey() {
        return this.key;
    }

    public final void setKey(String key) {
        this.key = key;
    }

    public final P<?> getPredicate() {
        return this.predicate;
    }

    public final BiPredicate<?, ?> getBiPredicate() {
        return this.predicate.getBiPredicate();
    }

    public final Object getValue() {
        return this.predicate.getValue();
    }

    private boolean isStringTestable() {
        if (this.key != null && this.key.equals(T.id.getAccessor())) {
            Collection collection;
            Object predicateValue;
            Object v0 = predicateValue = null == this.predicate ? null : this.predicate.getValue();
            if (predicateValue instanceof Collection && !(collection = (Collection)predicateValue).isEmpty()) {
                return ((Collection)predicateValue).stream().allMatch(c -> null == c || c instanceof String);
            }
            return predicateValue instanceof String;
        }
        return false;
    }

    public static <V> boolean testAll(Property<V> property, List<HasContainer> hasContainers) {
        return HasContainer.internalTestAll(property, hasContainers);
    }

    public static boolean testAll(Element element, List<HasContainer> hasContainers) {
        return HasContainer.internalTestAll(element, hasContainers);
    }

    private static <S> boolean internalTestAll(S element, List<HasContainer> hasContainers) {
        boolean isProperty = element instanceof Property;
        for (HasContainer hasContainer : hasContainers) {
            if (!(isProperty ? !hasContainer.test((Property)element) : !hasContainer.test((Element)element))) continue;
            return false;
        }
        return true;
    }
}

