/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValue;
import org.apache.tinkerpop.gremlin.process.traversal.step.GValueHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AddPropertyStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.AddPropertyStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SideEffectStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.GValueHelper;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Parameters;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.CallbackRegistry;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public class AddPropertyStepPlaceholder<S extends Element>
extends SideEffectStep<S>
implements AddPropertyStepContract<S>,
GValueHolder<S, S> {
    private Object key;
    private Object value;
    private VertexProperty.Cardinality cardinality;
    private Map<Object, List<Object>> properties = new HashMap<Object, List<Object>>();
    private Parameters withConfiguration = new Parameters();

    public AddPropertyStepPlaceholder(Traversal.Admin traversal, VertexProperty.Cardinality cardinality, Object keyObject, Object valueObject) {
        super(traversal);
        if (keyObject instanceof GValue) {
            throw new IllegalArgumentException("GValue is not allowed for property keys");
        }
        this.key = keyObject;
        if (this.key instanceof Traversal) {
            this.integrateChild(((Traversal)this.key).asAdmin());
        }
        if (valueObject instanceof GValue) {
            traversal.getGValueManager().register((GValue)valueObject);
        }
        this.value = valueObject;
        if (this.value instanceof Traversal) {
            this.integrateChild(((Traversal)this.value).asAdmin());
        }
        this.cardinality = cardinality;
    }

    @Override
    public Set<String> getScopeKeys() {
        return Collections.emptySet();
    }

    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        ArrayList childTraversals = new ArrayList();
        for (Map.Entry<Object, List<Object>> entry : this.properties.entrySet()) {
            if (entry.getKey() instanceof Traversal) {
                childTraversals.add(((Traversal)entry.getKey()).asAdmin());
            }
            for (Object value : entry.getValue()) {
                if (!(value instanceof Traversal)) continue;
                childTraversals.add(((Traversal)value).asAdmin());
            }
        }
        if (this.key != null && this.key instanceof Traversal) {
            childTraversals.add(((Traversal)this.key).asAdmin());
        }
        if (this.value != null && this.value instanceof Traversal) {
            childTraversals.add(((Traversal)this.value).asAdmin());
        }
        return childTraversals;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return this.getSelfAndChildRequirements(TraverserRequirement.OBJECT);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.getLocalChildren().forEach(this::integrateChild);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AddPropertyStepPlaceholder that = (AddPropertyStepPlaceholder)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && this.cardinality == that.cardinality && Objects.equals(this.properties, that.properties) && Objects.equals(this.withConfiguration, that.withConfiguration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.key, this.value, this.cardinality, this.properties, this.withConfiguration});
    }

    @Override
    protected void sideEffect(Traverser.Admin<S> traverser) {
        throw new IllegalStateException("AddPropertyStepPlaceholder is not executable");
    }

    @Override
    public VertexProperty.Cardinality getCardinality() {
        return this.cardinality;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Object getValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof GValue) {
            this.traversal.getGValueManager().pinVariable(((GValue)this.value).getName());
            return ((GValue)this.value).get();
        }
        return this.value;
    }

    @Override
    public Object getValueWithGValue() {
        return this.value;
    }

    @Override
    public AddPropertyStepPlaceholder<S> clone() {
        AddPropertyStepPlaceholder clone = (AddPropertyStepPlaceholder)super.clone();
        clone.cardinality = this.cardinality;
        clone.key = this.key instanceof Traversal ? ((Traversal)this.key).asAdmin().clone() : (this.key instanceof GValue ? ((GValue)this.key).clone() : this.key);
        clone.value = this.value instanceof Traversal ? ((Traversal)this.value).asAdmin().clone() : (this.value instanceof GValue ? ((GValue)this.value).clone() : this.value);
        clone.properties = new HashMap<Object, List<Object>>();
        for (Map.Entry<Object, List<Object>> entry : this.properties.entrySet()) {
            Object key = entry.getKey();
            List<Object> oldValues = entry.getValue();
            ArrayList<Object> newValues = new ArrayList<Object>(oldValues.size());
            for (Object v : oldValues) {
                if (v instanceof Traversal) {
                    newValues.add(((Traversal)v).asAdmin().clone());
                    continue;
                }
                if (v instanceof GValue) {
                    newValues.add(((GValue)v).clone());
                    continue;
                }
                newValues.add(v);
            }
            clone.properties.put(key, newValues);
        }
        return clone;
    }

    public AddPropertyStep<S> asConcreteStep() {
        AddPropertyStep step = new AddPropertyStep(this.traversal, this.cardinality, this.key, this.value instanceof GValue ? ((GValue)this.value).get() : this.value);
        for (Map.Entry<Object, List<Object>> entry : this.properties.entrySet()) {
            for (Object value : entry.getValue()) {
                step.addProperty(entry.getKey(), value instanceof GValue ? ((GValue)value).get() : value);
            }
        }
        for (Map.Entry<Object, List<Object>> entry : this.withConfiguration.getRaw(new Object[0]).entrySet()) {
            for (Object value : entry.getValue()) {
                step.configure(entry.getKey(), value);
            }
        }
        TraversalHelper.copyLabels(this, step, false);
        return step;
    }

    @Override
    public boolean isParameterized() {
        if (this.value instanceof GValue && ((GValue)this.value).isVariable()) {
            return true;
        }
        for (List<Object> list : this.properties.values()) {
            if (!GValue.containsVariables(list.toArray())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateVariable(String name, Object value) {
        if (this.value instanceof GValue && name.equals(((GValue)this.value).getName())) {
            this.value = GValue.of(name, value);
        }
        for (Map.Entry<Object, List<Object>> entry : this.properties.entrySet()) {
            for (Object propertyVal : entry.getValue()) {
                if (!(propertyVal instanceof GValue) || !name.equals(((GValue)propertyVal).getName())) continue;
                this.properties.put(entry.getKey(), Collections.singletonList(GValue.of(name, value)));
            }
        }
    }

    @Override
    public Collection<GValue<?>> getGValues() {
        Set<GValue<?>> gValues = GValueHelper.getGValuesFromProperties(this.properties);
        if (this.value instanceof GValue && ((GValue)this.value).isVariable()) {
            gValues.add((GValue)this.value);
        }
        return gValues;
    }

    @Override
    public void addProperty(Object key, Object value) {
        if (key instanceof GValue) {
            throw new IllegalArgumentException("GValue cannot be used as a property key");
        }
        if (key instanceof Traversal) {
            this.integrateChild(((Traversal)key).asAdmin());
        }
        if (value instanceof GValue) {
            this.traversal.getGValueManager().register((GValue)value);
        }
        if (value instanceof Traversal) {
            this.integrateChild(((Traversal)value).asAdmin());
        }
        if (this.properties.containsKey(key)) {
            throw new IllegalArgumentException("Only single value meta-properties are supported");
        }
        this.properties.put(key, Collections.singletonList(value));
    }

    @Override
    public Map<Object, List<Object>> getProperties() {
        return GValueHelper.resolveProperties(this.properties, gValue -> this.traversal.getGValueManager().pinVariable(gValue.getName()));
    }

    @Override
    public Map<Object, List<Object>> getPropertiesWithGValues() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public boolean removeProperty(Object k) {
        if (this.properties.containsKey(k)) {
            this.properties.remove(k);
            return true;
        }
        return false;
    }

    @Override
    public CallbackRegistry<Event.ElementPropertyChangedEvent> getMutatingCallbackRegistry() {
        throw new IllegalStateException("Cannot get mutating CallbackRegistry on GValue placeholder step");
    }

    @Override
    public void configure(Object ... keyValues) {
        this.withConfiguration.set(this, keyValues);
    }

    @Override
    public Parameters getParameters() {
        return this.withConfiguration;
    }
}

