/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class DateDiffStep<S>
extends ScalarMapStep<S, Long>
implements TraversalParent {
    private OffsetDateTime value;
    private Traversal.Admin<S, ?> dateTraversal;

    public DateDiffStep(Traversal.Admin traversal, Date value) {
        super(traversal);
        this.value = value == null ? null : value.toInstant().atOffset(ZoneOffset.UTC);
    }

    public DateDiffStep(Traversal.Admin traversal, OffsetDateTime value) {
        super(traversal);
        this.value = value;
    }

    public DateDiffStep(Traversal.Admin traversal, Traversal<?, ?> dateTraversal) {
        super(traversal);
        this.dateTraversal = this.integrateChild(dateTraversal.asAdmin());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Long map(Traverser.Admin<S> traverser) {
        OffsetDateTime otherDate;
        OffsetDateTime date;
        Object object = traverser.get();
        if (!(object instanceof OffsetDateTime)) {
            if (!(object instanceof Date)) throw new IllegalArgumentException(String.format("DateDiff can only take OffsetDateTime or Date (deprecated) as argument, encountered %s", object == null ? null : object.getClass()));
            date = ((Date)object).toInstant().atOffset(ZoneOffset.UTC);
        } else {
            date = (OffsetDateTime)object;
        }
        if (null == this.value && null != this.dateTraversal) {
            Object traversalDate = TraversalUtil.apply(traverser, this.dateTraversal);
            if (traversalDate == null) {
                otherDate = null;
                return otherDate == null ? date.toInstant().toEpochMilli() : Duration.between(otherDate, date).toMillis();
            } else if (traversalDate instanceof Date) {
                otherDate = ((Date)traversalDate).toInstant().atOffset(ZoneOffset.UTC);
                return otherDate == null ? date.toInstant().toEpochMilli() : Duration.between(otherDate, date).toMillis();
            } else {
                if (!(traversalDate instanceof OffsetDateTime)) throw new IllegalArgumentException(String.format("DateDiff can only take OffsetDateTime or Date (deprecated) as argument, encountered %s", object.getClass()));
                otherDate = (OffsetDateTime)traversalDate;
            }
            return otherDate == null ? date.toInstant().toEpochMilli() : Duration.between(otherDate, date).toMillis();
        } else {
            otherDate = this.value;
        }
        return otherDate == null ? date.toInstant().toEpochMilli() : Duration.between(otherDate, date).toMillis();
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }

    public List<Traversal.Admin<?, ?>> getLocalChildren() {
        return this.dateTraversal == null ? Collections.emptyList() : List.of(this.dateTraversal);
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        if (this.dateTraversal != null) {
            this.integrateChild(this.dateTraversal);
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : this.dateTraversal.hashCode());
        return result;
    }

    @Override
    public DateDiffStep<S> clone() {
        DateDiffStep clone = (DateDiffStep)super.clone();
        clone.value = this.value;
        clone.dateTraversal = null == this.dateTraversal ? null : this.dateTraversal.clone();
        return clone;
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, new Object[0]);
    }

    public OffsetDateTime getValue() {
        return this.value;
    }

    public Traversal.Admin<S, ?> getDateTraversal() {
        return this.dateTraversal;
    }
}

