/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.branch;

import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.Pick;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.branch.BranchStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.HasNextStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.IdentityStep;

public final class ChooseStep<S, E, M>
extends BranchStep<S, E, M> {
    private final ChooseSemantics chooseSemantics;
    private boolean hasDefaultUnproductive = true;
    private boolean hasDefaultNone = true;

    private ChooseStep(Traversal.Admin traversal, Traversal.Admin<S, M> choiceTraversal, ChooseSemantics chooseSemantics) {
        super(traversal);
        this.chooseSemantics = chooseSemantics;
        this.setBranchTraversal(choiceTraversal);
        DefaultGraphTraversal unproductivePassthrough = new DefaultGraphTraversal();
        unproductivePassthrough.addStep(new IdentityStep(traversal));
        DefaultGraphTraversal nonePassthrough = new DefaultGraphTraversal();
        nonePassthrough.addStep(new IdentityStep(traversal));
        super.addChildOption(Pick.unproductive, unproductivePassthrough);
        super.addChildOption(Pick.none, nonePassthrough);
    }

    public ChooseStep(Traversal.Admin traversal, Traversal.Admin<S, M> choiceTraversal) {
        this(traversal, choiceTraversal, ChooseSemantics.SWITCH);
    }

    public ChooseStep(Traversal.Admin traversal, Traversal.Admin<S, ?> predicateTraversal, Traversal.Admin<S, E> trueChoice, Traversal.Admin<S, E> falseChoice) {
        this(traversal, predicateTraversal.addStep(new HasNextStep(predicateTraversal)), ChooseSemantics.IF_THEN);
        this.addChildOption(Boolean.TRUE, trueChoice);
        this.addChildOption(Boolean.FALSE, falseChoice);
    }

    public ChooseSemantics getChooseSemantics() {
        return this.chooseSemantics;
    }

    @Override
    public void addChildOption(M pickToken, Traversal.Admin<S, E> traversalOption) {
        if (pickToken instanceof Pick) {
            if (Pick.any.equals(pickToken)) {
                throw new IllegalArgumentException("Choose step can not have an any-option as only one option per traverser is allowed");
            }
            if (Pick.unproductive.equals(pickToken) && this.hasDefaultUnproductive) {
                this.hasDefaultUnproductive = false;
                this.traversalPickOptions.remove(pickToken);
                super.addChildOption(pickToken, traversalOption);
            } else if (Pick.none.equals(pickToken) && this.hasDefaultNone) {
                this.hasDefaultNone = false;
                this.traversalPickOptions.remove(pickToken);
                super.addChildOption(pickToken, traversalOption);
            } else if (pickToken == Pick.none && !this.traversalPickOptions.containsKey((Object)Pick.none)) {
                super.addChildOption(pickToken, traversalOption);
            }
        } else {
            if (pickToken instanceof Traversal) {
                throw new IllegalArgumentException("Traversal is not allowed as a Pick token for choose().option()");
            }
            super.addChildOption(pickToken, traversalOption);
        }
    }

    @Override
    protected List<Traversal.Admin<S, E>> pickBranches(M choice) {
        List branches = super.pickBranches(choice);
        return branches != null ? branches.subList(0, 1) : null;
    }

    public static enum ChooseSemantics {
        IF_THEN,
        SWITCH;

    }
}

