/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.io.Serializable;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.PBiPredicate;

public class NotP<V>
extends P<V> {
    private P<V> originalP;

    public NotP(P<V> p) {
        super(null, null);
        if (null == p) {
            throw new IllegalArgumentException("Cannot negate a null P");
        }
        this.originalP = p;
        this.biPredicate = new NotPBiPredicate<V, V>(p.getBiPredicate());
    }

    @Override
    public V getValue() {
        return this.originalP.getValue();
    }

    @Override
    public void setValue(V value) {
        super.setValue(value);
        if (this.originalP != null) {
            this.originalP.setValue(value);
        }
    }

    @Override
    public String toString() {
        return null == this.getValue() ? this.biPredicate.toString() : String.format("not(%s(%s))", this.originalP.biPredicate.toString(), this.getValue());
    }

    @Override
    public P<V> negate() {
        return this.originalP;
    }

    @Override
    public P<V> clone() {
        return new NotP<V>(this.originalP.clone());
    }

    public static final class NotPBiPredicate<T, U>
    implements PBiPredicate<T, U>,
    Serializable {
        PBiPredicate<T, U> original;

        public NotPBiPredicate(PBiPredicate<T, U> predicate) {
            this.original = predicate;
        }

        @Override
        public boolean test(T t, U u) {
            return !this.original.test(t, u);
        }

        @Override
        public PBiPredicate<T, U> negate() {
            return this.original;
        }

        @Override
        public String getPredicateName() {
            return "not";
        }

        public PBiPredicate<T, U> getOriginal() {
            return this.original;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotPBiPredicate that = (NotPBiPredicate)o;
            return Objects.equals(this.original, that.original);
        }

        public int hashCode() {
            return Objects.hashCode(this.original);
        }

        public String toString() {
            return String.format("not(%s)", this.original.toString());
        }
    }
}

