/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.traverser;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.LabelledCounter;

public interface NL_SL_Traverser<T>
extends Traverser.Admin<T> {
    public TraverserRequirement getLoopRequirement();

    default public Stack<LabelledCounter> getNestedLoops() {
        throw new UnsupportedOperationException();
    }

    default public ReferenceMap getNestedLoopNames() {
        throw new UnsupportedOperationException();
    }

    default public short getSingleLoopCount() {
        throw new UnsupportedOperationException();
    }

    default public void setSingleLoopCount(short loops) {
        throw new UnsupportedOperationException();
    }

    default public String getSingleLoopName() {
        throw new UnsupportedOperationException();
    }

    default public void setSingleLoopName(String loopName) {
        throw new UnsupportedOperationException();
    }

    default public String getSingleLoopStepLabel() {
        throw new UnsupportedOperationException();
    }

    default public void setSingleLoopStepLabel(String stepLabel) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public void incrLoops() {
        if (TraverserRequirement.NESTED_LOOP.equals((Object)this.getValidLoopRequirement())) {
            this.getNestedLoops().peek().increment();
        } else {
            this.setSingleLoopCount((short)(this.getSingleLoopCount() + 1));
        }
    }

    @Override
    default public int loops() {
        return this.loops(null);
    }

    @Override
    default public int loops(String loopName) {
        if (TraverserRequirement.NESTED_LOOP.equals((Object)this.getValidLoopRequirement())) {
            return this.getNestedLoopCount(loopName);
        }
        if (loopName == null || Objects.equals(loopName, this.getSingleLoopName()) || Objects.equals(loopName, this.getSingleLoopStepLabel())) {
            return this.getSingleLoopCount();
        }
        throw new IllegalArgumentException("Single loop name not defined: " + loopName);
    }

    @Override
    default public void initialiseLoops(String stepLabel, String loopName) {
        if (TraverserRequirement.NESTED_LOOP.equals((Object)this.getValidLoopRequirement())) {
            this.initialiseNestedLoops(stepLabel, loopName);
        } else {
            this.setSingleLoopStepLabel(stepLabel);
            this.setSingleLoopName(loopName);
        }
    }

    @Override
    default public void resetLoops() {
        if (TraverserRequirement.NESTED_LOOP.equals((Object)this.getValidLoopRequirement())) {
            this.getNestedLoops().pop();
        } else {
            this.setSingleLoopCount((short)0);
        }
    }

    @Override
    default public Set<String> getLoopNames() {
        if (TraverserRequirement.NESTED_LOOP.equals((Object)this.getValidLoopRequirement())) {
            return this.getNestedLoopNames().keySet();
        }
        return Stream.of(this.getSingleLoopName(), this.getSingleLoopStepLabel()).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    default public TraverserRequirement getValidLoopRequirement() {
        TraverserRequirement loopRequirement = this.getLoopRequirement();
        if (!TraverserRequirement.SINGLE_LOOP.equals((Object)loopRequirement) && !TraverserRequirement.NESTED_LOOP.equals((Object)loopRequirement)) {
            throw new IllegalStateException("Invalid loop TraverserRequirement " + loopRequirement);
        }
        return loopRequirement;
    }

    default public void initialiseNestedLoops(String stepLabel, String loopName) {
        Stack<LabelledCounter> nestedLoops = this.getNestedLoops();
        ReferenceMap loopNames = this.getNestedLoopNames();
        if (nestedLoops.empty() || !nestedLoops.peek().hasLabel(stepLabel)) {
            LabelledCounter lc = new LabelledCounter(stepLabel, 0);
            nestedLoops.push(lc);
            loopNames.put((Object)stepLabel, (Object)lc);
            if (loopName != null && !loopName.equals(stepLabel)) {
                loopNames.put((Object)loopName, (Object)lc);
            }
        }
    }

    default public int getNestedLoopCount(String loopName) {
        if (loopName == null) {
            return this.getNestedLoops().peek().count();
        }
        if (this.getNestedLoopNames().containsKey((Object)loopName)) {
            return ((LabelledCounter)this.getNestedLoopNames().get((Object)loopName)).count();
        }
        throw new IllegalArgumentException("Nested loop name not defined: " + loopName);
    }

    default public void copyNestedLoops(Stack<LabelledCounter> targetNestedLoops, ReferenceMap targetLoopNames) {
        HashMap<LabelledCounter, LabelledCounter> counterMapping = new HashMap<LabelledCounter, LabelledCounter>();
        for (LabelledCounter original : this.getNestedLoops()) {
            LabelledCounter cloned = (LabelledCounter)original.clone();
            targetNestedLoops.push(cloned);
            counterMapping.put(original, cloned);
        }
        if (this.getNestedLoopNames() != null) {
            for (Object entry : this.getNestedLoopNames().entrySet()) {
                Map.Entry pair = (Map.Entry)entry;
                LabelledCounter original = (LabelledCounter)pair.getValue();
                LabelledCounter cloned = (LabelledCounter)counterMapping.get(original);
                if (cloned == null) continue;
                targetLoopNames.put(pair.getKey(), (Object)cloned);
            }
        }
    }
}

