/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import java.io.IOException;
import java.net.URL;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.http.BaseHttpConnection;
import org.apache.tez.http.HttpConnectionParams;
import org.apache.tez.runtime.library.common.TezRuntimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskAttemptFailedRunnable
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TaskAttemptFailedRunnable.class);
    private final NodeId nodeId;
    private final TezTaskAttemptID taskAttemptID;
    private final JobTokenSecretManager jobTokenSecretManager;
    private final int shufflePort;
    private final HttpConnectionParams httpConnectionParams;

    TaskAttemptFailedRunnable(NodeId nodeId, int shufflePort, TezTaskAttemptID taskAttemptID, HttpConnectionParams httpConnectionParams, JobTokenSecretManager jobTokenSecretMgr) {
        this.nodeId = nodeId;
        this.shufflePort = shufflePort;
        this.taskAttemptID = taskAttemptID;
        this.httpConnectionParams = httpConnectionParams;
        this.jobTokenSecretManager = jobTokenSecretMgr;
    }

    @Override
    public void run() {
        BaseHttpConnection httpConnection = null;
        try {
            URL baseURL = TezRuntimeUtils.constructBaseURIForShuffleHandlerTaskAttemptFailed((String)this.nodeId.getHost(), (int)this.shufflePort, (String)this.taskAttemptID.getTaskID().getVertexID().getDAGID().getApplicationId().toString(), (int)this.taskAttemptID.getTaskID().getVertexID().getDAGID().getId(), (String)this.taskAttemptID.toString(), (boolean)this.httpConnectionParams.isSslShuffle());
            httpConnection = TezRuntimeUtils.getHttpConnection((boolean)true, (URL)baseURL, (HttpConnectionParams)this.httpConnectionParams, (String)"FailedTaskAttemptDelete", (JobTokenSecretManager)this.jobTokenSecretManager);
            httpConnection.connect();
            httpConnection.getInputStream();
        }
        catch (Exception e) {
            LOG.warn("Could not setup HTTP Connection to the node " + this.nodeId.getHost() + " for failed task attempt delete. ", (Throwable)e);
        }
        finally {
            try {
                if (httpConnection != null) {
                    httpConnection.cleanup(true);
                }
            }
            catch (IOException ioe) {
                LOG.warn("Encountered IOException for " + this.nodeId.getHost() + " during close. ", (Throwable)ioe);
            }
        }
    }

    public String toString() {
        return "TaskAttemptFailedRunnable nodeId=" + this.nodeId + ", shufflePort=" + this.shufflePort + ", taskAttemptId=" + this.taskAttemptID.toString();
    }
}

