/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceOperations;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.log4j.helpers.ThreadLocalMap;
import org.apache.tez.Utils;
import org.apache.tez.client.CallerContext;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.common.AsyncDispatcher;
import org.apache.tez.common.AsyncDispatcherConcurrent;
import org.apache.tez.common.ContainerSignatureMatcher;
import org.apache.tez.common.GcTimeUpdater;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.TezClassLoader;
import org.apache.tez.common.TezCommonUtils;
import org.apache.tez.common.TezConverterUtils;
import org.apache.tez.common.TezUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.DAGCounter;
import org.apache.tez.common.counters.Limits;
import org.apache.tez.common.security.ACLManager;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.common.security.TokenCache;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.client.DAGClientHandler;
import org.apache.tez.dag.api.client.DAGClientServer;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ClusterInfo;
import org.apache.tez.dag.app.ContainerHeartbeatHandler;
import org.apache.tez.dag.app.DAGAppMasterReadinessService;
import org.apache.tez.dag.app.DAGAppMasterState;
import org.apache.tez.dag.app.RecoveryParser;
import org.apache.tez.dag.app.TaskCommunicatorManager;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.TaskHeartbeatHandler;
import org.apache.tez.dag.app.TezDagVersionInfo;
import org.apache.tez.dag.app.dag.DAG;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.DAGTerminationCause;
import org.apache.tez.dag.app.dag.Task;
import org.apache.tez.dag.app.dag.TaskAttempt;
import org.apache.tez.dag.app.dag.Vertex;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEvent;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventDAGFinished;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventDagCleanup;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventSchedulingServiceError;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventType;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventUserServiceFatalError;
import org.apache.tez.dag.app.dag.event.DAGEvent;
import org.apache.tez.dag.app.dag.event.DAGEventInternalError;
import org.apache.tez.dag.app.dag.event.DAGEventRecoverEvent;
import org.apache.tez.dag.app.dag.event.DAGEventStartDag;
import org.apache.tez.dag.app.dag.event.DAGEventTerminateDag;
import org.apache.tez.dag.app.dag.event.DAGEventType;
import org.apache.tez.dag.app.dag.event.SpeculatorEvent;
import org.apache.tez.dag.app.dag.event.SpeculatorEventType;
import org.apache.tez.dag.app.dag.event.TaskAttemptEvent;
import org.apache.tez.dag.app.dag.event.TaskAttemptEventType;
import org.apache.tez.dag.app.dag.event.TaskEvent;
import org.apache.tez.dag.app.dag.event.TaskEventType;
import org.apache.tez.dag.app.dag.event.VertexEvent;
import org.apache.tez.dag.app.dag.event.VertexEventType;
import org.apache.tez.dag.app.dag.impl.DAGImpl;
import org.apache.tez.dag.app.launcher.ContainerLauncherManager;
import org.apache.tez.dag.app.rm.AMSchedulerEventType;
import org.apache.tez.dag.app.rm.ContainerLauncherEventType;
import org.apache.tez.dag.app.rm.TaskSchedulerManager;
import org.apache.tez.dag.app.rm.container.AMContainerEventType;
import org.apache.tez.dag.app.rm.container.AMContainerMap;
import org.apache.tez.dag.app.rm.container.ContainerContextMatcher;
import org.apache.tez.dag.app.rm.node.AMNodeEventType;
import org.apache.tez.dag.app.rm.node.AMNodeTracker;
import org.apache.tez.dag.app.web.WebUIService;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEventHandler;
import org.apache.tez.dag.history.events.AMLaunchedEvent;
import org.apache.tez.dag.history.events.AMStartedEvent;
import org.apache.tez.dag.history.events.AppLaunchedEvent;
import org.apache.tez.dag.history.events.DAGKillRequestEvent;
import org.apache.tez.dag.history.events.DAGRecoveredEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.utils.DAGUtils;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.dag.utils.RelocalizationUtils;
import org.apache.tez.dag.utils.Simple2LevelVersionComparator;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.apache.tez.hadoop.shim.HadoopShimsLoader;
import org.apache.tez.runtime.TezThreadDumpHelper;
import org.apache.tez.util.LoggingUtils;
import org.apache.tez.util.TezMxBeanResourceCalculator;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAGAppMaster
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(DAGAppMaster.class);
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    @VisibleForTesting
    static final String INVALID_SESSION_ERR_MSG = "Initial application attempt in session mode failed. Application cannot recover and continue properly as DAG recovery has been disabled";
    private Clock clock;
    private final boolean isSession;
    private long appsStartTime;
    private final long startTime;
    private final long appSubmitTime;
    private String appName;
    private final ApplicationAttemptId appAttemptID;
    private final ContainerId containerID;
    private final String nmHost;
    private final int nmPort;
    private final int nmHttpPort;
    private final String workingDirectory;
    private final String[] localDirs;
    private final String[] logDirs;
    private final DAGProtos.AMPluginDescriptorProto amPluginDescriptorProto;
    private HadoopShim hadoopShim;
    private ContainerSignatureMatcher containerSignatureMatcher;
    private AMContainerMap containers;
    private AMNodeTracker nodes;
    private AppContext context;
    private Configuration amConf;
    private AsyncDispatcher dispatcher;
    private ContainerLauncherManager containerLauncherManager;
    private ContainerHeartbeatHandler containerHeartbeatHandler;
    private TaskHeartbeatHandler taskHeartbeatHandler;
    private TaskCommunicatorManagerInterface taskCommunicatorManager;
    private JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
    private Token<JobTokenIdentifier> sessionToken;
    private DagEventDispatcher dagEventDispatcher;
    private VertexEventDispatcher vertexEventDispatcher;
    private TaskSchedulerManager taskSchedulerManager;
    private DAGAppMasterReadinessService appMasterReadinessService;
    private WebUIService webUIService;
    private HistoryEventHandler historyEventHandler;
    private final Map<String, LocalResource> amResources = new HashMap<String, LocalResource>();
    private final Map<String, LocalResource> cumulativeAdditionalResources = new HashMap<String, LocalResource>();
    private final List<String> diagnostics = new ArrayList<String>();
    private String containerLogs;
    private boolean isLocal = false;
    private long clientAMHeartbeatTimeoutIntervalMillis = -1L;
    @VisibleForTesting
    protected DAGAppMasterShutdownHandler shutdownHandler;
    private final AtomicBoolean shutdownHandlerRunning = new AtomicBoolean(false);
    private DAGAppMasterState state;
    DAGClientServer clientRpcServer;
    private DAGClientHandler clientHandler;
    private DAG currentDAG;
    private final Credentials amCredentials;
    private final UserGroupInformation appMasterUgi;
    private AtomicBoolean sessionStopped = new AtomicBoolean(false);
    private final Object idleStateLock = new Object();
    private long sessionTimeoutInterval;
    private long lastDAGCompletionTime;
    private Timer dagSubmissionTimer;
    private ScheduledExecutorService clientAMHeartBeatTimeoutService;
    private boolean recoveryEnabled;
    private Path recoveryDataDir;
    private Path currentRecoveryDataDir;
    private Path tezSystemStagingDir;
    private FileSystem recoveryFS;
    private ListeningExecutorService execService;
    private final BiMap<String, Integer> taskSchedulers = HashBiMap.create();
    private final BiMap<String, Integer> containerLaunchers = HashBiMap.create();
    private final BiMap<String, Integer> taskCommunicators = HashBiMap.create();
    Set<String> dagIDs = new HashSet<String>();
    protected boolean isLastAMRetry = false;
    private final AtomicInteger dagCounter = new AtomicInteger();
    private final AtomicInteger submittedDAGs = new AtomicInteger();
    private final AtomicInteger successfulDAGs = new AtomicInteger();
    private final AtomicInteger failedDAGs = new AtomicInteger();
    private final AtomicInteger killedDAGs = new AtomicInteger();
    private ACLManager aclManager;
    private TezDagVersionInfo dagVersionInfo;
    private String clientVersion;
    private boolean versionMismatch = false;
    private String versionMismatchDiagnostics;
    private ResourceCalculatorProcessTree cpuPlugin;
    private GcTimeUpdater gcPlugin;
    Map<Service, ServiceWithDependency> services = new LinkedHashMap<Service, ServiceWithDependency>();
    private ThreadLocalMap mdcContext;
    private TezThreadDumpHelper tezThreadDumpHelper = TezThreadDumpHelper.NOOP_TEZ_THREAD_DUMP_HELPER;

    public DAGAppMaster(ApplicationAttemptId applicationAttemptId, ContainerId containerId, String nmHost, int nmPort, int nmHttpPort, Clock clock, long appSubmitTime, boolean isSession, String workingDirectory, String[] localDirs, String[] logDirs, String clientVersion, Credentials credentials, String jobUserName, DAGProtos.AMPluginDescriptorProto pluginDescriptorProto) {
        super(DAGAppMaster.class.getName());
        this.mdcContext = LoggingUtils.setupLog4j();
        this.clock = clock;
        this.startTime = clock.getTime();
        this.appSubmitTime = appSubmitTime;
        this.appAttemptID = applicationAttemptId;
        this.containerID = containerId;
        this.nmHost = nmHost;
        this.nmPort = nmPort;
        this.nmHttpPort = nmHttpPort;
        this.state = DAGAppMasterState.NEW;
        this.isSession = isSession;
        this.workingDirectory = workingDirectory;
        this.localDirs = localDirs;
        this.logDirs = logDirs;
        this.shutdownHandler = this.createShutdownHandler();
        this.dagVersionInfo = new TezDagVersionInfo();
        this.clientVersion = clientVersion;
        this.amCredentials = credentials;
        this.amPluginDescriptorProto = pluginDescriptorProto;
        this.appMasterUgi = UserGroupInformation.createRemoteUser((String)jobUserName);
        this.appMasterUgi.addCredentials(this.amCredentials);
        this.containerLogs = DAGAppMaster.getRunningLogURL(this.nmHost + ":" + this.nmHttpPort, this.containerID.toString(), this.appMasterUgi.getShortUserName());
        LOG.info("Created DAGAppMaster for application " + applicationAttemptId + ", versionInfo=" + (Object)((Object)this.dagVersionInfo));
        TezCommonUtils.logCredentials((Logger)LOG, (Credentials)this.appMasterUgi.getCredentials(), (String)"am");
    }

    private static String getRunningLogURL(String nodeHttpAddress, String containerId, String user) {
        if (containerId.isEmpty() || user == null | user.isEmpty()) {
            return null;
        }
        return String.format("%s/node/containerlogs/%s/%s", nodeHttpAddress, containerId, user);
    }

    private void initResourceCalculatorPlugins() {
        Class clazz = this.amConf.getClass("tez.task.resource.calculator.process-tree.class", TezMxBeanResourceCalculator.class, ResourceCalculatorProcessTree.class);
        String pid = System.getenv().get("JVM_PID");
        if (pid == null || pid.length() == 0) {
            String processName = ManagementFactory.getRuntimeMXBean().getName();
            pid = processName.split("@")[0];
        }
        this.cpuPlugin = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)pid, (Class)clazz, (Configuration)this.amConf);
        this.gcPlugin = new GcTimeUpdater(null);
    }

    private long getAMCPUTime() {
        if (this.cpuPlugin != null) {
            this.cpuPlugin.updateProcessTree();
            return this.cpuPlugin.getCumulativeCpuTime();
        }
        return 0L;
    }

    private long getAMGCTime() {
        if (this.gcPlugin != null) {
            return this.gcPlugin.getCumulativaGcTime();
        }
        return 0L;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        Object sharedDispatcher;
        this.amConf = conf;
        this.initResourceCalculatorPlugins();
        this.hadoopShim = new HadoopShimsLoader(this.amConf).getHadoopShim();
        long sleepTimeBeforeSecs = this.amConf.getLong("tez.am.sleep.time.before.exit.millis", 5000L);
        if (sleepTimeBeforeSecs >= 0L) {
            this.shutdownHandler.setSleepTimeBeforeExit(sleepTimeBeforeSecs);
        }
        this.isLocal = conf.getBoolean("tez.local.mode", false);
        UserPayload defaultPayload = TezUtils.createUserPayloadFromConf((Configuration)this.amConf);
        LinkedList taskSchedulerDescriptors = Lists.newLinkedList();
        LinkedList containerLauncherDescriptors = Lists.newLinkedList();
        LinkedList taskCommunicatorDescriptors = Lists.newLinkedList();
        DAGAppMaster.parseAllPlugins(taskSchedulerDescriptors, this.taskSchedulers, containerLauncherDescriptors, this.containerLaunchers, taskCommunicatorDescriptors, this.taskCommunicators, this.amPluginDescriptorProto, this.isLocal, defaultPayload);
        LOG.info(this.buildPluginComponentLog(taskSchedulerDescriptors, this.taskSchedulers, "TaskSchedulers"));
        LOG.info(this.buildPluginComponentLog(containerLauncherDescriptors, this.containerLaunchers, "ContainerLaunchers"));
        LOG.info(this.buildPluginComponentLog(taskCommunicatorDescriptors, this.taskCommunicators, "TaskCommunicators"));
        boolean disableVersionCheck = conf.getBoolean("tez.am.disable.client-version-check", false);
        LOG.info("Comparing client version with AM version, clientVersion=" + this.clientVersion + ", AMVersion=" + this.dagVersionInfo.getVersion());
        Simple2LevelVersionComparator versionComparator = new Simple2LevelVersionComparator();
        if (versionComparator.compare(this.clientVersion, this.dagVersionInfo.getVersion()) != 0) {
            this.versionMismatchDiagnostics = "Incompatible versions found, clientVersion=" + this.clientVersion + ", AMVersion=" + this.dagVersionInfo.getVersion();
            this.addDiagnostic(this.versionMismatchDiagnostics);
            if (disableVersionCheck) {
                LOG.warn("Ignoring client-AM version mismatch as check disabled. " + this.versionMismatchDiagnostics);
            } else {
                LOG.error(this.versionMismatchDiagnostics);
                this.versionMismatch = true;
            }
        }
        this.dispatcher = this.createDispatcher();
        if (this.isLocal) {
            conf.setBoolean("tez.am.node-blacklisting.enabled", false);
            conf.set("tez.history.logging.service.class", "org.apache.tez.dag.history.logging.impl.SimpleHistoryLoggingService");
        } else {
            this.dispatcher.enableExitOnDispatchException();
        }
        String strAppId = this.appAttemptID.getApplicationId().toString();
        this.tezSystemStagingDir = TezCommonUtils.getTezSystemStagingPath((Configuration)conf, (String)strAppId);
        this.context = new RunningAppContext(conf);
        this.aclManager = new ACLManager(this.appMasterUgi.getShortUserName(), this.amConf);
        this.clientHandler = new DAGClientHandler(this);
        this.addIfService(this.dispatcher, false);
        this.recoveryDataDir = TezCommonUtils.getRecoveryPath((Path)this.tezSystemStagingDir, (Configuration)conf);
        this.recoveryFS = this.recoveryDataDir.getFileSystem(conf);
        this.currentRecoveryDataDir = TezCommonUtils.getAttemptRecoveryPath((Path)this.recoveryDataDir, (int)this.appAttemptID.getAttemptId());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stage directory information for AppAttemptId :" + this.appAttemptID + " tezSystemStagingDir :" + this.tezSystemStagingDir + " recoveryDataDir :" + this.recoveryDataDir + " recoveryAttemptDir :" + this.currentRecoveryDataDir);
        }
        this.recoveryEnabled = conf.getBoolean("tez.dag.recovery.enabled", true);
        this.initClientRpcServer();
        this.taskHeartbeatHandler = this.createTaskHeartbeatHandler(this.context, conf);
        this.addIfService((Object)this.taskHeartbeatHandler, true);
        this.containerHeartbeatHandler = this.createContainerHeartbeatHandler(this.context, conf);
        this.addIfService((Object)this.containerHeartbeatHandler, true);
        this.sessionToken = TokenCache.getSessionToken((Credentials)this.amCredentials);
        if (this.sessionToken == null) {
            throw new RuntimeException("Could not find session token in AM Credentials");
        }
        this.jobTokenSecretManager.addTokenForJob(this.appAttemptID.getApplicationId().toString(), this.sessionToken);
        this.taskCommunicatorManager = this.createTaskCommunicatorManager(this.context, this.taskHeartbeatHandler, this.containerHeartbeatHandler, taskCommunicatorDescriptors);
        this.addIfService(this.taskCommunicatorManager, true);
        this.containerSignatureMatcher = this.createContainerSignatureMatcher();
        this.containers = new AMContainerMap(this.containerHeartbeatHandler, this.taskCommunicatorManager, this.containerSignatureMatcher, this.context);
        this.addIfService((Object)this.containers, true);
        this.dispatcher.register(AMContainerEventType.class, (EventHandler)this.containers);
        this.nodes = new AMNodeTracker(this.dispatcher.getEventHandler(), this.context);
        this.addIfService((Object)this.nodes, true);
        this.dispatcher.register(AMNodeEventType.class, (EventHandler)this.nodes);
        this.dagEventDispatcher = new DagEventDispatcher();
        this.vertexEventDispatcher = new VertexEventDispatcher();
        this.dispatcher.register(DAGAppMasterEventType.class, (EventHandler)new DAGAppMasterEventHandler());
        this.dispatcher.register(DAGEventType.class, (EventHandler)this.dagEventDispatcher);
        this.dispatcher.register(VertexEventType.class, (EventHandler)this.vertexEventDispatcher);
        boolean useConcurrentDispatcher = conf.getBoolean("tez.am.use.concurrent-dispatcher", TezConfiguration.TEZ_AM_USE_CONCURRENT_DISPATCHER_DEFAULT);
        LOG.info("Using concurrent dispatcher: " + useConcurrentDispatcher);
        if (!useConcurrentDispatcher) {
            this.dispatcher.register(TaskEventType.class, (EventHandler)new TaskEventDispatcher());
            this.dispatcher.register(TaskAttemptEventType.class, (EventHandler)new TaskAttemptEventDispatcher());
        } else {
            int concurrency = conf.getInt("tez.am.concurrent-dispatcher.concurrency", 10);
            sharedDispatcher = this.dispatcher.registerAndCreateDispatcher(TaskEventType.class, (EventHandler)new TaskEventDispatcher(), "TaskAndAttemptEventThread", concurrency);
            this.dispatcher.registerWithExistingDispatcher(TaskAttemptEventType.class, (EventHandler)new TaskAttemptEventDispatcher(), (AsyncDispatcherConcurrent)sharedDispatcher);
        }
        this.dispatcher.registerAndCreateDispatcher(SpeculatorEventType.class, (EventHandler)new SpeculatorEventHandler(), "Speculator");
        if (this.enableWebUIService()) {
            this.webUIService = new WebUIService(this.context);
            this.addIfService((Object)this.webUIService, false);
        } else {
            LOG.debug("Web UI Service is not enabled.");
        }
        this.taskSchedulerManager = this.createTaskSchedulerManager(taskSchedulerDescriptors);
        this.addIfService((Object)this.taskSchedulerManager, true);
        if (this.enableWebUIService()) {
            this.addIfServiceDependency((Object)this.taskSchedulerManager, (Object)this.webUIService);
        }
        this.dispatcher.register(AMSchedulerEventType.class, (EventHandler)this.taskSchedulerManager);
        this.addIfServiceDependency((Object)this.taskSchedulerManager, (Object)this.clientRpcServer);
        this.appMasterReadinessService = this.createAppMasterReadinessService();
        this.containerLauncherManager = this.createContainerLauncherManager(containerLauncherDescriptors, this.isLocal);
        this.addIfService((Object)this.containerLauncherManager, true);
        this.dispatcher.register(ContainerLauncherEventType.class, (EventHandler)this.containerLauncherManager);
        this.historyEventHandler = this.createHistoryEventHandler(this.context);
        this.addIfService((Object)this.historyEventHandler, true);
        this.sessionTimeoutInterval = TezCommonUtils.getDAGSessionTimeout((Configuration)this.amConf);
        this.clientAMHeartbeatTimeoutIntervalMillis = TezCommonUtils.getAMClientHeartBeatTimeoutMillis((Configuration)this.amConf);
        if (!this.versionMismatch && this.isSession) {
            BufferedInputStream sessionResourcesStream = new BufferedInputStream(new FileInputStream(new File(this.workingDirectory, "tez.session.local-resources.pb")));
            sharedDispatcher = null;
            try {
                DAGProtos.PlanLocalResourcesProto amLocalResourceProto = DAGProtos.PlanLocalResourcesProto.parseDelimitedFrom((InputStream)sessionResourcesStream);
                this.amResources.putAll(DagTypeConverters.convertFromPlanLocalResources((DAGProtos.PlanLocalResourcesProto)amLocalResourceProto));
            }
            catch (Throwable amLocalResourceProto) {
                sharedDispatcher = amLocalResourceProto;
                throw amLocalResourceProto;
            }
            finally {
                if (sessionResourcesStream != null) {
                    if (sharedDispatcher != null) {
                        try {
                            sessionResourcesStream.close();
                        }
                        catch (Throwable amLocalResourceProto) {
                            ((Throwable)sharedDispatcher).addSuppressed(amLocalResourceProto);
                        }
                    } else {
                        sessionResourcesStream.close();
                    }
                }
            }
        }
        int threadCount = conf.getInt("tez.am.dag.appcontext.thread-count-limit", 10);
        ExecutorService rawExecutor = Executors.newFixedThreadPool(threadCount, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("App Shared Pool - #%d").build());
        this.execService = MoreExecutors.listeningDecorator((ExecutorService)rawExecutor);
        this.initServices(conf);
        super.serviceInit(conf);
        if (!this.versionMismatch) {
            if (this.appAttemptID.getAttemptId() == 1) {
                AppLaunchedEvent appLaunchedEvent = new AppLaunchedEvent(this.appAttemptID.getApplicationId(), this.startTime, this.appSubmitTime, this.appMasterUgi.getShortUserName(), this.amConf, this.dagVersionInfo);
                this.historyEventHandler.handle(new DAGHistoryEvent(appLaunchedEvent));
            }
            AMLaunchedEvent launchedEvent = new AMLaunchedEvent(this.appAttemptID, this.startTime, this.appSubmitTime, this.appMasterUgi.getShortUserName());
            this.historyEventHandler.handle(new DAGHistoryEvent(launchedEvent));
            this.state = DAGAppMasterState.INITED;
        } else {
            this.state = DAGAppMasterState.ERROR;
        }
    }

    protected void initClientRpcServer() {
        this.clientRpcServer = new DAGClientServer(this.clientHandler, this.appAttemptID, this.recoveryFS);
        this.addIfService((Object)this.clientRpcServer, true);
    }

    @VisibleForTesting
    protected DAGAppMasterShutdownHandler createShutdownHandler() {
        return new DAGAppMasterShutdownHandler();
    }

    @VisibleForTesting
    protected TaskSchedulerManager createTaskSchedulerManager(List<NamedEntityDescriptor> taskSchedulerDescriptors) {
        return new TaskSchedulerManager(this.context, this.clientRpcServer, this.dispatcher.getEventHandler(), this.containerSignatureMatcher, this.webUIService, taskSchedulerDescriptors, this.isLocal, this.hadoopShim);
    }

    @VisibleForTesting
    protected DAGAppMasterReadinessService createAppMasterReadinessService() {
        DAGAppMasterReadinessService service = new DAGAppMasterReadinessService(DAGAppMasterReadinessService.class.getName());
        this.addIfService((Object)service, false);
        this.addIfServiceDependency((Object)service, (Object)this.taskSchedulerManager);
        return service;
    }

    @VisibleForTesting
    protected ContainerSignatureMatcher createContainerSignatureMatcher() {
        return new ContainerContextMatcher();
    }

    @VisibleForTesting
    protected AsyncDispatcher createDispatcher() {
        return new AsyncDispatcher("Central");
    }

    @VisibleForTesting
    protected HistoryEventHandler createHistoryEventHandler(AppContext appContext) {
        return new HistoryEventHandler(appContext);
    }

    protected void sysexit() {
        if (!this.isLocal) {
            System.exit(0);
        }
    }

    @VisibleForTesting
    protected TaskSchedulerManager getTaskSchedulerManager() {
        return this.taskSchedulerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInternalError(String errDiagnosticsPrefix, String errDiagDagEvent) {
        this.state = DAGAppMasterState.ERROR;
        if (this.currentDAG != null) {
            this.updateLoggers(this.currentDAG, "_post");
            LOG.info(errDiagnosticsPrefix + ". Aborting dag: " + this.currentDAG.getID());
            this.sendEvent((Event<?>)new DAGEventInternalError(this.currentDAG.getID(), errDiagDagEvent));
        } else {
            LOG.info(errDiagnosticsPrefix + ". AppMaster will exit as no dag is active");
            try {
                this.taskSchedulerManager.setShouldUnregisterFlag();
            }
            catch (Exception e) {
                LOG.error("Error when trying to set unregister flag for TaskScheduler", (Throwable)e);
            }
            finally {
                this.shutdownHandler.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected synchronized void handle(DAGAppMasterEvent event) {
        switch ((DAGAppMasterEventType)event.getType()) {
            case SCHEDULING_SERVICE_ERROR: {
                DAGAppMasterEventSchedulingServiceError schedulingServiceErrorEvent = (DAGAppMasterEventSchedulingServiceError)event;
                this.state = DAGAppMasterState.ERROR;
                String errDiagnostics = "Error in the TaskScheduler. Shutting down. ";
                this.addDiagnostic(errDiagnostics + "Error=" + schedulingServiceErrorEvent.getDiagnosticInfo());
                LOG.error(errDiagnostics);
                this.shutdownHandler.shutdown();
                break;
            }
            case TASK_COMMUNICATOR_SERVICE_FATAL_ERROR: 
            case CONTAINER_LAUNCHER_SERVICE_FATAL_ERROR: 
            case TASK_SCHEDULER_SERVICE_FATAL_ERROR: {
                DAGAppMasterEventUserServiceFatalError usfe = (DAGAppMasterEventUserServiceFatalError)event;
                Throwable error = usfe.getError();
                String errDiagnostics = "Service Error: " + usfe.getDiagnosticInfo() + ", eventType=" + event.getType() + ", exception=" + (usfe.getError() == null ? "None" : ExceptionUtils.getStackTrace((Throwable)usfe.getError()));
                LOG.error(errDiagnostics, error);
                this.addDiagnostic(errDiagnostics);
                this.handleInternalError("Service error: " + event.getType(), errDiagnostics);
                break;
            }
            case INTERNAL_ERROR: {
                this.handleInternalError("DAGAppMaster Internal Error occurred", "DAGAppMaster Internal Error occurred");
                break;
            }
            case DAG_FINISHED: {
                this.tezThreadDumpHelper.stop();
                DAGAppMasterEventDAGFinished finishEvt = (DAGAppMasterEventDAGFinished)event;
                String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
                System.err.println(timeStamp + " Completed Dag: " + finishEvt.getDAGId());
                System.out.println(timeStamp + " Completed Dag: " + finishEvt.getDAGId());
                this.currentDAG.onFinish();
                if (!this.isSession) {
                    LOG.info("Not a session, AM will unregister as DAG has completed");
                    this.taskSchedulerManager.setShouldUnregisterFlag();
                    this.updateLoggers(this.currentDAG, "_post");
                    this.setStateOnDAGCompletion();
                    LOG.info("Shutting down on completion of dag:" + finishEvt.getDAGId());
                    this.shutdownHandler.shutdown();
                } else {
                    LOG.info("DAG completed, dagId=" + finishEvt.getDAGId() + ", dagState=" + (Object)((Object)finishEvt.getDAGState()));
                    this.lastDAGCompletionTime = this.clock.getTime();
                    this.updateLoggers(this.currentDAG, "_post");
                    if (this.historyEventHandler.hasRecoveryFailed()) {
                        String recoveryErrorMsg = "Recovery had a fatal error, shutting down session after DAG completion";
                        LOG.warn(recoveryErrorMsg);
                        this.addDiagnostic(recoveryErrorMsg);
                        this.sessionStopped.set(true);
                    }
                    switch (finishEvt.getDAGState()) {
                        case SUCCEEDED: {
                            if (this.currentDAG.getName().startsWith("TezPreWarmDAG")) break;
                            this.successfulDAGs.incrementAndGet();
                            break;
                        }
                        case FAILED: {
                            if (this.currentDAG.getName().startsWith("TezPreWarmDAG")) break;
                            this.failedDAGs.incrementAndGet();
                            break;
                        }
                        case KILLED: {
                            if (this.currentDAG.getName().startsWith("TezPreWarmDAG")) break;
                            this.killedDAGs.incrementAndGet();
                            break;
                        }
                        case ERROR: {
                            if (!this.currentDAG.getName().startsWith("TezPreWarmDAG")) {
                                this.failedDAGs.incrementAndGet();
                            }
                        }
                        default: {
                            LOG.error("Received a DAG Finished Event with state=" + (Object)((Object)finishEvt.getDAGState()) + ". Error. Shutting down.");
                            this.addDiagnostic("DAG completed with an ERROR state. Shutting down AM");
                            this.state = DAGAppMasterState.ERROR;
                            this.taskSchedulerManager.setShouldUnregisterFlag();
                            this.shutdownHandler.shutdown();
                        }
                    }
                    if (!this.state.equals((Object)DAGAppMasterState.ERROR)) {
                        if (!this.sessionStopped.get()) {
                            LOG.info("Central Dispatcher queue size after DAG completion, before cleanup: " + this.dispatcher.getQueueSize());
                            LOG.info("Waiting for next DAG to be submitted.");
                            this.sendEvent((Event<?>)new DAGAppMasterEventDagCleanup(this.context.getCurrentDAG()));
                            this.taskSchedulerManager.dagCompleted();
                        } else {
                            LOG.info("Session shutting down now.");
                            this.taskSchedulerManager.setShouldUnregisterFlag();
                            this.state = this.historyEventHandler.hasRecoveryFailed() ? DAGAppMasterState.FAILED : DAGAppMasterState.SUCCEEDED;
                            this.shutdownHandler.shutdown();
                        }
                    }
                }
                try {
                    FileSystem.closeAllForUGI((UserGroupInformation)this.context.getCurrentDAG().getDagUGI());
                }
                catch (IOException e) {
                    LOG.warn("Error occurred when trying to close FileSystem for userName " + this.context.getCurrentDAG().getDagUGI().getUserName(), (Throwable)e);
                }
                break;
            }
            case AM_REBOOT: {
                LOG.info("Received an AM_REBOOT signal");
                this.state = DAGAppMasterState.KILLED;
                this.shutdownHandler.shutdown(true);
                break;
            }
            case DAG_CLEANUP: {
                DAGAppMasterEventDagCleanup cleanupEvent = (DAGAppMasterEventDagCleanup)event;
                LOG.info("Cleaning up DAG: name=" + cleanupEvent.getDag().getName() + ", with id=" + cleanupEvent.getDag().getID());
                this.containerLauncherManager.dagComplete(cleanupEvent.getDag().getID(), this.jobTokenSecretManager);
                this.taskCommunicatorManager.dagComplete(cleanupEvent.getDag());
                this.nodes.dagComplete(cleanupEvent.getDag());
                this.containers.dagComplete(cleanupEvent.getDag());
                LOG.info("Completed cleanup for DAG: name=" + cleanupEvent.getDag().getName() + ", with id=" + cleanupEvent.getDag().getID());
                Object object = this.idleStateLock;
                synchronized (object) {
                    this.state = DAGAppMasterState.IDLE;
                    this.idleStateLock.notify();
                    break;
                }
            }
            case NEW_DAG_SUBMITTED: {
                this.taskSchedulerManager.dagSubmitted();
                this.containerLauncherManager.dagSubmitted();
                this.taskCommunicatorManager.dagSubmitted();
                break;
            }
            default: {
                throw new TezUncheckedException("AppMaster: No handler for event type: " + event.getType());
            }
        }
    }

    private void updateLoggers(DAG dag, String appender) {
        try {
            TezUtilsInternal.updateLoggers((Configuration)dag.getConf(), (String)(dag.getID().toString() + appender), (String)LoggingUtils.getPatternForAM((Configuration)dag.getConf()));
        }
        catch (FileNotFoundException e) {
            LOG.warn("Unable to update the logger. Continue with the old logger", (Throwable)e);
        }
    }

    public void setCurrentDAG(DAG currentDAG) {
        this.currentDAG = currentDAG;
        this.context.setDAG(currentDAG);
    }

    public ACLManager getACLManager() {
        return this.aclManager;
    }

    protected DAG createDAG(DAGProtos.DAGPlan dagPB) {
        return this.createDAG(dagPB, null);
    }

    DAGImpl createDAG(DAGProtos.DAGPlan dagPB, TezDAGID dagId) {
        if (dagId == null) {
            dagId = TezDAGID.getInstance((ApplicationId)this.appAttemptID.getApplicationId(), (int)this.dagCounter.incrementAndGet());
        }
        Credentials dagCredentials = null;
        if (dagPB.hasCredentialsBinary()) {
            dagCredentials = DagTypeConverters.convertByteStringToCredentials((ByteString)dagPB.getCredentialsBinary());
            TezCommonUtils.logCredentials((Logger)LOG, (Credentials)dagCredentials, (String)"dag");
        } else {
            dagCredentials = new Credentials();
        }
        if (this.getConfig().getBoolean("tez.am.credentials-merge", TezConfiguration.TEZ_AM_CREDENTIALS_MERGE_DEFAULT)) {
            LOG.info("Merging AM credentials into DAG credentials");
            dagCredentials.mergeAll(this.amCredentials);
        }
        TokenCache.setSessionToken(this.sessionToken, (Credentials)dagCredentials);
        TezCommonUtils.logCredentials((Logger)LOG, (Credentials)dagCredentials, (String)"newDag");
        DAGImpl newDag = new DAGImpl(dagId, this.amConf, dagPB, this.dispatcher.getEventHandler(), this.taskCommunicatorManager, dagCredentials, this.clock, this.appMasterUgi.getShortUserName(), this.taskHeartbeatHandler, this.context).setLogDirs(this.logDirs);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("JSON dump for submitted DAG, dagId=" + dagId + ", json=" + DAGUtils.generateSimpleJSONPlan(dagPB));
            }
        }
        catch (JSONException e) {
            LOG.warn("Failed to generate json for DAG", (Throwable)e);
        }
        this.writeDebugArtifacts(dagPB, newDag);
        return newDag;
    }

    private void writeDebugArtifacts(DAGProtos.DAGPlan dagPB, DAGImpl newDag) {
        boolean debugArtifacts = newDag.getConf().getBoolean("tez.generate.debug.artifacts", false);
        if (debugArtifacts) {
            Utils.generateDAGVizFile(newDag, dagPB, this.logDirs, newDag.getDAGScheduler());
            this.writePBTextFile(newDag);
        }
    }

    private void writePBTextFile(DAG dag) {
        String logFile = this.logDirs[new Random().nextInt(this.logDirs.length)] + File.separatorChar + dag.getID() + "-" + "tez-dag.pb.txt";
        LOG.info("Writing DAG plan to: " + logFile);
        File outFile = new File(logFile);
        try {
            PrintWriter printWriter = new PrintWriter(outFile, "UTF-8");
            printWriter.println(TezUtilsInternal.convertDagPlanToString((DAGProtos.DAGPlan)dag.getJobPlan()));
            printWriter.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to write TEZ_PLAN to " + outFile, (Throwable)e);
        }
    }

    protected void addIfService(Object object, boolean addDispatcher) {
        if (object instanceof Service) {
            Service service = (Service)object;
            ServiceWithDependency sd = new ServiceWithDependency(service);
            this.services.put(service, sd);
            if (addDispatcher) {
                this.addIfServiceDependency(service, this.dispatcher);
            }
        }
    }

    protected void addIfServiceDependency(Object object, Object dependency) {
        if (object instanceof Service && dependency instanceof Service) {
            Service service = (Service)object;
            Service dependencyService = (Service)dependency;
            ServiceWithDependency sd = this.services.get(service);
            sd.dependencies.add(dependencyService);
            dependencyService.registerServiceListener((ServiceStateChangeListener)sd);
        }
    }

    protected TaskCommunicatorManagerInterface createTaskCommunicatorManager(AppContext context, TaskHeartbeatHandler thh, ContainerHeartbeatHandler chh, List<NamedEntityDescriptor> entityDescriptors) throws TezException {
        TaskCommunicatorManager tcm = new TaskCommunicatorManager(context, thh, chh, entityDescriptors);
        return tcm;
    }

    protected TaskHeartbeatHandler createTaskHeartbeatHandler(AppContext context, Configuration conf) {
        TaskHeartbeatHandler thh = new TaskHeartbeatHandler(context, conf.getInt("tez.am.task.listener.thread-count", 30));
        return thh;
    }

    protected ContainerHeartbeatHandler createContainerHeartbeatHandler(AppContext context, Configuration conf) {
        ContainerHeartbeatHandler chh = new ContainerHeartbeatHandler(context, conf.getInt("tez.am.task.listener.thread-count", 30));
        return chh;
    }

    protected ContainerLauncherManager createContainerLauncherManager(List<NamedEntityDescriptor> containerLauncherDescriptors, boolean isLocal) throws UnknownHostException, TezException {
        return new ContainerLauncherManager(this.context, this.taskCommunicatorManager, this.workingDirectory, containerLauncherDescriptors, isLocal);
    }

    public ApplicationId getAppID() {
        return this.appAttemptID.getApplicationId();
    }

    public ApplicationAttemptId getAttemptID() {
        return this.appAttemptID;
    }

    public int getStartCount() {
        return this.appAttemptID.getAttemptId();
    }

    public AppContext getContext() {
        return this.context;
    }

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    public ContainerLauncherManager getContainerLauncherManager() {
        return this.containerLauncherManager;
    }

    public TaskCommunicatorManagerInterface getTaskCommunicatorManager() {
        return this.taskCommunicatorManager;
    }

    public ContainerId getAppContainerId() {
        return this.containerID;
    }

    public String getAppNMHost() {
        return this.nmHost;
    }

    public int getAppNMPort() {
        return this.nmPort;
    }

    public int getAppNMHttpPort() {
        return this.nmHttpPort;
    }

    public int getRpcPort() {
        return this.clientRpcServer.getBindAddress().getPort();
    }

    public DAGAppMasterState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDiagnostic(String diag) {
        List<String> list = this.diagnostics;
        synchronized (list) {
            this.diagnostics.add(diag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getDiagnostics() {
        ArrayList<String> diagResult = new ArrayList<String>();
        List<String> list = this.diagnostics;
        synchronized (list) {
            diagResult.addAll(this.diagnostics);
        }
        if (!this.isSession) {
            if (this.currentDAG != null) {
                diagResult.addAll(this.currentDAG.getDiagnostics());
            }
        } else {
            diagResult.add("Session stats:submittedDAGs=" + this.submittedDAGs.get() + ", successfulDAGs=" + this.successfulDAGs.get() + ", failedDAGs=" + this.failedDAGs.get() + ", killedDAGs=" + this.killedDAGs.get());
        }
        return diagResult;
    }

    public float getProgress() {
        if (this.isSession && this.getState().equals((Object)DAGAppMasterState.IDLE)) {
            return 0.0f;
        }
        if (this.currentDAG != null) {
            DAGState state = this.currentDAG.getState();
            switch (state) {
                case NEW: 
                case INITED: {
                    return 0.0f;
                }
                case RUNNING: {
                    return this.currentDAG.getProgress();
                }
                case SUCCEEDED: 
                case FAILED: 
                case KILLED: 
                case ERROR: 
                case TERMINATING: {
                    return 1.0f;
                }
            }
        }
        return 0.0f;
    }

    private synchronized void setStateOnDAGCompletion() {
        DAGAppMasterState oldState = this.state;
        if (this.isSession) {
            return;
        }
        switch (this.currentDAG.getState()) {
            case SUCCEEDED: {
                this.state = DAGAppMasterState.SUCCEEDED;
                break;
            }
            case FAILED: {
                this.state = DAGAppMasterState.FAILED;
                break;
            }
            case KILLED: {
                this.state = DAGAppMasterState.KILLED;
                break;
            }
            case ERROR: {
                this.state = DAGAppMasterState.ERROR;
                break;
            }
            default: {
                this.state = DAGAppMasterState.ERROR;
            }
        }
        LOG.info("On DAG completion. Old state: " + (Object)((Object)oldState) + " new state: " + (Object)((Object)this.state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownTezAM(String dagKillmessage) throws TezException {
        if (!this.sessionStopped.compareAndSet(false, true)) {
            return;
        }
        DAGAppMaster dAGAppMaster = this;
        synchronized (dAGAppMaster) {
            this.taskSchedulerManager.setShouldUnregisterFlag();
            if (this.currentDAG != null && !this.currentDAG.isComplete()) {
                LOG.info("Sending a kill event to the current DAG, dagId=" + this.currentDAG.getID());
                this.tryKillDAG(this.currentDAG, dagKillmessage);
            } else {
                LOG.info("No current running DAG, shutting down the AM");
                if (this.isSession && !this.state.equals((Object)DAGAppMasterState.ERROR)) {
                    this.state = DAGAppMasterState.SUCCEEDED;
                }
                this.shutdownHandler.shutdown();
            }
        }
    }

    void logDAGKillRequestEvent(final TezDAGID dagId, final boolean isSessionStopped) throws IOException {
        try {
            this.appMasterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    DAGKillRequestEvent killRequestEvent = new DAGKillRequestEvent(dagId, DAGAppMaster.this.clock.getTime(), isSessionStopped);
                    DAGAppMaster.this.historyEventHandler.handleCriticalEvent(new DAGHistoryEvent(dagId, killRequestEvent));
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String submitDAGToAppMaster(DAGProtos.DAGPlan dagPlan, Map<String, LocalResource> additionalResources) throws TezException {
        this.appMasterReadinessService.waitToBeReady();
        if (this.sessionStopped.get()) {
            throw new SessionNotRunning("AM unable to accept new DAG submissions. In the process of shutting down");
        }
        Object object = this.idleStateLock;
        synchronized (object) {
            while (this.currentDAG != null && this.currentDAG.isComplete() && this.state == DAGAppMasterState.RUNNING) {
                try {
                    LOG.info("wait for previous dag cleanup");
                    this.idleStateLock.wait();
                }
                catch (InterruptedException e) {
                    throw new TezException((Throwable)e);
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this.versionMismatch) {
                throw new TezException("Unable to accept DAG submissions as the ApplicationMaster is incompatible with the client. " + this.versionMismatchDiagnostics);
            }
            if (this.state.equals((Object)DAGAppMasterState.ERROR) || this.sessionStopped.get()) {
                throw new SessionNotRunning("AM unable to accept new DAG submissions. In the process of shutting down");
            }
            if (this.currentDAG != null && !this.currentDAG.isComplete()) {
                throw new TezException("App master already running a DAG");
            }
            LOG.info("Starting DAG submitted via RPC: " + dagPlan.getName());
            LOG.debug("Invoked with additional local resources: {}", additionalResources);
            if (!dagPlan.getName().startsWith("TezPreWarmDAG")) {
                this.submittedDAGs.incrementAndGet();
            }
            this.startDAG(dagPlan, additionalResources);
            return this.currentDAG.getID().toString();
        }
    }

    public void tryKillDAG(DAG dag, String message) throws TezException {
        try {
            this.logDAGKillRequestEvent(dag.getID(), false);
        }
        catch (IOException e) {
            throw new TezException((Throwable)e);
        }
        this.dispatcher.getEventHandler().handle((Event)new DAGEventTerminateDag(dag.getID(), DAGTerminationCause.DAG_KILL, message));
    }

    private Map<String, LocalResource> getAdditionalLocalResourceDiff(DAG dag, Map<String, LocalResource> additionalResources) throws TezException {
        if (additionalResources == null) {
            return Collections.emptyMap();
        }
        Iterator<Map.Entry<String, LocalResource>> lrIter = additionalResources.entrySet().iterator();
        while (lrIter.hasNext()) {
            Map.Entry<String, LocalResource> lrEntry = lrIter.next();
            LocalResource existing = this.amResources.get(lrEntry.getKey());
            if (existing == null) continue;
            if (!this.isSameFile(dag, lrEntry.getKey(), existing, lrEntry.getValue())) {
                throw new TezUncheckedException("Cannot add different additional resources with the same name : " + lrEntry.getKey() + ", Existing: [" + existing + "], New: [" + lrEntry.getValue() + "]");
            }
            lrIter.remove();
        }
        return this.containerSignatureMatcher.getAdditionalResources(this.amResources, additionalResources);
    }

    private boolean isSameFile(DAG dag, final String fileName, final LocalResource oldLr, final LocalResource newLr) throws TezException {
        try {
            return oldLr.equals(newLr) || (Boolean)dag.getDagUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    Configuration conf = DAGAppMaster.this.getConfig();
                    byte[] oldSha = null;
                    try {
                        Path localFile = DAGAppMaster.findLocalFileForResource(fileName);
                        if (localFile != null) {
                            oldSha = TezClientUtils.getLocalSha((Path)localFile, (Configuration)conf);
                        } else {
                            LOG.warn("Couldn't find local file for " + oldLr);
                        }
                    }
                    catch (Exception ex) {
                        LOG.warn("Error getting SHA from local file for " + oldLr, (Throwable)ex);
                    }
                    if (oldSha == null) {
                        oldSha = TezClientUtils.getResourceSha((URI)DAGAppMaster.getLocalResourceUri(oldLr), (Configuration)conf);
                    }
                    byte[] newSha = TezClientUtils.getResourceSha((URI)DAGAppMaster.getLocalResourceUri(newLr), (Configuration)conf);
                    return Arrays.equals(oldSha, newSha);
                }
            }) != false;
        }
        catch (InterruptedException ex) {
            throw new TezException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new TezException((Throwable)ex);
        }
    }

    private static Path findLocalFileForResource(String fileName) {
        java.net.URL localResource = TezClassLoader.getInstance().getResource(fileName);
        if (localResource == null) {
            return null;
        }
        return new Path(localResource.getPath());
    }

    private static URI getLocalResourceUri(LocalResource input) {
        try {
            return TezConverterUtils.getURIFromYarnURL((URL)input.getResource());
        }
        catch (URISyntaxException e) {
            throw new TezUncheckedException("Failed while handling : " + input, (Throwable)e);
        }
    }

    private List<java.net.URL> processAdditionalResources(TezDAGID dagId, Map<String, LocalResource> lrDiff) throws TezException {
        List downloadedURLs;
        if (lrDiff == null || lrDiff.isEmpty()) {
            return Collections.emptyList();
        }
        LOG.info("Localizing additional local resources for AM : " + lrDiff);
        try {
            TezUtilsInternal.setHadoopCallerContext((HadoopShim)this.hadoopShim, (TezDAGID)dagId);
            downloadedURLs = RelocalizationUtils.processAdditionalResources((Map)Maps.transformValues(lrDiff, (Function)new Function<LocalResource, URI>(){

                public URI apply(LocalResource input) {
                    return DAGAppMaster.getLocalResourceUri(input);
                }
            }), (Configuration)this.getConfig(), (String)this.workingDirectory);
        }
        catch (IOException e) {
            throw new TezException((Throwable)e);
        }
        finally {
            this.hadoopShim.clearHadoopCallerContext();
        }
        LOG.info("Done downloading additional AM resources");
        return downloadedURLs;
    }

    void startServices() {
        try {
            Throwable firstError = null;
            ArrayList<ServiceThread> threads = new ArrayList<ServiceThread>();
            LOG.debug("Begin parallel start");
            for (ServiceWithDependency sd : this.services.values()) {
                ServiceThread st = new ServiceThread(sd, this.services);
                threads.add(st);
            }
            for (ServiceThread st : threads) {
                st.start();
            }
            for (ServiceThread st : threads) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Waiting for service thread to join for " + st.getName());
                }
                st.join();
                if (st.error == null || firstError != null) continue;
                firstError = st.error;
            }
            if (firstError != null) {
                throw ServiceStateException.convert(firstError);
            }
            LOG.debug("End parallel start");
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    void initServices(Configuration conf) {
        for (ServiceWithDependency sd : this.services.values()) {
            LOG.debug("Initing service : {}", (Object)sd.service);
            sd.service.init(conf);
        }
    }

    void stopServices() {
        Exception firstException = null;
        if (this.currentDAG != null) {
            this.currentDAG.onFinish();
        }
        ArrayList<Service> serviceList = new ArrayList<Service>(this.services.size());
        for (ServiceWithDependency sd : this.services.values()) {
            serviceList.add(sd.service);
        }
        for (int i = this.services.size() - 1; i >= 0; --i) {
            Service service = (Service)serviceList.get(i);
            LOG.debug("Stopping service : {}", (Object)service);
            Exception ex = ServiceOperations.stopQuietly((Service)service);
            if (ex == null || firstException != null) continue;
            LOG.warn("Failed to stop service, name=" + service.getName(), (Throwable)ex);
            firstException = ex;
        }
        if (firstException != null) {
            throw ServiceStateException.convert(firstException);
        }
    }

    private RecoveryParser.DAGRecoveryData recoverDAG() throws IOException, TezException {
        if (this.recoveryEnabled) {
            try {
                TezUtilsInternal.setHadoopCallerContext((HadoopShim)this.hadoopShim, (ApplicationId)this.getAppID());
                if (this.appAttemptID.getAttemptId() > 1) {
                    LOG.info("Recovering data from previous attempts, currentAttemptId=" + this.appAttemptID.getAttemptId());
                    this.state = DAGAppMasterState.RECOVERING;
                    RecoveryParser.DAGRecoveryData dAGRecoveryData = this.parseDAGFromRecoveryData();
                    return dAGRecoveryData;
                }
            }
            finally {
                this.hadoopShim.clearHadoopCallerContext();
            }
        }
        return null;
    }

    private RecoveryParser.DAGRecoveryData parseDAGFromRecoveryData() throws IOException {
        RecoveryParser recoveryParser = new RecoveryParser(this, this.recoveryFS, this.recoveryDataDir, this.appAttemptID.getAttemptId());
        RecoveryParser.DAGRecoveryData recoveredDAGData = recoveryParser.parseRecoveryData();
        if (Objects.isNull(recoveredDAGData) && this.amConf.getBoolean("tez.am.failure.on.missing.recovery.data", false)) {
            throw new IOException(String.format("Found nothing to recover in currentAttemptId=%s from recovery data dir=%s", this.appAttemptID.getAttemptId(), this.recoveryDataDir));
        }
        return recoveredDAGData;
    }

    public void serviceStart() throws Exception {
        RecoveryParser.DAGRecoveryData recoveredDAGData;
        this.startServices();
        super.serviceStart();
        boolean invalidSession = false;
        if (this.isSession && !this.recoveryEnabled && this.appAttemptID.getAttemptId() > 1) {
            String err = INVALID_SESSION_ERR_MSG;
            LOG.error(err);
            this.addDiagnostic(err);
            this.state = DAGAppMasterState.ERROR;
            invalidSession = true;
        }
        if (this.versionMismatch || invalidSession) {
            this.taskSchedulerManager.setShouldUnregisterFlag();
            this.shutdownHandler.shutdown();
            return;
        }
        this.appsStartTime = this.clock.getTime();
        AMStartedEvent startEvent = new AMStartedEvent(this.appAttemptID, this.appsStartTime, this.appMasterUgi.getShortUserName());
        this.historyEventHandler.handle(new DAGHistoryEvent(startEvent));
        this.lastDAGCompletionTime = this.clock.getTime();
        try {
            recoveredDAGData = this.recoverDAG();
        }
        catch (IOException e) {
            LOG.error("Error occurred when trying to recover data from previous attempt. Shutting down AM", (Throwable)e);
            this.state = DAGAppMasterState.ERROR;
            this.taskSchedulerManager.setShouldUnregisterFlag();
            this.shutdownHandler.shutdown();
            return;
        }
        DAGProtos.DAGPlan dagPlan = null;
        if (!this.isSession) {
            LOG.info("In Non-Session mode.");
            dagPlan = this.readDAGPlanFile();
            if (this.hasConcurrentEdge(dagPlan) && recoveredDAGData != null) {
                LOG.warn("Ignoring recoveredDAGData for a recovered DAG with concurrent edge.");
                recoveredDAGData = null;
            }
        } else {
            LOG.info("In Session mode. Waiting for DAG over RPC");
            this.state = DAGAppMasterState.IDLE;
        }
        if (recoveredDAGData != null) {
            if (recoveredDAGData.cumulativeAdditionalResources != null) {
                recoveredDAGData.additionalUrlsForClasspath = this.processAdditionalResources(recoveredDAGData.recoveredDagID, recoveredDAGData.cumulativeAdditionalResources);
                this.amResources.putAll(recoveredDAGData.cumulativeAdditionalResources);
                this.cumulativeAdditionalResources.putAll(recoveredDAGData.cumulativeAdditionalResources);
            }
            if (recoveredDAGData.isSessionStopped) {
                LOG.info("AM crashed when shutting down in the previous attempt, continue the shutdown and recover it to SUCCEEDED");
                this.sessionStopped.set(true);
                return;
            }
            if (recoveredDAGData.isCompleted || recoveredDAGData.nonRecoverable) {
                LOG.info("Found previous DAG in completed or non-recoverable state, dagId=" + recoveredDAGData.recoveredDagID + ", isCompleted=" + recoveredDAGData.isCompleted + ", isNonRecoverable=" + recoveredDAGData.nonRecoverable + ", state=" + (recoveredDAGData.dagState == null ? "null" : recoveredDAGData.dagState) + ", failureReason=" + recoveredDAGData.reason);
                this.updateLoggers(recoveredDAGData.recoveredDAG, "");
                if (recoveredDAGData.nonRecoverable) {
                    this.addDiagnostic("DAG " + recoveredDAGData.recoveredDagID + " can not be recovered due to " + recoveredDAGData.reason);
                    DAGEventRecoverEvent recoverDAGEvent = new DAGEventRecoverEvent(recoveredDAGData.recoveredDAG.getID(), DAGState.FAILED, recoveredDAGData);
                    DAGRecoveredEvent dagRecoveredEvent = new DAGRecoveredEvent(this.appAttemptID, recoveredDAGData.recoveredDAG.getID(), recoveredDAGData.recoveredDAG.getName(), recoveredDAGData.recoveredDAG.getUserName(), this.clock.getTime(), DAGState.FAILED, recoveredDAGData.reason, this.containerLogs);
                    dagRecoveredEvent.setHistoryLoggingEnabled(recoveredDAGData.recoveredDAG.getConf().getBoolean("tez.dag.history.logging.enabled", true));
                    this.historyEventHandler.handle(new DAGHistoryEvent(recoveredDAGData.recoveredDAG.getID(), dagRecoveredEvent));
                    this.dagEventDispatcher.handle(recoverDAGEvent);
                    this.state = DAGAppMasterState.RUNNING;
                } else {
                    DAGEventRecoverEvent recoverDAGEvent = new DAGEventRecoverEvent(recoveredDAGData.recoveredDAG.getID(), recoveredDAGData.dagState, recoveredDAGData);
                    DAGRecoveredEvent dagRecoveredEvent = new DAGRecoveredEvent(this.appAttemptID, recoveredDAGData.recoveredDAG.getID(), recoveredDAGData.recoveredDAG.getName(), recoveredDAGData.recoveredDAG.getUserName(), this.clock.getTime(), recoveredDAGData.dagState, null, this.containerLogs);
                    this.historyEventHandler.handle(new DAGHistoryEvent(recoveredDAGData.recoveredDAG.getID(), dagRecoveredEvent));
                    this.dagEventDispatcher.handle(recoverDAGEvent);
                    this.state = DAGAppMasterState.RUNNING;
                }
            } else {
                LOG.info("Found DAG to recover, dagId=" + recoveredDAGData.recoveredDAG.getID());
                this.updateLoggers(recoveredDAGData.recoveredDAG, "");
                DAGRecoveredEvent dagRecoveredEvent = new DAGRecoveredEvent(this.appAttemptID, recoveredDAGData.recoveredDAG.getID(), recoveredDAGData.recoveredDAG.getName(), recoveredDAGData.recoveredDAG.getUserName(), this.clock.getTime(), this.containerLogs);
                this.historyEventHandler.handle(new DAGHistoryEvent(recoveredDAGData.recoveredDAG.getID(), dagRecoveredEvent));
                DAGEventRecoverEvent recoverDAGEvent = new DAGEventRecoverEvent(recoveredDAGData.recoveredDAG.getID(), recoveredDAGData);
                this.dagEventDispatcher.handle(recoverDAGEvent);
                this.currentDAG.onStart();
                this.state = DAGAppMasterState.RUNNING;
            }
        } else if (!this.isSession) {
            this.dagCounter.set(0);
            assert (dagPlan != null);
            this.startDAG(dagPlan, null);
        }
        if (this.isSession && this.sessionTimeoutInterval >= 0L) {
            this.dagSubmissionTimer = new Timer("DAGSubmissionTimer", true);
            this.dagSubmissionTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        DAGAppMaster.this.checkAndHandleSessionTimeout();
                    }
                    catch (TezException e) {
                        LOG.error("Error when checking AM session timeout", (Throwable)e);
                    }
                }
            }, this.sessionTimeoutInterval, this.sessionTimeoutInterval / 10L);
        }
        if (!this.isLocal && this.isSession && this.clientAMHeartbeatTimeoutIntervalMillis > 0L) {
            this.clientHandler.updateLastHeartbeatTime();
            this.clientAMHeartBeatTimeoutService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ClientAMHeartBeatKeepAliveCheck #%d").build());
            this.clientAMHeartBeatTimeoutService.schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        long nextExpiry = DAGAppMaster.this.checkAndHandleDAGClientTimeout();
                        if (nextExpiry > 0L) {
                            DAGAppMaster.this.clientAMHeartBeatTimeoutService.schedule(this, nextExpiry, TimeUnit.MILLISECONDS);
                        }
                    }
                    catch (TezException e) {
                        LOG.error("Error when checking Client AM heartbeat timeout", (Throwable)e);
                    }
                }
            }, this.clientAMHeartbeatTimeoutIntervalMillis, TimeUnit.MILLISECONDS);
        }
    }

    private void initiateStop() {
        this.taskSchedulerManager.initiateStop();
    }

    public void serviceStop() throws Exception {
        if (this.isSession) {
            this.sessionStopped.set(true);
        }
        if (this.dagSubmissionTimer != null) {
            this.dagSubmissionTimer.cancel();
        }
        if (this.clientAMHeartBeatTimeoutService != null) {
            this.clientAMHeartBeatTimeoutService.shutdownNow();
        }
        this.initiateStop();
        this.stopServices();
        boolean deleteTezScratchData = this.amConf.getBoolean("tez.am.staging.scratch-data.auto-delete", true);
        LOG.debug("Checking whether tez scratch data dir should be deleted, deleteTezScratchData={}", (Object)deleteTezScratchData);
        if (deleteTezScratchData && this.taskSchedulerManager != null && this.taskSchedulerManager.hasUnregistered() && this.tezSystemStagingDir != null) {
            try {
                this.appMasterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        FileSystem fs = DAGAppMaster.this.tezSystemStagingDir.getFileSystem(DAGAppMaster.this.amConf);
                        boolean deletedStagingDir = fs.delete(DAGAppMaster.this.tezSystemStagingDir, true);
                        if (!deletedStagingDir) {
                            LOG.warn("Failed to delete tez scratch data dir, path=" + DAGAppMaster.this.tezSystemStagingDir);
                        } else {
                            LOG.info("Completed deletion of tez scratch data dir, path=" + DAGAppMaster.this.tezSystemStagingDir);
                        }
                        return null;
                    }
                });
            }
            catch (IOException e) {
                LOG.warn("Failed to delete tez scratch data dir", (Throwable)e);
            }
        }
        if (this.execService != null) {
            this.execService.shutdownNow();
        }
        this.tezThreadDumpHelper.stop();
        super.serviceStop();
    }

    private long checkAndHandleDAGClientTimeout() throws TezException {
        long nextExpiry;
        if (EnumSet.of(DAGAppMasterState.NEW, DAGAppMasterState.RECOVERING).contains((Object)this.state) || this.sessionStopped.get()) {
            return -1L;
        }
        long currentTime = this.clock.getTime();
        if (currentTime < (nextExpiry = this.clientHandler.getLastHeartbeatTime() + this.clientAMHeartbeatTimeoutIntervalMillis)) {
            return nextExpiry + 1000L - currentTime;
        }
        String message = "Client-to-AM Heartbeat timeout interval expired, shutting down AM as client stopped heartbeating to it, lastClientAMHeartbeatTime=" + this.clientHandler.getLastHeartbeatTime() + ", clientAMHeartbeatTimeoutIntervalMillis=" + this.clientAMHeartbeatTimeoutIntervalMillis + " ms";
        this.addDiagnostic(message);
        this.shutdownTezAM(message);
        return -1L;
    }

    private synchronized void checkAndHandleSessionTimeout() throws TezException {
        if (EnumSet.of(DAGAppMasterState.RUNNING, DAGAppMasterState.RECOVERING).contains((Object)this.state) || this.sessionStopped.get()) {
            return;
        }
        long currentTime = this.clock.getTime();
        if (currentTime < this.lastDAGCompletionTime + this.sessionTimeoutInterval) {
            return;
        }
        String message = "Session timed out, lastDAGCompletionTime=" + this.lastDAGCompletionTime + " ms, sessionTimeoutInterval=" + this.sessionTimeoutInterval + " ms";
        this.addDiagnostic(message);
        this.shutdownTezAM(message);
    }

    public boolean isSession() {
        return this.isSession;
    }

    public static void main(String[] args) {
        try {
            String systemPropsToLog;
            TezClassLoader.setupTezClassLoader();
            Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
            String pid = System.getenv().get("JVM_PID");
            String containerIdStr = System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name());
            String nodeHostString = System.getenv(ApplicationConstants.Environment.NM_HOST.name());
            String nodePortString = System.getenv(ApplicationConstants.Environment.NM_PORT.name());
            String nodeHttpPortString = System.getenv(ApplicationConstants.Environment.NM_HTTP_PORT.name());
            String appSubmitTimeStr = System.getenv("APP_SUBMIT_TIME_ENV");
            String clientVersion = System.getenv("TEZ_CLIENT_VERSION");
            if (clientVersion == null) {
                clientVersion = "Unknown";
            }
            Objects.requireNonNull(appSubmitTimeStr, "APP_SUBMIT_TIME_ENV is null");
            ContainerId containerId = ConverterUtils.toContainerId((String)containerIdStr);
            ApplicationAttemptId applicationAttemptId = containerId.getApplicationAttemptId();
            long appSubmitTime = Long.parseLong(appSubmitTimeStr);
            String jobUserName = System.getenv(ApplicationConstants.Environment.USER.name());
            Options opts = new Options();
            opts.addOption("session", false, "Run Tez Application Master in Session mode");
            CommandLine cliParser = new GnuParser().parse(opts, args);
            boolean sessionModeCliOption = cliParser.hasOption("session");
            LOG.info("Creating DAGAppMaster for applicationId=" + applicationAttemptId.getApplicationId() + ", attemptNum=" + applicationAttemptId.getAttemptId() + ", AMContainerId=" + containerId + ", jvmPid=" + pid + ", userFromEnv=" + jobUserName + ", cliSessionOption=" + sessionModeCliOption + ", pwd=" + System.getenv(ApplicationConstants.Environment.PWD.name()) + ", localDirs=" + System.getenv(ApplicationConstants.Environment.LOCAL_DIRS.name()) + ", logDirs=" + System.getenv(ApplicationConstants.Environment.LOG_DIRS.name()));
            Configuration conf = new Configuration();
            DAGProtos.ConfigurationProto confProto = TezUtilsInternal.readUserSpecifiedTezConfiguration((String)System.getenv(ApplicationConstants.Environment.PWD.name()));
            TezUtilsInternal.addUserSpecifiedTezConfiguration((Configuration)conf, (List)confProto.getConfKeyValuesList());
            DAGProtos.AMPluginDescriptorProto amPluginDescriptorProto = null;
            if (confProto.hasAmPluginDescriptor()) {
                amPluginDescriptorProto = confProto.getAmPluginDescriptor();
            }
            UserGroupInformation.setConfiguration((Configuration)conf);
            Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
            TezUtilsInternal.setSecurityUtilConfigration((Logger)LOG, (Configuration)conf);
            DAGAppMaster appMaster = new DAGAppMaster(applicationAttemptId, containerId, nodeHostString, Integer.parseInt(nodePortString), Integer.parseInt(nodeHttpPortString), (Clock)new SystemClock(), appSubmitTime, sessionModeCliOption, System.getenv(ApplicationConstants.Environment.PWD.name()), TezCommonUtils.getTrimmedStrings((String)System.getenv(ApplicationConstants.Environment.LOCAL_DIRS.name())), TezCommonUtils.getTrimmedStrings((String)System.getenv(ApplicationConstants.Environment.LOG_DIRS.name())), clientVersion, credentials, jobUserName, amPluginDescriptorProto);
            ShutdownHookManager.get().addShutdownHook((Runnable)new DAGAppMasterShutdownHook(appMaster), 30);
            if (LOG.isInfoEnabled() && (systemPropsToLog = TezCommonUtils.getSystemPropertiesToLog((Configuration)conf)) != null) {
                LOG.info(systemPropsToLog);
            }
            DAGAppMaster.initAndStartAppMaster(appMaster, conf);
        }
        catch (Throwable t) {
            LOG.error("Error starting DAGAppMaster", t);
            System.exit(1);
        }
    }

    private boolean hasConcurrentEdge(DAGProtos.DAGPlan dagPlan) {
        boolean hasConcurrentEdge = false;
        for (DAGProtos.EdgePlan edge : dagPlan.getEdgeList()) {
            if (!DAGProtos.PlanEdgeSchedulingType.CONCURRENT.equals((Object)edge.getSchedulingType())) continue;
            return true;
        }
        return hasConcurrentEdge;
    }

    private DAGProtos.DAGPlan readDAGPlanFile() throws IOException, TezException {
        DAGProtos.DAGPlan dagPlan = null;
        try (FileInputStream dagPBBinaryStream = null;){
            dagPBBinaryStream = new FileInputStream(new File(this.workingDirectory, "tez-dag.pb"));
            dagPlan = DAGProtos.DAGPlan.parseFrom((InputStream)dagPBBinaryStream);
        }
        return dagPlan;
    }

    private void startDAG(DAGProtos.DAGPlan dagPlan, Map<String, LocalResource> additionalAMResources) throws TezException {
        Map<String, LocalResource> lrDiff;
        long submitTime = this.clock.getTime();
        this.appName = dagPlan.getName();
        final DAG newDAG = this.createDAG(dagPlan);
        LoggingUtils.initLoggingContext((ThreadLocalMap)this.mdcContext, (Configuration)newDAG.getConf(), (String)newDAG.getID().toString(), null);
        this.updateLoggers(newDAG, "");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running a DAG with " + dagPlan.getVertexCount() + " vertices ");
            for (DAGProtos.VertexPlan v : dagPlan.getVertexList()) {
                LOG.debug("DAG has vertex " + v.getName());
            }
        }
        if ((lrDiff = this.getAdditionalLocalResourceDiff(newDAG, additionalAMResources)) != null) {
            this.amResources.putAll(lrDiff);
            this.cumulativeAdditionalResources.putAll(lrDiff);
        }
        String callerContextStr = "";
        if (dagPlan.hasCallerContext()) {
            CallerContext callerContext = DagTypeConverters.convertCallerContextFromProto((DAGProtos.CallerContextProto)dagPlan.getCallerContext());
            callerContextStr = ", callerContext=" + callerContext.contextAsSimpleString();
        }
        LOG.info("Running DAG: " + dagPlan.getName() + callerContextStr);
        String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(Calendar.getInstance().getTime());
        System.err.println(timeStamp + " Running Dag: " + newDAG.getID());
        System.out.println(timeStamp + " Running Dag: " + newDAG.getID());
        final DAGSubmittedEvent submittedEvent = new DAGSubmittedEvent(newDAG.getID(), submitTime, dagPlan, this.appAttemptID, this.cumulativeAdditionalResources, newDAG.getUserName(), newDAG.getConf(), this.containerLogs, this.getContext().getQueueName());
        boolean dagLoggingEnabled = newDAG.getConf().getBoolean("tez.dag.history.logging.enabled", true);
        submittedEvent.setHistoryLoggingEnabled(dagLoggingEnabled);
        try {
            this.appMasterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    DAGAppMaster.this.historyEventHandler.handleCriticalEvent(new DAGHistoryEvent(newDAG.getID(), submittedEvent));
                    return null;
                }
            });
        }
        catch (IOException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TezUncheckedException((Throwable)e);
        }
        this.countHeldContainers(newDAG);
        this.startDAGExecution(newDAG, lrDiff);
        this.state = DAGAppMasterState.RUNNING;
    }

    private void countHeldContainers(DAG newDAG) {
        newDAG.setDagCounter(DAGCounter.INITIAL_HELD_CONTAINERS, this.taskSchedulerManager.getHeldContainersCount());
    }

    private void startDAGExecution(DAG dag, final Map<String, LocalResource> additionalAmResources) throws TezException {
        List additionalUrlsForClasspath;
        this.currentDAG = dag;
        this.tezThreadDumpHelper = TezThreadDumpHelper.getInstance((Configuration)dag.getConf()).start(dag.getID().toString());
        try {
            additionalUrlsForClasspath = (List)dag.getDagUGI().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<List<java.net.URL>>(){

                @Override
                public List<java.net.URL> run() throws Exception {
                    return DAGAppMaster.this.processAdditionalResources(DAGAppMaster.this.currentDAG.getID(), additionalAmResources);
                }
            });
        }
        catch (IOException e) {
            throw new TezException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new TezException((Throwable)e);
        }
        this.dagIDs.add(this.currentDAG.getID().toString());
        ((RunningAppContext)this.context).setDAG(this.currentDAG);
        this.sendEvent((Event<?>)new DAGAppMasterEvent(DAGAppMasterEventType.NEW_DAG_SUBMITTED));
        DAGEvent initDagEvent = new DAGEvent(this.currentDAG.getID(), DAGEventType.DAG_INIT);
        this.dagEventDispatcher.handle(initDagEvent);
        dag.onStart();
        DAGEventStartDag startDagEvent = new DAGEventStartDag(this.currentDAG.getID(), additionalUrlsForClasspath);
        this.sendEvent((Event<?>)startDagEvent);
    }

    public static void initAndStartAppMaster(final DAGAppMaster appMaster, final Configuration conf) throws IOException, InterruptedException {
        conf.setBoolean("fs.automatic.close", false);
        Limits.setConfiguration((Configuration)conf);
        Iterator iter = appMaster.amCredentials.getAllTokens().iterator();
        while (iter.hasNext()) {
            Token token = (Token)iter.next();
            if (!token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) continue;
            iter.remove();
        }
        appMaster.appMasterUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                appMaster.init(conf);
                appMaster.start();
                return null;
            }
        });
    }

    private void sendEvent(Event<?> event) {
        this.dispatcher.getEventHandler().handle(event);
    }

    synchronized void setDAGCounter(int dagCounter) {
        this.dagCounter.set(dagCounter);
    }

    private boolean enableWebUIService() {
        return this.amConf.getBoolean("tez.am.tez-ui.webservice.enable", true);
    }

    public String getWebUIAddress() {
        return this.webUIService == null ? null : this.webUIService.getBaseUrl();
    }

    @VisibleForTesting
    public static void parseAllPlugins(List<NamedEntityDescriptor> taskSchedulerDescriptors, BiMap<String, Integer> taskSchedulerPluginMap, List<NamedEntityDescriptor> containerLauncherDescriptors, BiMap<String, Integer> containerLauncherPluginMap, List<NamedEntityDescriptor> taskCommDescriptors, BiMap<String, Integer> taskCommPluginMap, DAGProtos.AMPluginDescriptorProto amPluginDescriptorProto, boolean isLocal, UserPayload defaultPayload) {
        boolean uberEnabled;
        boolean tezYarnEnabled;
        if (!isLocal) {
            if (amPluginDescriptorProto == null) {
                tezYarnEnabled = true;
                uberEnabled = false;
            } else {
                tezYarnEnabled = amPluginDescriptorProto.getContainersEnabled();
                uberEnabled = amPluginDescriptorProto.getUberEnabled();
            }
        } else {
            tezYarnEnabled = false;
            uberEnabled = true;
        }
        DAGAppMaster.parsePlugin(taskSchedulerDescriptors, taskSchedulerPluginMap, amPluginDescriptorProto == null || amPluginDescriptorProto.getTaskSchedulersCount() == 0 ? null : amPluginDescriptorProto.getTaskSchedulersList(), tezYarnEnabled, uberEnabled, defaultPayload);
        DAGAppMaster.processSchedulerDescriptors(taskSchedulerDescriptors, isLocal, defaultPayload, taskSchedulerPluginMap);
        DAGAppMaster.parsePlugin(containerLauncherDescriptors, containerLauncherPluginMap, amPluginDescriptorProto == null || amPluginDescriptorProto.getContainerLaunchersCount() == 0 ? null : amPluginDescriptorProto.getContainerLaunchersList(), tezYarnEnabled, uberEnabled, defaultPayload);
        DAGAppMaster.parsePlugin(taskCommDescriptors, taskCommPluginMap, amPluginDescriptorProto == null || amPluginDescriptorProto.getTaskCommunicatorsCount() == 0 ? null : amPluginDescriptorProto.getTaskCommunicatorsList(), tezYarnEnabled, uberEnabled, defaultPayload);
    }

    @VisibleForTesting
    public static void parsePlugin(List<NamedEntityDescriptor> resultList, BiMap<String, Integer> pluginMap, List<DAGProtos.TezNamedEntityDescriptorProto> namedEntityDescriptorProtos, boolean tezYarnEnabled, boolean uberEnabled, UserPayload defaultPayload) {
        NamedEntityDescriptor r;
        if (tezYarnEnabled) {
            r = new NamedEntityDescriptor(TezConstants.getTezYarnServicePluginName(), null).setUserPayload(defaultPayload);
            DAGAppMaster.addDescriptor(resultList, pluginMap, r);
        }
        if (uberEnabled) {
            r = new NamedEntityDescriptor(TezConstants.getTezUberServicePluginName(), null).setUserPayload(defaultPayload);
            DAGAppMaster.addDescriptor(resultList, pluginMap, r);
        }
        if (namedEntityDescriptorProtos != null) {
            for (DAGProtos.TezNamedEntityDescriptorProto namedEntityDescriptorProto : namedEntityDescriptorProtos) {
                NamedEntityDescriptor namedEntityDescriptor = DagTypeConverters.convertNamedDescriptorFromProto((DAGProtos.TezNamedEntityDescriptorProto)namedEntityDescriptorProto);
                DAGAppMaster.addDescriptor(resultList, pluginMap, namedEntityDescriptor);
            }
        }
    }

    @VisibleForTesting
    static void addDescriptor(List<NamedEntityDescriptor> list, BiMap<String, Integer> pluginMap, NamedEntityDescriptor namedEntityDescriptor) {
        list.add(namedEntityDescriptor);
        pluginMap.put((Object)list.get(list.size() - 1).getEntityName(), (Object)(list.size() - 1));
    }

    @VisibleForTesting
    static void processSchedulerDescriptors(List<NamedEntityDescriptor> descriptors, boolean isLocal, UserPayload defaultPayload, BiMap<String, Integer> schedulerPluginMap) {
        if (isLocal) {
            boolean foundUberServiceName = false;
            for (NamedEntityDescriptor descriptor : descriptors) {
                if (!descriptor.getEntityName().equals(TezConstants.getTezUberServicePluginName())) continue;
                foundUberServiceName = true;
                break;
            }
            Preconditions.checkState((boolean)foundUberServiceName);
        } else {
            boolean foundYarn = false;
            for (int i = 0; i < descriptors.size(); ++i) {
                if (!descriptors.get(i).getEntityName().equals(TezConstants.getTezYarnServicePluginName())) continue;
                foundYarn = true;
            }
            if (!foundYarn) {
                NamedEntityDescriptor yarnDescriptor = new NamedEntityDescriptor(TezConstants.getTezYarnServicePluginName(), null).setUserPayload(defaultPayload);
                DAGAppMaster.addDescriptor(descriptors, schedulerPluginMap, yarnDescriptor);
            }
        }
    }

    String buildPluginComponentLog(List<NamedEntityDescriptor> namedEntityDescriptors, BiMap<String, Integer> map, String component) {
        StringBuilder sb = new StringBuilder();
        sb.append("AM Level configured ").append(component).append(": ");
        for (int i = 0; i < namedEntityDescriptors.size(); ++i) {
            sb.append("[").append(i).append(":").append((String)map.inverse().get((Object)i)).append(":").append(namedEntityDescriptors.get(i).getClassName()).append("]");
            if (i == namedEntityDescriptors.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void vertexComplete(TezVertexID completedVertexID, Set<NodeId> nodesList) {
        this.getContainerLauncherManager().vertexComplete(completedVertexID, this.jobTokenSecretManager, nodesList);
    }

    public void taskAttemptFailed(TezTaskAttemptID attemptID, NodeId nodeId) {
        this.getContainerLauncherManager().taskAttemptFailed(attemptID, this.jobTokenSecretManager, nodeId);
    }

    static class DAGAppMasterShutdownHook
    implements Runnable {
        DAGAppMaster appMaster;

        DAGAppMasterShutdownHook(DAGAppMaster appMaster) {
            this.appMaster = appMaster;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("DAGAppMasterShutdownHook invoked");
            if (this.appMaster.getServiceState() == Service.STATE.STOPPED) {
                LOG.debug("DAGAppMaster already stopped. Ignoring signal");
                AtomicBoolean atomicBoolean = this.appMaster.shutdownHandlerRunning;
                synchronized (atomicBoolean) {
                    try {
                        if (this.appMaster.shutdownHandlerRunning.get()) {
                            LOG.info("The shutdown handler is still running, waiting for it to complete");
                            this.appMaster.shutdownHandlerRunning.wait();
                            LOG.info("The shutdown handler has completed");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return;
            }
            if (this.appMaster.getServiceState() == Service.STATE.STARTED) {
                LOG.info("DAGAppMaster received a signal. Signaling TaskScheduler");
                this.appMaster.taskSchedulerManager.setSignalled(true);
            }
            if (EnumSet.of(DAGAppMasterState.NEW, DAGAppMasterState.INITED, DAGAppMasterState.IDLE).contains((Object)this.appMaster.state)) {
                this.appMaster.state = DAGAppMasterState.KILLED;
            } else if (this.appMaster.state == DAGAppMasterState.RUNNING) {
                this.appMaster.state = DAGAppMasterState.ERROR;
            }
            this.appMaster.stop();
        }
    }

    private class VertexEventDispatcher
    implements EventHandler<VertexEvent> {
        private VertexEventDispatcher() {
        }

        public void handle(VertexEvent event) {
            DAG dag = DAGAppMaster.this.context.getCurrentDAG();
            int eventDagIndex = event.getDAGID().getId();
            if (dag == null || eventDagIndex != dag.getID().getId()) {
                return;
            }
            Vertex vertex = dag.getVertex(event.getVertexID());
            ((EventHandler)vertex).handle((Event)event);
        }
    }

    private class TaskAttemptEventDispatcher
    implements EventHandler<TaskAttemptEvent> {
        private TaskAttemptEventDispatcher() {
        }

        public void handle(TaskAttemptEvent event) {
            DAG dag = DAGAppMaster.this.context.getCurrentDAG();
            int eventDagIndex = event.getDAGID().getId();
            if (dag == null || eventDagIndex != dag.getID().getId()) {
                return;
            }
            Task task = dag.getVertex(event.getVertexID()).getTask(event.getTaskID());
            TaskAttempt attempt = task.getAttempt(event.getTaskAttemptID());
            ((EventHandler)attempt).handle((Event)event);
        }
    }

    private class SpeculatorEventHandler
    implements EventHandler<SpeculatorEvent> {
        private SpeculatorEventHandler() {
        }

        public void handle(SpeculatorEvent event) {
            TezVertexID vertexId;
            DAG dag = DAGAppMaster.this.context.getCurrentDAG();
            Vertex v = dag.getVertex(vertexId = event.getVertexId());
            Preconditions.checkState((v != null ? 1 : 0) != 0, (Object)("Unknown vertex: " + vertexId + " for DAG: " + dag.getID()));
            v.handleSpeculatorEvent(event);
        }
    }

    private class TaskEventDispatcher
    implements EventHandler<TaskEvent> {
        private TaskEventDispatcher() {
        }

        public void handle(TaskEvent event) {
            DAG dag = DAGAppMaster.this.context.getCurrentDAG();
            int eventDagIndex = event.getDAGID().getId();
            if (dag == null || eventDagIndex != dag.getID().getId()) {
                return;
            }
            Task task = dag.getVertex(event.getVertexID()).getTask(event.getTaskID());
            ((EventHandler)task).handle((Event)event);
        }
    }

    private class DagEventDispatcher
    implements EventHandler<DAGEvent> {
        private DagEventDispatcher() {
        }

        public void handle(DAGEvent event) {
            DAG dag = DAGAppMaster.this.context.getCurrentDAG();
            int eventDagIndex = event.getDAGID().getId();
            if (dag == null || eventDagIndex != dag.getID().getId()) {
                return;
            }
            ((EventHandler)dag).handle((Event)event);
        }
    }

    private static class ServiceThread
    extends Thread {
        final ServiceWithDependency serviceWithDependency;
        final Map<Service, ServiceWithDependency> services;
        volatile Throwable error = null;

        public ServiceThread(ServiceWithDependency serviceWithDependency, Map<Service, ServiceWithDependency> services) {
            this.serviceWithDependency = serviceWithDependency;
            this.services = services;
            this.setName("ServiceThread:" + serviceWithDependency.service.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Starting thread " + this.serviceWithDependency.service.getName());
            }
            long start = System.currentTimeMillis();
            try {
                this.serviceWithDependency.start();
            }
            catch (Throwable t) {
                this.error = t;
                this.notifyDependentServices();
            }
            finally {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Service: " + this.serviceWithDependency.service.getName() + " started in " + (System.currentTimeMillis() - start) + "ms");
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Service thread completed for " + this.serviceWithDependency.service.getName());
            }
        }

        private void notifyDependentServices() {
            for (ServiceWithDependency otherSvc : this.services.values()) {
                if (!otherSvc.dependencies.contains(this.serviceWithDependency.service)) continue;
                otherSvc.stateChanged(this.serviceWithDependency.service);
            }
        }
    }

    private static class ServiceWithDependency
    implements ServiceStateChangeListener {
        Service service;
        List<Service> dependencies = new ArrayList<Service>();
        AtomicInteger dependenciesStarted = new AtomicInteger(0);
        volatile boolean canStart = false;
        volatile boolean dependenciesFailed = false;

        ServiceWithDependency(Service service) {
            this.service = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(Service dependency) {
            Throwable dependencyError;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Service dependency: " + dependency.getName() + " notify for service: " + this.service.getName());
            }
            if ((dependencyError = dependency.getFailureCause()) != null) {
                ServiceWithDependency serviceWithDependency = this;
                synchronized (serviceWithDependency) {
                    this.dependenciesFailed = true;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Service: " + this.service.getName() + " will fail to start as dependent service " + dependency.getName() + " failed to start: " + dependencyError);
                    }
                    this.notifyAll();
                }
            }
            if (dependency.isInState(Service.STATE.STARTED) && this.dependenciesStarted.incrementAndGet() == this.dependencies.size()) {
                ServiceWithDependency serviceWithDependency = this;
                synchronized (serviceWithDependency) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Service: " + this.service.getName() + " notified to start");
                    }
                    this.canStart = true;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void start() throws InterruptedException {
            if (this.dependencies.size() > 0) {
                ServiceWithDependency serviceWithDependency = this;
                synchronized (serviceWithDependency) {
                    while (!this.canStart) {
                        this.wait(180000L);
                        if (!this.dependenciesFailed) continue;
                        throw new TezUncheckedException("Skipping service start for " + this.service.getName() + " as dependencies failed to start");
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Service: " + this.service.getName() + " trying to start");
            }
            for (Service dependency : this.dependencies) {
                if (dependency.isInState(Service.STATE.STARTED)) continue;
                LOG.info("Service: " + this.service.getName() + " not started because  service: " + dependency.getName() + " is in state: " + dependency.getServiceState());
                return;
            }
            this.service.start();
        }
    }

    private class RunningAppContext
    implements AppContext {
        private DAG dag;
        private RecoveryParser.DAGRecoveryData dagRecoveryData;
        private final Configuration conf;
        private final ClusterInfo clusterInfo = new ClusterInfo();
        private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        private final Lock rLock = this.rwLock.readLock();
        private final Lock wLock = this.rwLock.writeLock();
        private final EventHandler eventHandler;
        private volatile String queueName;

        public RunningAppContext(Configuration config) {
            Objects.requireNonNull(config, "config is null");
            this.conf = config;
            this.eventHandler = DAGAppMaster.this.dispatcher.getEventHandler();
        }

        @Override
        public DAGAppMaster getAppMaster() {
            return DAGAppMaster.this;
        }

        @Override
        public Configuration getAMConf() {
            return this.conf;
        }

        @Override
        public ApplicationAttemptId getApplicationAttemptId() {
            return DAGAppMaster.this.appAttemptID;
        }

        @Override
        public ApplicationId getApplicationID() {
            return DAGAppMaster.this.appAttemptID.getApplicationId();
        }

        @Override
        public String getApplicationName() {
            return DAGAppMaster.this.appName;
        }

        @Override
        public long getStartTime() {
            return DAGAppMaster.this.startTime;
        }

        @Override
        public DAG getCurrentDAG() {
            return this.dag;
        }

        @Override
        public ListeningExecutorService getExecService() {
            return DAGAppMaster.this.execService;
        }

        @Override
        public Set<String> getAllDAGIDs() {
            return DAGAppMaster.this.dagIDs;
        }

        @Override
        public EventHandler getEventHandler() {
            return this.eventHandler;
        }

        @Override
        public String getUser() {
            return this.dag.getUserName();
        }

        @Override
        public Clock getClock() {
            return DAGAppMaster.this.clock;
        }

        @Override
        public ClusterInfo getClusterInfo() {
            return this.clusterInfo;
        }

        @Override
        public AMContainerMap getAllContainers() {
            return DAGAppMaster.this.containers;
        }

        @Override
        public AMNodeTracker getNodeTracker() {
            return DAGAppMaster.this.nodes;
        }

        @Override
        public TaskSchedulerManager getTaskScheduler() {
            return DAGAppMaster.this.taskSchedulerManager;
        }

        @Override
        public TaskCommunicatorManagerInterface getTaskCommunicatorManager() {
            return DAGAppMaster.this.taskCommunicatorManager;
        }

        @Override
        public boolean isSession() {
            return DAGAppMaster.this.isSession;
        }

        @Override
        public boolean isLocal() {
            return DAGAppMaster.this.isLocal;
        }

        @Override
        public DAGAppMasterState getAMState() {
            return DAGAppMaster.this.state;
        }

        @Override
        public HistoryEventHandler getHistoryHandler() {
            return DAGAppMaster.this.historyEventHandler;
        }

        @Override
        public Path getCurrentRecoveryDir() {
            return DAGAppMaster.this.currentRecoveryDataDir;
        }

        @Override
        public boolean isRecoveryEnabled() {
            return DAGAppMaster.this.recoveryEnabled;
        }

        @Override
        public ACLManager getAMACLManager() {
            return DAGAppMaster.this.aclManager;
        }

        @Override
        public String[] getLogDirs() {
            return DAGAppMaster.this.logDirs;
        }

        @Override
        public String[] getLocalDirs() {
            return DAGAppMaster.this.localDirs;
        }

        @Override
        public String getAMUser() {
            return DAGAppMaster.this.appMasterUgi.getShortUserName();
        }

        @Override
        public boolean isAMInCompletionState() {
            return EnumSet.of(DAGAppMasterState.SUCCEEDED, DAGAppMasterState.KILLED, DAGAppMasterState.FAILED, DAGAppMasterState.ERROR).contains((Object)DAGAppMaster.this.state);
        }

        @Override
        public Credentials getAppCredentials() {
            return DAGAppMaster.this.amCredentials;
        }

        @Override
        public Integer getTaskCommunicatorIdentifier(String name) {
            return (Integer)DAGAppMaster.this.taskCommunicators.get((Object)name);
        }

        @Override
        public Integer getTaskScheduerIdentifier(String name) {
            return (Integer)DAGAppMaster.this.taskSchedulers.get((Object)name);
        }

        @Override
        public Integer getContainerLauncherIdentifier(String name) {
            return (Integer)DAGAppMaster.this.containerLaunchers.get((Object)name);
        }

        @Override
        public String getTaskCommunicatorName(int taskCommId) {
            return (String)DAGAppMaster.this.taskCommunicators.inverse().get((Object)taskCommId);
        }

        @Override
        public String getTaskSchedulerName(int schedulerId) {
            return (String)DAGAppMaster.this.taskSchedulers.inverse().get((Object)schedulerId);
        }

        @Override
        public String getContainerLauncherName(int launcherId) {
            return (String)DAGAppMaster.this.containerLaunchers.inverse().get((Object)launcherId);
        }

        @Override
        public String getTaskCommunicatorClassName(int taskCommId) {
            return DAGAppMaster.this.taskCommunicatorManager.getTaskCommunicatorClassName(taskCommId);
        }

        @Override
        public String getTaskSchedulerClassName(int schedulerId) {
            return DAGAppMaster.this.taskSchedulerManager.getTaskSchedulerClassName(schedulerId);
        }

        @Override
        public String getContainerLauncherClassName(int launcherId) {
            return DAGAppMaster.this.containerLauncherManager.getContainerLauncherClassName(launcherId);
        }

        @Override
        public HadoopShim getHadoopShim() {
            return DAGAppMaster.this.hadoopShim;
        }

        @Override
        public Map<ApplicationAccessType, String> getApplicationACLs() {
            if (DAGAppMaster.this.getServiceState() != Service.STATE.STARTED) {
                throw new TezUncheckedException("Cannot get ApplicationACLs before all services have started");
            }
            return DAGAppMaster.this.taskSchedulerManager.getApplicationAcls();
        }

        @Override
        public TezDAGID getCurrentDAGID() {
            try {
                this.rLock.lock();
                if (this.dag != null) {
                    TezDAGID tezDAGID = this.dag.getID();
                    return tezDAGID;
                }
                TezDAGID tezDAGID = null;
                return tezDAGID;
            }
            finally {
                this.rLock.unlock();
            }
        }

        @Override
        public void setDAG(DAG dag) {
            Objects.requireNonNull(dag, "dag is null");
            try {
                this.wLock.lock();
                this.dag = dag;
                this.dagRecoveryData = null;
            }
            finally {
                this.wLock.unlock();
            }
        }

        @Override
        public long getCumulativeCPUTime() {
            return DAGAppMaster.this.getAMCPUTime();
        }

        @Override
        public long getCumulativeGCTime() {
            return DAGAppMaster.this.getAMGCTime();
        }

        @Override
        public void setDAGRecoveryData(RecoveryParser.DAGRecoveryData dagRecoveryData) {
            this.dagRecoveryData = dagRecoveryData;
        }

        @Override
        public RecoveryParser.DAGRecoveryData getDAGRecoveryData() {
            return this.dagRecoveryData;
        }

        @Override
        public String getQueueName() {
            return this.queueName;
        }

        @Override
        public void setQueueName(String queueName) {
            this.queueName = queueName;
        }
    }

    protected class DAGAppMasterShutdownHandler {
        private AtomicBoolean shutdownHandled = new AtomicBoolean(false);
        private long sleepTimeBeforeExit = 5000L;

        protected DAGAppMasterShutdownHandler() {
        }

        void setSleepTimeBeforeExit(long sleepTimeBeforeExit) {
            this.sleepTimeBeforeExit = sleepTimeBeforeExit;
        }

        public void shutdown() {
            this.shutdown(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown(boolean now) {
            LOG.info("DAGAppMasterShutdownHandler invoked");
            if (!this.shutdownHandled.compareAndSet(false, true)) {
                LOG.info("Ignoring multiple shutdown events");
                return;
            }
            AtomicBoolean atomicBoolean = DAGAppMaster.this.shutdownHandlerRunning;
            synchronized (atomicBoolean) {
                DAGAppMaster.this.shutdownHandlerRunning.set(true);
            }
            LOG.info("Handling DAGAppMaster shutdown");
            AMShutdownRunnable r = new AMShutdownRunnable(now, this.sleepTimeBeforeExit);
            Thread t = new Thread((Runnable)r, "AMShutdownThread");
            t.start();
        }

        private class AMShutdownRunnable
        implements Runnable {
            private final boolean immediateShutdown;
            private final long sleepTimeBeforeExit;

            public AMShutdownRunnable(boolean immediateShutdown, long sleepTimeBeforeExit) {
                this.immediateShutdown = immediateShutdown;
                this.sleepTimeBeforeExit = sleepTimeBeforeExit;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!this.immediateShutdown) {
                    try {
                        LOG.info("Sleeping for {} ms before shutting down", (Object)this.sleepTimeBeforeExit);
                        Thread.sleep(this.sleepTimeBeforeExit);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    LOG.info("Calling stop for all the services");
                    DAGAppMaster.this.stop();
                }
                catch (Throwable t) {
                    LOG.warn("Graceful stop failed ", t);
                }
                finally {
                    AtomicBoolean e = DAGAppMaster.this.shutdownHandlerRunning;
                    synchronized (e) {
                        DAGAppMaster.this.shutdownHandlerRunning.set(false);
                        DAGAppMaster.this.shutdownHandlerRunning.notify();
                    }
                    LOG.info("Exiting DAGAppMaster..GoodBye!");
                    DAGAppMaster.this.sysexit();
                }
            }
        }
    }

    private class DAGAppMasterEventHandler
    implements EventHandler<DAGAppMasterEvent> {
        private DAGAppMasterEventHandler() {
        }

        public void handle(DAGAppMasterEvent event) {
            if (DAGAppMaster.this.getServiceState() == Service.STATE.STOPPED) {
                LOG.info("ignore event when DAGAppMaster is in the state of STOPPED, eventType=" + event.getType());
                return;
            }
            DAGAppMaster.this.handle(event);
        }
    }
}

