/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.library.vertexmanager;

class DestinationTaskInputsProperty {
    private final int firstPartitionId;
    private final int numOfPartitions;
    private final int firstSourceTaskIndex;
    private final int numOfSourceTasks;

    public DestinationTaskInputsProperty(int firstPartitionId, int numOfPartitions, int firstSourceTaskIndex, int numOfSourceTasks) {
        this.firstPartitionId = firstPartitionId;
        this.numOfPartitions = numOfPartitions;
        this.firstSourceTaskIndex = firstSourceTaskIndex;
        this.numOfSourceTasks = numOfSourceTasks;
    }

    public int getFirstPartitionId() {
        return this.firstPartitionId;
    }

    public int getNumOfPartitions() {
        return this.numOfPartitions;
    }

    public int getFirstSourceTaskIndex() {
        return this.firstSourceTaskIndex;
    }

    public int getNumOfSourceTasks() {
        return this.numOfSourceTasks;
    }

    public boolean isSourceTaskInRange(int sourceTaskIndex) {
        return this.firstSourceTaskIndex <= sourceTaskIndex && sourceTaskIndex < this.firstSourceTaskIndex + this.numOfSourceTasks;
    }

    public boolean isPartitionInRange(int partitionId) {
        return this.firstPartitionId <= partitionId && partitionId < this.firstPartitionId + this.numOfPartitions;
    }

    public int getFirstPhysicalInputIndex(int sourceTaskIndex) {
        return this.getPhysicalInputIndex(sourceTaskIndex, this.firstPartitionId);
    }

    public int getPhysicalInputIndex(int sourceTaskIndex, int partitionId) {
        if (this.isSourceTaskInRange(sourceTaskIndex) && this.isPartitionInRange(partitionId)) {
            return (sourceTaskIndex - this.firstSourceTaskIndex) * this.numOfPartitions + (partitionId - this.firstPartitionId);
        }
        return -1;
    }

    public int getNumOfPhysicalInputs() {
        return this.numOfPartitions * this.numOfSourceTasks;
    }

    public int getSourceTaskIndex(int physicalInputIndex) {
        return this.firstSourceTaskIndex + physicalInputIndex / this.numOfPartitions;
    }

    public String toString() {
        return "firstPartitionId = " + this.firstPartitionId + " ,numOfPartitions = " + this.numOfPartitions + " ,firstSourceTaskIndex = " + this.firstSourceTaskIndex + " ,numOfSourceTasks = " + this.numOfSourceTasks;
    }
}

