/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.tapestry5.annotations.Component;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Mixin;
import org.apache.tapestry5.annotations.MixinClasses;
import org.apache.tapestry5.annotations.Mixins;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.commons.services.InvalidationEventHub;
import org.apache.tapestry5.commons.util.UnknownValueException;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.ThrowawayClassLoader;
import org.apache.tapestry5.internal.parser.ComponentTemplate;
import org.apache.tapestry5.internal.parser.StartComponentToken;
import org.apache.tapestry5.internal.parser.TemplateToken;
import org.apache.tapestry5.internal.services.ComponentDependencyRegistry;
import org.apache.tapestry5.internal.services.TemplateParser;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.ioc.Orderable;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.ClasspathResource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.model.EmbeddedComponentModel;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.model.ParameterModel;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticManager;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.pageload.PageClassLoaderContextManager;
import org.apache.tapestry5.services.templates.ComponentTemplateLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentDependencyRegistryImpl
implements ComponentDependencyRegistry {
    private static final List<String> EMPTY_LIST = Collections.emptyList();
    private final PageClassLoaderContextManager pageClassLoaderContextManager;
    private static final String META_ATTRIBUTE = "injectedComponentDependencies";
    private static final String META_ATTRIBUTE_SEPARATOR = ",";
    private static final String NO_DEPENDENCY = "NONE";
    private final Map<String, Set<Dependency>> map;
    private final Set<String> alreadyProcessed;
    private final File storedDependencies;
    private static final ThreadLocal<Integer> INVALIDATIONS_DISABLED = ThreadLocal.withInitial(() -> 0);
    private final PlasticManager plasticManager;
    private final ComponentClassResolver resolver;
    private final TemplateParser templateParser;
    private final Map<String, Boolean> isPageCache = new WeakHashMap<String, Boolean>();
    private final ComponentTemplateLocator componentTemplateLocator;
    private final boolean storedDependencyInformationPresent;
    private boolean enableEnsureClassIsAlreadyProcessed = true;

    public ComponentDependencyRegistryImpl(PageClassLoaderContextManager pageClassLoaderContextManager, PlasticManager plasticManager, ComponentClassResolver componentClassResolver, TemplateParser templateParser, ComponentTemplateLocator componentTemplateLocator, @Symbol(value="tapestry.component-dependency-file") String componentDependencyFile, @Symbol(value="tapestry.production-mode") boolean productionMode) {
        this.pageClassLoaderContextManager = pageClassLoaderContextManager;
        this.map = new HashMap<String, Set<Dependency>>();
        this.alreadyProcessed = new HashSet<String>();
        this.plasticManager = plasticManager;
        this.resolver = componentClassResolver;
        this.templateParser = templateParser;
        this.componentTemplateLocator = componentTemplateLocator;
        if (!productionMode) {
            Logger logger = LoggerFactory.getLogger(ComponentDependencyRegistry.class);
            this.storedDependencies = new File(componentDependencyFile);
            boolean fileExists = this.storedDependencies.exists();
            logger.info("Component dependencies file: {} Found? {}", (Object)this.storedDependencies.getAbsolutePath(), (Object)fileExists);
            if (fileExists) {
                try (FileReader fileReader = new FileReader(this.storedDependencies);
                     BufferedReader reader = new BufferedReader(fileReader);){
                    StringBuilder builder = new StringBuilder();
                    String line = reader.readLine();
                    while (line != null) {
                        builder.append(line);
                        line = reader.readLine();
                    }
                    JSONArray jsonArray = new JSONArray(builder.toString());
                    for (int i = 0; i < jsonArray.size(); ++i) {
                        JSONObject jsonObject = jsonArray.getJSONObject(i);
                        String className = jsonObject.getString("class");
                        String type = jsonObject.getString("type");
                        if (!type.equals(NO_DEPENDENCY)) {
                            ComponentDependencyRegistry.DependencyType dependencyType = ComponentDependencyRegistry.DependencyType.valueOf(type);
                            String dependency = jsonObject.getString("dependency");
                            this.add(className, dependency, dependencyType);
                            this.alreadyProcessed.add(dependency);
                        }
                        this.alreadyProcessed.add(className);
                    }
                }
                catch (IOException e) {
                    throw new TapestryException("Exception trying to read " + this.storedDependencies.getAbsolutePath(), (Throwable)e);
                }
            }
        } else {
            this.storedDependencies = null;
        }
        this.storedDependencyInformationPresent = !this.map.isEmpty();
    }

    public void setupThreadCleanup(PerthreadManager perthreadManager) {
        perthreadManager.addThreadCleanupCallback(() -> INVALIDATIONS_DISABLED.set(0));
    }

    @Override
    public void register(Class<?> component) {
        this.register(component, component.getClassLoader());
    }

    @Override
    public void register(Class<?> component, ClassLoader classLoader) {
        String className = component.getName();
        if (this.alreadyProcessed.contains(className)) {
            return;
        }
        HashSet furtherDependencies = new HashSet();
        Consumer<Class<?>> processClass = furtherDependencies::add;
        Consumer<String> processClassName = s -> {
            try {
                furtherDependencies.add(classLoader.loadClass((String)s));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        };
        this.registerTemplate(component, processClassName);
        for (Field field : component.getDeclaredFields()) {
            Class<?> dependency;
            if (field.isAnnotationPresent(InjectComponent.class)) {
                dependency = field.getType();
                this.add(component, dependency, ComponentDependencyRegistry.DependencyType.USAGE);
                processClass.accept(dependency);
            }
            if (field.isAnnotationPresent(InjectPage.class)) {
                dependency = field.getType();
                this.add(component, dependency, ComponentDependencyRegistry.DependencyType.INJECT_PAGE);
                processClass.accept(dependency);
            }
            this.registerComponentInstance(field, processClassName);
            this.registerMixin(field, processClassName);
            this.registerComponentInstanceMixins(field, processClass, processClassName);
        }
        Class<?> superclass = component.getSuperclass();
        if (this.isTransformed(superclass)) {
            processClass.accept(superclass);
            this.add(component, superclass, ComponentDependencyRegistry.DependencyType.SUPERCLASS);
        }
        this.alreadyProcessed.add(className);
        for (Class dependency : furtherDependencies) {
            String dependencyClassName = dependency.getName();
            if (this.alreadyProcessed.contains(dependencyClassName) || !this.plasticManager.shouldInterceptClassLoading(dependency.getName())) continue;
            this.register(dependency, classLoader);
        }
    }

    private void registerTemplate(Class<?> component, Consumer<String> processClassName) {
        String className = component.getName();
        ComponentModelMock mock = new ComponentModelMock(component, this.isPage(className));
        Resource templateResource = this.componentTemplateLocator.locateTemplate(mock, Locale.getDefault());
        if (templateResource != null && templateResource.exists()) {
            ComponentTemplate template = this.templateParser.parseTemplate(templateResource);
            LinkedList<TemplateToken> tokens = new LinkedList<TemplateToken>();
            tokens.addAll(template.getTokens());
            for (String id : template.getExtensionPointIds()) {
                tokens.addAll(template.getExtensionPointTokens(id));
            }
            for (TemplateToken token : tokens) {
                String dependency;
                if (!(token instanceof StartComponentToken)) continue;
                StartComponentToken componentToken = (StartComponentToken)token;
                String logicalName = componentToken.getComponentType();
                if (logicalName != null) {
                    try {
                        dependency = this.resolver.resolveComponentTypeToClassName(logicalName);
                        this.add(className, dependency, ComponentDependencyRegistry.DependencyType.USAGE);
                        processClassName.accept(dependency);
                    }
                    catch (UnknownValueException unknownValueException) {
                        // empty catch block
                    }
                }
                for (String mixin : TapestryInternalUtils.splitAtCommas(componentToken.getMixins())) {
                    try {
                        if (mixin.contains("::")) {
                            mixin = mixin.substring(0, mixin.indexOf("::"));
                        }
                        dependency = this.resolver.resolveMixinTypeToClassName(mixin);
                        this.add(className, dependency, ComponentDependencyRegistry.DependencyType.USAGE);
                        processClassName.accept(dependency);
                    }
                    catch (UnknownValueException unknownValueException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private boolean isPage(String className) {
        Boolean result = this.isPageCache.get(className);
        if (result == null) {
            result = this.resolver.isPage(className);
            this.isPageCache.put(className, result);
        }
        return result;
    }

    private void registerComponentInstance(Field field, Consumer<String> processClassName) {
        if (field.isAnnotationPresent(Component.class)) {
            Component component = field.getAnnotation(Component.class);
            String typeFromAnnotation = component.type().trim();
            String dependency = typeFromAnnotation.isEmpty() ? field.getType().getName() : this.resolver.resolveComponentTypeToClassName(typeFromAnnotation);
            this.add(field.getDeclaringClass().getName(), dependency, ComponentDependencyRegistry.DependencyType.USAGE);
            processClassName.accept(dependency);
        }
    }

    private void registerMixin(Field field, Consumer<String> processClassName) {
        if (field.isAnnotationPresent(Mixin.class)) {
            String mixinType = field.getAnnotation(Mixin.class).value();
            String mixinClassName = InternalUtils.isBlank((String)mixinType) ? this.getFieldTypeClassName(field) : this.resolver.resolveMixinTypeToClassName(mixinType);
            this.add(this.getDeclaringClassName(field), mixinClassName, ComponentDependencyRegistry.DependencyType.USAGE);
            processClassName.accept(mixinClassName);
        }
    }

    private String getDeclaringClassName(Field field) {
        return field.getDeclaringClass().getName();
    }

    private String getFieldTypeClassName(Field field) {
        return field.getType().getName();
    }

    private void registerComponentInstanceMixins(Field field, Consumer<Class<?>> processClass, Consumer<String> processClassName) {
        if (field.isAnnotationPresent(Component.class)) {
            Mixins mixins;
            MixinClasses mixinClasses = field.getAnnotation(MixinClasses.class);
            if (mixinClasses != null) {
                for (Class dependency : mixinClasses.value()) {
                    this.add(field.getDeclaringClass(), dependency, ComponentDependencyRegistry.DependencyType.USAGE);
                    processClass.accept(dependency);
                }
            }
            if ((mixins = field.getAnnotation(Mixins.class)) != null) {
                for (String mixin : mixins.value()) {
                    Orderable<String> typeAndOrder = TapestryInternalUtils.mixinTypeAndOrder(mixin);
                    String dependency = this.resolver.resolveMixinTypeToClassName((String)typeAndOrder.getTarget());
                    this.add(this.getDeclaringClassName(field), dependency, ComponentDependencyRegistry.DependencyType.USAGE);
                    processClassName.accept(dependency);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(ComponentPageElement componentPageElement) {
        String componentClassName = this.getClassName(componentPageElement);
        if (!this.alreadyProcessed.contains(componentClassName)) {
            Map<String, Set<Dependency>> map = this.map;
            synchronized (map) {
                String metaDependencies;
                for (String id : componentPageElement.getEmbeddedElementIds()) {
                    ComponentPageElement child = componentPageElement.getEmbeddedElement(id);
                    this.add(componentPageElement, child, ComponentDependencyRegistry.DependencyType.USAGE);
                    this.register(child);
                }
                InternalComponentResources componentResources = componentPageElement.getComponentResources();
                ComponentModel componentModel = componentResources.getComponentModel();
                for (String string : componentModel.getMixinClassNames()) {
                    this.add(componentClassName, string, ComponentDependencyRegistry.DependencyType.USAGE);
                }
                List<String> embeddedComponentIds = componentModel.getEmbeddedComponentIds();
                for (String id : embeddedComponentIds) {
                    EmbeddedComponentModel embeddedComponentModel = componentResources.getComponentModel().getEmbeddedComponentModel(id);
                    List<String> mixinClassNames = embeddedComponentModel.getMixinClassNames();
                    for (String mixinClassName : mixinClassNames) {
                        this.add(componentClassName, mixinClassName, ComponentDependencyRegistry.DependencyType.USAGE);
                    }
                }
                org.apache.tapestry5.runtime.Component component = componentPageElement.getComponent();
                Class<?> parent = component.getClass().getSuperclass();
                if (parent != null && !Object.class.equals(parent)) {
                    this.add(componentClassName, parent.getName(), ComponentDependencyRegistry.DependencyType.SUPERCLASS);
                }
                if ((metaDependencies = component.getComponentResources().getComponentModel().getMeta(META_ATTRIBUTE)) != null) {
                    for (String dependency : metaDependencies.split(META_ATTRIBUTE_SEPARATOR)) {
                        this.add(componentClassName, dependency, this.isPage(dependency) ? ComponentDependencyRegistry.DependencyType.INJECT_PAGE : ComponentDependencyRegistry.DependencyType.USAGE);
                    }
                }
                this.alreadyProcessed.add(componentClassName);
            }
        }
    }

    @Override
    public void register(PlasticField plasticField, MutableComponentModel componentModel) {
        if (plasticField.hasAnnotation(InjectPage.class) || plasticField.hasAnnotation(InjectComponent.class) || plasticField.hasAnnotation(Component.class)) {
            String dependencies = componentModel.getMeta(META_ATTRIBUTE);
            String dependency = plasticField.getTypeName();
            if (dependencies == null) {
                dependencies = dependency;
            } else if (!dependencies.contains(dependency)) {
                dependencies = dependencies + META_ATTRIBUTE_SEPARATOR + dependency;
            }
            componentModel.setMeta(META_ATTRIBUTE, dependencies);
        }
    }

    private String getClassName(ComponentPageElement component) {
        return component.getComponentResources().getComponentModel().getComponentClassName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear(String className) {
        Map<String, Set<Dependency>> map = this.map;
        synchronized (map) {
            this.alreadyProcessed.remove(className);
            this.map.remove(className);
            Collection<Set<Dependency>> allDependentSets = this.map.values();
            for (Set<Dependency> dependents : allDependentSets) {
                if (dependents == null) continue;
                Iterator<Dependency> iterator = dependents.iterator();
                while (iterator.hasNext()) {
                    if (!className.equals(iterator.next().className)) continue;
                    iterator.remove();
                }
            }
        }
    }

    @Override
    public void clear(ComponentPageElement component) {
        this.clear(this.getClassName(component));
    }

    @Override
    public void clear() {
        this.map.clear();
        this.alreadyProcessed.clear();
    }

    @Override
    public Set<String> getDependents(String className) {
        this.ensureClassIsAlreadyProcessed(className);
        Set<Dependency> dependents = this.map.get(className);
        return dependents != null ? dependents.stream().map(d -> ((Dependency)d).className).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @Override
    public Set<String> getDependencies(String className, ComponentDependencyRegistry.DependencyType type) {
        this.ensureClassIsAlreadyProcessed(className);
        Set<String> dependencies = Collections.emptySet();
        if (this.alreadyProcessed.contains(className)) {
            dependencies = this.map.entrySet().stream().filter(e -> this.contains((Set)e.getValue(), className, type)).map(e -> (String)e.getKey()).collect(Collectors.toSet());
        }
        return dependencies;
    }

    @Override
    public Set<String> getAllNonPageDependencies(String className) {
        HashSet<String> dependencies = new HashSet<String>();
        this.getAllNonPageDependencies(className, dependencies);
        dependencies.remove(className);
        return Collections.unmodifiableSet(dependencies);
    }

    private void getAllNonPageDependencies(String className, Set<String> dependencies) {
        HashSet<String> theseDependencies = new HashSet<String>();
        theseDependencies.addAll(this.getDependencies(className, ComponentDependencyRegistry.DependencyType.USAGE));
        theseDependencies.addAll(this.getDependencies(className, ComponentDependencyRegistry.DependencyType.SUPERCLASS));
        theseDependencies.removeAll(dependencies);
        dependencies.addAll(theseDependencies);
        for (String dependency : theseDependencies) {
            this.getAllNonPageDependencies(dependency, dependencies);
        }
    }

    private boolean contains(Set<Dependency> dependencies, String className, ComponentDependencyRegistry.DependencyType type) {
        boolean contains = false;
        for (Dependency dependency : dependencies) {
            if (!dependency.type.equals((Object)type) || !dependency.className.equals(className)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    private void add(ComponentPageElement component, ComponentPageElement dependency, ComponentDependencyRegistry.DependencyType type) {
        this.add(this.getClassName(component), this.getClassName(dependency), type);
    }

    void add(String component, String dependency, ComponentDependencyRegistry.DependencyType type, boolean markAsAlreadyProcessed) {
        if (markAsAlreadyProcessed) {
            this.alreadyProcessed.add(component);
        }
        if (dependency != null) {
            this.add(component, dependency, type);
        }
    }

    private void add(Class<?> component, Class<?> dependency, ComponentDependencyRegistry.DependencyType type) {
        if (this.plasticManager.shouldInterceptClassLoading(dependency.getName())) {
            this.add(component.getName(), dependency.getName(), type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String component, String dependency, ComponentDependencyRegistry.DependencyType type) {
        Objects.requireNonNull(component, "Parameter component cannot be null");
        Objects.requireNonNull(dependency, "Parameter dependency cannot be null");
        Objects.requireNonNull(dependency, "Parameter type cannot be null");
        Map<String, Set<Dependency>> map = this.map;
        synchronized (map) {
            if (!component.equals(dependency)) {
                Set<Dependency> dependents = this.map.get(dependency);
                if (dependents == null) {
                    dependents = new HashSet<Dependency>();
                    this.map.put(dependency, dependents);
                }
                dependents.add(new Dependency(component, type));
            }
        }
    }

    @Override
    public void listen(InvalidationEventHub invalidationEventHub) {
        invalidationEventHub.addInvalidationCallback(this::listen);
    }

    List<String> listen(List<String> resources) {
        List<String> furtherDependents = EMPTY_LIST;
        if (resources.isEmpty()) {
            this.clear();
            furtherDependents = EMPTY_LIST;
        } else if (INVALIDATIONS_DISABLED.get() > 0) {
            furtherDependents = Collections.emptyList();
        } else if (!this.pageClassLoaderContextManager.isMerging()) {
            furtherDependents = new ArrayList<String>();
            for (String resource : resources) {
                if (resource.contains(":")) continue;
                Set<String> dependents = this.getDependents(resource);
                for (String furtherDependent : dependents) {
                    if (resources.contains(furtherDependent) || furtherDependents.contains(furtherDependent)) continue;
                    furtherDependents.add(furtherDependent);
                }
                this.clear(resource);
            }
        }
        return furtherDependents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeFile() {
        ComponentDependencyRegistryImpl componentDependencyRegistryImpl = this;
        synchronized (componentDependencyRegistryImpl) {
            try (FileWriter fileWriter = new FileWriter(this.storedDependencies);
                 BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
                HashSet<String> classNames = new HashSet<String>(this.alreadyProcessed.size());
                classNames.addAll(this.map.keySet());
                classNames.addAll(this.alreadyProcessed);
                JSONArray jsonArray = new JSONArray();
                for (String className : classNames) {
                    boolean hasDependencies = false;
                    for (ComponentDependencyRegistry.DependencyType dependencyType : ComponentDependencyRegistry.DependencyType.values()) {
                        Set<String> dependencies = this.getDependencies(className, dependencyType);
                        for (String dependency : dependencies) {
                            JSONObject object = new JSONObject();
                            object.put("class", (Object)className);
                            object.put("type", (Object)dependencyType.name());
                            object.put("dependency", (Object)dependency);
                            jsonArray.add((Object)object);
                            hasDependencies = true;
                        }
                    }
                    if (hasDependencies || !this.getDependents(className).isEmpty()) continue;
                    JSONObject object = new JSONObject();
                    object.put("class", (Object)className);
                    object.put("type", (Object)NO_DEPENDENCY);
                    jsonArray.add((Object)object);
                }
                bufferedWriter.write(jsonArray.toString());
            }
            catch (IOException e) {
                throw new TapestryException("Exception trying to write " + this.storedDependencies.getAbsolutePath(), (Throwable)e);
            }
            Logger logger = LoggerFactory.getLogger(ComponentDependencyRegistry.class);
            logger.info("Component dependencies written to {}", (Object)this.storedDependencies.getAbsolutePath());
        }
    }

    @Override
    public boolean contains(String className) {
        return this.alreadyProcessed.contains(className);
    }

    @Override
    public Set<String> getClassNames() {
        return Collections.unmodifiableSet(new HashSet<String>(this.alreadyProcessed));
    }

    @Override
    public Set<String> getRootClasses() {
        return this.alreadyProcessed.stream().filter(c -> this.getDependencies((String)c, ComponentDependencyRegistry.DependencyType.USAGE).isEmpty() && this.getDependencies((String)c, ComponentDependencyRegistry.DependencyType.INJECT_PAGE).isEmpty() && this.getDependencies((String)c, ComponentDependencyRegistry.DependencyType.SUPERCLASS).isEmpty()).collect(Collectors.toSet());
    }

    private boolean isTransformed(Class<?> clasz) {
        return this.plasticManager.shouldInterceptClassLoading(clasz.getName());
    }

    @Override
    public boolean isStoredDependencyInformationPresent() {
        return this.storedDependencyInformationPresent;
    }

    @Override
    public void disableInvalidations() {
        INVALIDATIONS_DISABLED.set(INVALIDATIONS_DISABLED.get() + 1);
    }

    @Override
    public void enableInvalidations() {
        INVALIDATIONS_DISABLED.set(INVALIDATIONS_DISABLED.get() - 1);
        if (INVALIDATIONS_DISABLED.get() < 0) {
            INVALIDATIONS_DISABLED.set(0);
        }
    }

    void setEnableEnsureClassIsAlreadyProcessed(boolean enableEnsureClassIsAlreadyProcessed) {
        this.enableEnsureClassIsAlreadyProcessed = enableEnsureClassIsAlreadyProcessed;
    }

    private void ensureClassIsAlreadyProcessed(String className) {
        if (this.enableEnsureClassIsAlreadyProcessed && !this.contains(className)) {
            ThrowawayClassLoader classLoader = new ThrowawayClassLoader(this.getClass().getClassLoader());
            try {
                this.register(classLoader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ComponentModelMock
    implements ComponentModel {
        private final Resource baseResource;
        private final boolean isPage;
        private final String componentClassName;

        public ComponentModelMock(Class<?> component, boolean isPage) {
            this.componentClassName = component.getName();
            String templateLocation = this.componentClassName.replace('.', '/');
            this.baseResource = new ClasspathResource(templateLocation);
            this.isPage = isPage;
        }

        @Override
        public Resource getBaseResource() {
            return this.baseResource;
        }

        @Override
        public String getLibraryName() {
            return null;
        }

        @Override
        public boolean isPage() {
            return this.isPage;
        }

        @Override
        public String getComponentClassName() {
            return this.componentClassName;
        }

        @Override
        public List<String> getEmbeddedComponentIds() {
            return null;
        }

        @Override
        public EmbeddedComponentModel getEmbeddedComponentModel(String componentId) {
            return null;
        }

        @Override
        public String getFieldPersistenceStrategy(String fieldName) {
            return null;
        }

        @Override
        public Logger getLogger() {
            return null;
        }

        @Override
        public List<String> getMixinClassNames() {
            return null;
        }

        @Override
        public ParameterModel getParameterModel(String parameterName) {
            return null;
        }

        @Override
        public boolean isFormalParameter(String parameterName) {
            return false;
        }

        @Override
        public List<String> getParameterNames() {
            return null;
        }

        @Override
        public List<String> getDeclaredParameterNames() {
            return null;
        }

        @Override
        public List<String> getPersistentFieldNames() {
            return null;
        }

        @Override
        public boolean isRootClass() {
            return false;
        }

        @Override
        public boolean getSupportsInformalParameters() {
            return false;
        }

        @Override
        public ComponentModel getParentModel() {
            return null;
        }

        @Override
        public boolean isMixinAfter() {
            return false;
        }

        @Override
        public String getMeta(String key) {
            return null;
        }

        @Override
        public Set<Class> getHandledRenderPhases() {
            return null;
        }

        @Override
        public boolean handlesEvent(String eventType) {
            return false;
        }

        @Override
        public String[] getOrderForMixin(String mixinClassName) {
            return null;
        }

        @Override
        public boolean handleActivationEventContext() {
            return false;
        }
    }

    private static final class Dependency {
        private final String className;
        private final ComponentDependencyRegistry.DependencyType type;

        public Dependency(String className, ComponentDependencyRegistry.DependencyType dependencyType) {
            this.className = className;
            this.type = dependencyType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.className, this.type});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Dependency)) {
                return false;
            }
            Dependency other = (Dependency)obj;
            return Objects.equals(this.className, other.className) && this.type == other.type;
        }

        public String toString() {
            return "Dependency [className=" + this.className + ", dependencyType=" + (Object)((Object)this.type) + "]";
        }
    }
}

