/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.components;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.commons.RecursiveValue;
import org.apache.tapestry5.commons.RecursiveValueProvider;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.dom.Node;
import org.apache.tapestry5.internal.RecursiveContext;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.Environment;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Recursive
implements RecursiveContext.Provider {
    private static final Logger logger = LoggerFactory.getLogger(Recursive.class);
    static final String RECURSIVE_INSERTION_POINT_ELEMENT_NAME = "recursiveInsertionPoint";
    static final String ITERATION_WRAPPER_ELEMENT_NAME = "iterationWrapper";
    static final String PLACEHOLDER_PREFIX = "placeholder-";
    private static final int ZERO = 0;
    @Parameter(required=true, allowNull=false)
    private Iterable<?> source;
    @Parameter(required=false, allowNull=true)
    private Integer depth;
    @Parameter(value="prop:resources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter
    private int currentDepth;
    @Parameter
    private Object value;
    private Iterator<RecursiveValue<?>> iterator;
    @Inject
    @Property
    private ComponentResources resources;
    private RecursiveValue<?> recursiveValue;
    @Inject
    private Environment environment;
    @Inject
    private RecursiveValueProvider recursiveValueProvider;
    @Inject
    private JavaScriptSupport javaScriptSupport;
    private Map<String, String> childToParentMap;
    private Map<String, RecursiveValue<?>> idToRecursiveValueMap;
    private Map<String, Integer> idToDepthMap;
    private Element wrapper;
    private List<Element> iterationWrappers;
    private List<Element> placeholders;
    private Set<String> ids;

    void setupRender(MarkupWriter writer) {
        this.idToRecursiveValueMap = new HashMap();
        this.idToDepthMap = new HashMap<String, Integer>();
        this.ids = new HashSet<String>();
        this.iterationWrappers = new ArrayList<Element>();
        this.placeholders = new ArrayList<Element>();
        this.wrapper = writer.element("wrapper", new Object[0]);
        this.childToParentMap = new HashMap<String, String>();
        this.environment.push(RecursiveContext.class, new RecursiveContext(this));
        ArrayList toStack = new ArrayList();
        Iterator<?> sourceIterator = this.source.iterator();
        int i = 1;
        while (sourceIterator.hasNext()) {
            Object valueFromSource = sourceIterator.next();
            RecursiveValue value = valueFromSource instanceof RecursiveValue ? (RecursiveValue)valueFromSource : this.recursiveValueProvider.get(valueFromSource);
            if (value == null) {
                throw new RuntimeException("No RecursiveValue object provided for " + value + ". You may need to write a RecursiveValueProvider.");
            }
            this.addToStack(value, toStack, this.getClientId(String.valueOf(i)));
            ++i;
        }
        this.iterator = toStack.iterator();
        this.recursiveValue = this.iterator.hasNext() ? this.iterator.next() : null;
    }

    private void addToStack(RecursiveValue<?> value, List<RecursiveValue<?>> stack, String id) {
        String parentId = StringUtils.substringAfter((String)this.childToParentMap.get(id), (String)PLACEHOLDER_PREFIX);
        Integer itemDepth = parentId == null ? 0 : this.idToDepthMap.get(parentId) + 1;
        if (this.depth == null || this.depth <= 0 || this.depth > itemDepth) {
            if (!stack.contains(value)) {
                stack.add(value);
                this.idToRecursiveValueMap.put(id, value);
                this.idToDepthMap.put(id, itemDepth);
            }
            int i = 1;
            List children = value.getChildren();
            if (children != null && !children.isEmpty()) {
                for (RecursiveValue child : children) {
                    if (!this.ids.contains(id)) {
                        String childId = id + "-" + i;
                        this.childToParentMap.put(childId, this.getPlaceholderClientId(id));
                        this.addToStack(child, stack, childId);
                        this.ids.add(childId);
                        ++i;
                        continue;
                    }
                    throw new RuntimeException("Two different objects with the same id: " + id);
                }
            }
        }
    }

    boolean beginRender(MarkupWriter writer) {
        boolean continueRendering = this.recursiveValue != null;
        String id = this.findCurrentRecursiveValueId(this.recursiveValue);
        this.currentDepth = this.idToDepthMap.get(id) != null ? this.idToDepthMap.get(id) : 0;
        this.iterationWrappers.add(writer.element(ITERATION_WRAPPER_ELEMENT_NAME, "id", id));
        this.value = this.recursiveValue != null ? this.recursiveValue.getValue() : null;
        return continueRendering;
    }

    private String findCurrentRecursiveValueId(RecursiveValue<?> recursiveValue) {
        String id = null;
        Set<Map.Entry<String, RecursiveValue<?>>> entrySet = this.idToRecursiveValueMap.entrySet();
        for (Map.Entry<String, RecursiveValue<?>> entry : entrySet) {
            if (entry.getValue() != recursiveValue) continue;
            id = entry.getKey();
        }
        return id;
    }

    boolean afterRender(MarkupWriter writer) {
        writer.end();
        this.recursiveValue = this.iterator.hasNext() ? this.iterator.next() : null;
        return this.recursiveValue == null;
    }

    void cleanupRender(MarkupWriter writer) {
        writer.end();
        this.environment.pop(RecursiveContext.class);
        for (Element iterationWrapper : this.iterationWrappers) {
            String id = iterationWrapper.getAttribute("id");
            String parentId = this.childToParentMap.get(id);
            if (parentId != null) {
                Element placeholder = this.wrapper.getElementById(parentId);
                if (placeholder != null) {
                    for (Node node : iterationWrapper.getChildren()) {
                        try {
                            node.moveToBottom(placeholder);
                        }
                        catch (IllegalArgumentException e) {
                            logger.error(e.getMessage() + " " + node + " " + placeholder);
                        }
                    }
                }
                iterationWrapper.remove();
                continue;
            }
            List<Node> children = iterationWrapper.getChildren();
            for (int i = children.size(); i > 0; --i) {
                children.get(i - 1).moveAfter(iterationWrapper);
            }
            iterationWrapper.remove();
        }
        for (Element placeholder : this.placeholders) {
            placeholder.pop();
        }
        this.childToParentMap.clear();
        this.childToParentMap = null;
        this.placeholders.clear();
        this.placeholders = null;
        this.iterationWrappers.clear();
        this.iterationWrappers = null;
        this.wrapper.pop();
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientId(String value) {
        return this.getClientId() + "-" + this.encode(value);
    }

    public String getPlaceholderClientId(String value) {
        return PLACEHOLDER_PREFIX + this.encode(value);
    }

    private final String encode(String value) {
        return URLEncoder.encode(value);
    }

    @Override
    public RecursiveValue<?> getCurrent() {
        return this.recursiveValue;
    }

    @Override
    public String getClientIdForCurrent() {
        return this.getPlaceholderClientId(this.findCurrentRecursiveValueId(this.getCurrent()));
    }

    @Override
    public void registerPlaceholder(Element element) {
        this.placeholders.add(element);
    }
}

