/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services.rest;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tapestry5.ioc.services.ClassNameLocator;
import org.apache.tapestry5.services.rest.MappedEntityManager;

public class MappedEntityManagerImpl
implements MappedEntityManager {
    private final Set<Class<?>> entities;

    public MappedEntityManagerImpl(Collection<String> packages, ClassNameLocator classNameLocator) {
        HashSet classes = new HashSet();
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (String packageName : packages) {
            for (String className : classNameLocator.locateClassNames(packageName)) {
                try {
                    Class<?> entityClass = contextClassLoader.loadClass(className);
                    classes.add(entityClass);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        this.entities = Collections.unmodifiableSet(new HashSet(classes));
    }

    @Override
    public Set<Class<?>> getEntities() {
        return this.entities;
    }
}

