/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.services.assets.BytestreamCache;
import org.apache.tapestry5.internal.webresources.CacheMode;
import org.apache.tapestry5.internal.webresources.ContentChangeTracker;
import org.apache.tapestry5.internal.webresources.DelegatingResourceTransformer;
import org.apache.tapestry5.internal.webresources.ResourceDependenciesSplitter;
import org.apache.tapestry5.internal.webresources.ResourceTransformUtils;
import org.apache.tapestry5.internal.webresources.ResourceTransformerFactory;
import org.apache.tapestry5.ioc.IOOperation;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.assets.ResourceDependencies;
import org.apache.tapestry5.services.assets.ResourceTransformer;
import org.slf4j.Logger;

public class ResourceTransformerFactoryImpl
implements ResourceTransformerFactory {
    private final Logger logger;
    private final OperationTracker tracker;
    private final boolean productionMode;
    private final File cacheDir;

    public ResourceTransformerFactoryImpl(Logger logger, OperationTracker tracker, @Symbol(value="tapestry.production-mode") boolean productionMode, @Symbol(value="tapestry.compiled-asset-cache-dir") String cacheDir) {
        this.logger = logger;
        this.tracker = tracker;
        this.productionMode = productionMode;
        this.cacheDir = new File(cacheDir);
        if (!productionMode) {
            logger.info(String.format("Using %s to store compiled assets (development mode only).", cacheDir));
        }
    }

    @PostInjection
    public void createCacheDir(@Symbol(value="tapestry.restrictive-environment") boolean restrictive) {
        if (!restrictive) {
            this.cacheDir.mkdirs();
        }
    }

    @Override
    public ResourceTransformer createCompiler(String contentType, String sourceName, String targetName, ResourceTransformer transformer, CacheMode cacheMode) {
        ResourceTransformer trackingCompiler = this.wrapWithTracking(sourceName, targetName, transformer);
        if (this.productionMode) {
            return trackingCompiler;
        }
        ResourceTransformer timingCompiler = this.wrapWithTiming(targetName, trackingCompiler);
        switch (cacheMode) {
            case NONE: {
                return timingCompiler;
            }
            case SINGLE_FILE: {
                return this.wrapWithFileSystemCaching(timingCompiler, targetName);
            }
            case MULTIPLE_FILE: {
                return this.wrapWithInMemoryCaching(timingCompiler, targetName);
            }
        }
        throw new IllegalStateException();
    }

    private ResourceTransformer wrapWithTracking(final String sourceName, final String targetName, ResourceTransformer core) {
        return new DelegatingResourceTransformer(core){

            public InputStream transform(final Resource source, final ResourceDependencies dependencies) throws IOException {
                String description = String.format("Compiling %s from %s to %s", source, sourceName, targetName);
                return (InputStream)ResourceTransformerFactoryImpl.this.tracker.perform(description, (IOOperation)new IOOperation<InputStream>(){

                    public InputStream perform() throws IOException {
                        return delegate.transform(source, dependencies);
                    }
                });
            }
        };
    }

    private ResourceTransformer wrapWithTiming(final String targetName, ResourceTransformer coreCompiler) {
        return new DelegatingResourceTransformer(coreCompiler){

            public InputStream transform(Resource source, ResourceDependencies dependencies) throws IOException {
                long startTime = System.nanoTime();
                InputStream result = this.delegate.transform(source, dependencies);
                long elapsedTime = System.nanoTime() - startTime;
                ResourceTransformerFactoryImpl.this.logger.info(String.format("Compiled %s to %s in %.2f ms", source, targetName, ResourceTransformUtils.nanosToMillis(elapsedTime)));
                return result;
            }
        };
    }

    private ResourceTransformer wrapWithInMemoryCaching(ResourceTransformer core, final String targetName) {
        return new DelegatingResourceTransformer(core){
            final Map<Resource, Compiled> cache;
            {
                super(delegate);
                this.cache = CollectionFactory.newConcurrentMap();
            }

            public InputStream transform(Resource source, ResourceDependencies dependencies) throws IOException {
                Compiled compiled = this.cache.get(source);
                if (compiled != null && !compiled.dirty()) {
                    ResourceTransformerFactoryImpl.this.logger.info(String.format("Resource %s and dependencies are unchanged; serving compiled %s content from in-memory cache", source, targetName));
                    return compiled.openStream();
                }
                compiled = new Compiled(source);
                InputStream is = this.delegate.transform(source, (ResourceDependencies)new ResourceDependenciesSplitter(dependencies, compiled));
                compiled.store(is);
                is.close();
                this.cache.put(source, compiled);
                return compiled.openStream();
            }
        };
    }

    private ResourceTransformer wrapWithFileSystemCaching(ResourceTransformer core, final String targetName) {
        return new DelegatingResourceTransformer(core){

            public InputStream transform(Resource source, ResourceDependencies dependencies) throws IOException {
                long checksum = ResourceTransformUtils.toChecksum(source);
                String fileName = Long.toHexString(checksum) + "-" + source.getFile();
                File cacheFile = new File(ResourceTransformerFactoryImpl.this.cacheDir, fileName);
                if (cacheFile.exists()) {
                    ResourceTransformerFactoryImpl.this.logger.debug(String.format("Serving up compiled %s content for %s from file system cache", targetName, source));
                    return new BufferedInputStream(new FileInputStream(cacheFile));
                }
                InputStream compiled = this.delegate.transform(source, dependencies);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                TapestryInternalUtils.copy((InputStream)compiled, (OutputStream)bos);
                compiled.close();
                BytestreamCache cache = new BytestreamCache(bos);
                ResourceTransformerFactoryImpl.this.writeToCacheFile(cacheFile, cache.openStream());
                return cache.openStream();
            }
        };
    }

    private void writeToCacheFile(File file, InputStream stream) throws IOException {
        BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));
        TapestryInternalUtils.copy((InputStream)stream, (OutputStream)outputStream);
        ((OutputStream)outputStream).close();
    }

    static class Compiled
    extends ContentChangeTracker {
        private BytestreamCache bytestreamCache;

        Compiled(Resource root) {
            this.addDependency(root);
        }

        void store(InputStream stream) throws IOException {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            TapestryInternalUtils.copy((InputStream)stream, (OutputStream)bos);
            stream.close();
            bos.close();
            this.bytestreamCache = new BytestreamCache(bos);
        }

        InputStream openStream() {
            return this.bytestreamCache.openStream();
        }
    }
}

