/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.BuiltinNaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MultiReturnParameterizedBuiltinCPInstruction;
import org.apache.sysds.runtime.instructions.cp.SqlCPInstruction;
import org.apache.sysds.runtime.instructions.cp.VariableCPInstruction;
import org.apache.sysds.runtime.lineage.Lineage;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class LineageDebugger {
    public static final int POS_NAN = 0;
    public static final int POS_POSITIVE_INFINITY = 1;
    public static final int POS_NEGATIVE_INFINITY = 2;

    public static void maintainSpecialValueBits(Lineage lineage, Instruction inst, ExecutionContext ec) {
        List<CPOperand> multiOutputs;
        CPOperand singleOutput;
        ArrayList<CPOperand> outputs = new ArrayList<CPOperand>();
        CPOperand cPOperand = inst instanceof ComputationCPInstruction ? ((ComputationCPInstruction)inst).getOutput() : (inst instanceof BuiltinNaryCPInstruction ? ((BuiltinNaryCPInstruction)inst).getOutput() : (inst instanceof SqlCPInstruction ? ((SqlCPInstruction)inst).getOutput() : (singleOutput = inst instanceof VariableCPInstruction ? ((VariableCPInstruction)inst).getOutput() : null)));
        if (singleOutput != null) {
            outputs.add(singleOutput);
        }
        List<CPOperand> list = inst instanceof MultiReturnBuiltinCPInstruction ? ((MultiReturnBuiltinCPInstruction)inst).getOutputs() : (multiOutputs = inst instanceof MultiReturnParameterizedBuiltinCPInstruction ? ((MultiReturnParameterizedBuiltinCPInstruction)inst).getOutputs() : null);
        if (multiOutputs != null) {
            outputs.addAll(multiOutputs);
        }
        for (CPOperand output : outputs) {
            MatrixObject cd = ec.getMatrixObject(output);
            MatrixBlock mb = (MatrixBlock)cd.acquireReadAndRelease();
            LineageItem li = lineage.get(output);
            LineageDebugger.updateSpecialValueBit(mb, li, 0, Double.NaN);
            LineageDebugger.updateSpecialValueBit(mb, li, 1, Double.POSITIVE_INFINITY);
            LineageDebugger.updateSpecialValueBit(mb, li, 2, Double.NEGATIVE_INFINITY);
        }
    }

    public static LineageItem firstOccurrenceOfNR(LineageItem li, int pos) {
        LineageItem tmp;
        if (!li.getSpecialValueBit(pos)) {
            return null;
        }
        LinkedList<LineageItem> q = new LinkedList<LineageItem>();
        q.add(li);
        while ((tmp = (LineageItem)q.poll()) != null) {
            if (tmp.isVisited()) continue;
            if (tmp.getInputs() != null) {
                boolean flag = false;
                for (LineageItem in : tmp.getInputs()) {
                    flag |= in.getSpecialValueBit(pos);
                    q.add(in);
                }
                if (!flag) break;
            }
            tmp.setVisited(true);
        }
        li.resetVisitStatusNR();
        return tmp;
    }

    private static void updateSpecialValueBit(MatrixBlock mb, LineageItem li, int pos, double pattern) {
        boolean flag = false;
        for (LineageItem input : li.getInputs()) {
            if (!input.getSpecialValueBit(pos)) continue;
            flag = true;
            break;
        }
        li.setSpecialValueBit(pos, flag |= mb.containsValue(pattern));
    }
}

