/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.Comparator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.ComputationCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DataGenCPInstruction;
import org.apache.sysds.runtime.instructions.cp.ListIndexingCPInstruction;
import org.apache.sysds.runtime.instructions.cp.MatrixIndexingCPInstruction;
import org.apache.sysds.runtime.instructions.fed.ComputationFEDInstruction;
import org.apache.sysds.runtime.instructions.gpu.GPUInstruction;
import org.apache.sysds.runtime.instructions.spark.ComputationSPInstruction;
import org.apache.sysds.runtime.instructions.spark.CpmmSPInstruction;
import org.apache.sysds.runtime.instructions.spark.MapmmSPInstruction;
import org.apache.sysds.runtime.lineage.LineageCacheEntry;

public class LineageCacheConfig {
    private static final String[] OPCODES = new String[]{"tsmm", "ba+*", "*", "/", "+", "||", "nrow", "ncol", "round", "exp", "log", "rightIndex", "leftIndex", "groupedagg", "r'", "solve", "spoof", "uamean", "max", "min", "ifelse", "-", "sqrt", ">", "uak+", "<=", "^", "uamax", "uark+", "uacmean", "eigen", "ctableexpand", "replace", "^2", "uack+", "tak+*", "uacsqk+", "uark+", "n+", "uarimax", "qsort", "qpick", "transformapply", "uarmax", "n+", "-*", "castdtm", "lowertri", "mapmm", "cpmm", "rmm", "prefetch", "chkpoint"};
    private static final String[] PERSIST_OPCODES = new String[]{"mapmm", "cpmm", "rmm"};
    private static String[] REUSE_OPCODES = new String[0];
    private static String[] CHKPOINT_OPCODES = new String[0];
    protected static final double CPU_CACHE_FRAC = 0.05;
    protected static final double GPU_CACHE_MAX = 0.3;
    private static ReuseCacheType _cacheType = null;
    private static CachedItemHead _itemH = null;
    private static CachedItemTail _itemT = null;
    private static boolean _compilerAssistedRW = false;
    private static boolean _onlyEstimate = false;
    public static final double MIN_SPILL_TIME_ESTIMATE = 10.0;
    public static final double MIN_SPILL_DATA = 2.0;
    public static double FSREAD_DENSE = 500.0;
    public static double FSREAD_SPARSE = 400.0;
    public static double FSWRITE_DENSE = 450.0;
    public static double FSWRITE_SPARSE = 225.0;
    public static double D2HCOPY = 1500.0;
    public static double D2HMAXBANDWIDTH = 8192.0;
    private static LineageCachePolicy _cachepolicy = null;
    protected static double[] WEIGHTS = new double[]{1.0, 0.0, 0.0};
    public static boolean CONCURRENTGPUEVICTION = false;
    public static volatile boolean STOPBACKGROUNDEVICTION = false;
    protected static Comparator<LineageCacheEntry> LineageCacheComparator = (e1, e2) -> {
        int ret = 0;
        if (e1.score == e2.score) {
            switch (_cachepolicy) {
                case LRU: 
                case DAGHEIGHT: {
                    double e1_cs = e1.getCostNsize();
                    double e2_cs = e2.getCostNsize();
                    ret = e1_cs == e2_cs ? Long.compare(e1._key.getId(), e2._key.getId()) : (e1_cs < e2_cs ? -1 : 1);
                    break;
                }
                case COSTNSIZE: {
                    double e1_ts = e1.getTimestamp();
                    double e2_ts = e2.getTimestamp();
                    ret = e1_ts == e2_ts ? Long.compare(e1._key.getId(), e2._key.getId()) : (e1_ts < e2_ts ? -1 : 1);
                    break;
                }
            }
        } else {
            ret = e1.score < e2.score ? -1 : 1;
        }
        return ret;
    };
    protected static boolean ENABLE_LOCAL_ONLY_RDD_CACHING = false;

    public static void setReusableOpcodes(String ... ops) {
        REUSE_OPCODES = ops;
    }

    public static String[] getReusableOpcodes() {
        return REUSE_OPCODES;
    }

    public static void resetReusableOpcodes() {
        REUSE_OPCODES = OPCODES;
    }

    public static boolean isReusable(Instruction inst, ExecutionContext ec) {
        boolean insttype = (inst instanceof ComputationCPInstruction || inst instanceof ComputationFEDInstruction || inst instanceof GPUInstruction || inst instanceof ComputationSPInstruction) && !(inst instanceof ListIndexingCPInstruction);
        boolean rightop = ArrayUtils.contains((Object[])REUSE_OPCODES, (Object)inst.getOpcode()) || inst.getOpcode().equals("append") && LineageCacheConfig.isVectorAppend(inst, ec) || inst.getOpcode().startsWith("spoof") || inst instanceof DataGenCPInstruction && ((DataGenCPInstruction)inst).isMatrixCall();
        boolean updateInplace = inst instanceof MatrixIndexingCPInstruction && ec.getMatrixObject(((ComputationCPInstruction)inst).input1).getUpdateType().isInPlace();
        boolean federatedOutput = false;
        return insttype && rightop && !updateInplace && !federatedOutput;
    }

    private static boolean isVectorAppend(Instruction inst, ExecutionContext ec) {
        if (inst instanceof ComputationFEDInstruction) {
            ComputationFEDInstruction fedinst = (ComputationFEDInstruction)inst;
            if (!fedinst.input1.isMatrix() || !fedinst.input2.isMatrix()) {
                return false;
            }
            long c1 = ec.getMatrixObject(fedinst.input1).getNumColumns();
            long c2 = ec.getMatrixObject(fedinst.input2).getNumColumns();
            return c1 == 1L || c2 == 1L;
        }
        if (inst instanceof ComputationCPInstruction) {
            ComputationCPInstruction cpinst = (ComputationCPInstruction)inst;
            if (!cpinst.input1.isMatrix() || !cpinst.input2.isMatrix()) {
                return false;
            }
            long c1 = ec.getMatrixObject(cpinst.input1).getNumColumns();
            long c2 = ec.getMatrixObject(cpinst.input2).getNumColumns();
            return c1 == 1L || c2 == 1L;
        }
        if (inst instanceof ComputationSPInstruction) {
            ComputationSPInstruction fedinst = (ComputationSPInstruction)inst;
            if (!fedinst.input1.isMatrix() || !fedinst.input2.isMatrix()) {
                return false;
            }
            long c1 = ec.getMatrixObject(fedinst.input1).getNumColumns();
            long c2 = ec.getMatrixObject(fedinst.input2).getNumColumns();
            return c1 == 1L || c2 == 1L;
        }
        GPUInstruction gpuinst = (GPUInstruction)inst;
        if (!gpuinst._input1.isMatrix() || !gpuinst._input2.isMatrix()) {
            return false;
        }
        long c1 = ec.getMatrixObject(gpuinst._input1).getNumColumns();
        long c2 = ec.getMatrixObject(gpuinst._input2).getNumColumns();
        return c1 == 1L || c2 == 1L;
    }

    protected static boolean isReusableRDDType(Instruction inst) {
        boolean insttype = inst instanceof ComputationSPInstruction;
        boolean rightOp = ArrayUtils.contains((Object[])CHKPOINT_OPCODES, (Object)inst.getOpcode());
        if (rightOp && inst instanceof MapmmSPInstruction && ((MapmmSPInstruction)inst).getAggType() == AggBinaryOp.SparkAggType.SINGLE_BLOCK) {
            rightOp = false;
        }
        if (rightOp && inst instanceof CpmmSPInstruction && ((CpmmSPInstruction)inst).getAggType() == AggBinaryOp.SparkAggType.SINGLE_BLOCK) {
            rightOp = false;
        }
        return insttype && rightOp;
    }

    public static boolean isOutputFederated(Instruction inst, Data data) {
        if (!(inst instanceof ComputationFEDInstruction)) {
            return false;
        }
        return inst instanceof ComputationFEDInstruction && data instanceof MatrixObject && ((MatrixObject)data).isFederated();
    }

    public static void setConfigTsmmCbind(ReuseCacheType ct) {
        _cacheType = ct;
        _itemH = CachedItemHead.TSMM;
        _itemT = CachedItemTail.CBIND;
    }

    public static void setConfig(ReuseCacheType ct) {
        _cacheType = ct;
    }

    public static void setConfig(ReuseCacheType ct, CachedItemHead ith, CachedItemTail itt) {
        _cacheType = ct;
        _itemH = ith;
        _itemT = itt;
    }

    public static void setCompAssRW(boolean comp) {
        _compilerAssistedRW = comp;
    }

    public static void shutdownReuse() {
        DMLScript.LINEAGE = false;
        DMLScript.LINEAGE_REUSE = ReuseCacheType.NONE;
    }

    public static void restartReuse(ReuseCacheType rop) {
        DMLScript.LINEAGE = true;
        DMLScript.LINEAGE_REUSE = rop;
    }

    public static ReuseCacheType getCacheType() {
        return _cacheType;
    }

    public static boolean isMultiLevelReuse() {
        return !ReuseCacheType.isNone() && _cacheType.isMultilevelReuse();
    }

    public static CachedItemHead getCachedItemHead() {
        return _itemH;
    }

    public static CachedItemTail getCachedItemTail() {
        return _itemT;
    }

    public static boolean getCompAssRW() {
        return _compilerAssistedRW;
    }

    public static void setCachePolicy(LineageCachePolicy policy) {
        switch (policy) {
            case LRU: {
                LineageCacheConfig.WEIGHTS[0] = 0.0;
                LineageCacheConfig.WEIGHTS[1] = 1.0;
                LineageCacheConfig.WEIGHTS[2] = 0.0;
                break;
            }
            case COSTNSIZE: {
                LineageCacheConfig.WEIGHTS[0] = 1.0;
                LineageCacheConfig.WEIGHTS[1] = 0.0;
                LineageCacheConfig.WEIGHTS[2] = 0.0;
                break;
            }
            case DAGHEIGHT: {
                LineageCacheConfig.WEIGHTS[0] = 0.0;
                LineageCacheConfig.WEIGHTS[1] = 0.0;
                LineageCacheConfig.WEIGHTS[2] = 1.0;
            }
        }
        _cachepolicy = policy;
    }

    public static LineageCachePolicy getCachePolicy() {
        return _cachepolicy;
    }

    public static void setEstimator(boolean onlyEstimator) {
        _onlyEstimate = onlyEstimator;
    }

    public static boolean isEstimator() {
        return _onlyEstimate;
    }

    public static boolean isTimeBased() {
        return WEIGHTS[1] > 0.0;
    }

    public static boolean isCostNsize() {
        return WEIGHTS[0] > 0.0;
    }

    public static boolean isDagHeightBased() {
        return WEIGHTS[2] > 0.0;
    }

    public static boolean isSetSpill() {
        DMLConfig conf = ConfigurationManager.getDMLConfig();
        return conf.getBooleanValue("sysds.lineage.cachespill");
    }

    static {
        REUSE_OPCODES = OPCODES;
        CHKPOINT_OPCODES = PERSIST_OPCODES;
        LineageCacheConfig.setCachePolicy(LineageCachePolicy.COSTNSIZE);
        LineageCacheConfig.setCompAssRW(true);
    }

    public static enum LineageCachePolicy {
        LRU,
        COSTNSIZE,
        DAGHEIGHT;

    }

    protected static enum LineageCacheStatus {
        EMPTY,
        NOTCACHED,
        CACHED,
        SPILLED,
        RELOADED,
        PINNED,
        GPUCACHED,
        TOSPILL,
        TODELETE;


        public boolean canEvict() {
            return this == CACHED || this == RELOADED;
        }
    }

    private static enum CachedItemTail {
        CBIND,
        RBIND,
        INDEX,
        ALL;

    }

    private static enum CachedItemHead {
        TSMM,
        ALL;

    }

    public static enum ReuseCacheType {
        REUSE_FULL,
        REUSE_PARTIAL,
        REUSE_MULTILEVEL,
        REUSE_HYBRID,
        NONE;


        public boolean isFullReuse() {
            return this == REUSE_FULL || this == REUSE_MULTILEVEL || this == REUSE_HYBRID;
        }

        public boolean isPartialReuse() {
            return this == REUSE_PARTIAL || this == REUSE_HYBRID;
        }

        public boolean isMultilevelReuse() {
            return this == REUSE_MULTILEVEL || this == REUSE_HYBRID;
        }

        public static boolean isNone() {
            return DMLScript.LINEAGE_REUSE == null || DMLScript.LINEAGE_REUSE == NONE;
        }
    }
}

