/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.UtilFunctions;

public interface Util {
    public static final Log LOG = LogFactory.getLog((String)Util.class.getName());

    public static int[] combine(int[] lhs, int[] rhs) {
        int[] joined = new int[lhs.length + rhs.length];
        int lp = 0;
        int rp = 0;
        for (int i = 0; i < joined.length && lp < lhs.length && rp < rhs.length; ++i) {
            joined[i] = lhs[lp] < rhs[rp] ? lhs[lp++] : rhs[rp++];
        }
        while (lp < lhs.length) {
            joined[i++] = lhs[lp++];
        }
        while (rp < rhs.length) {
            joined[i++] = rhs[rp++];
        }
        return joined;
    }

    public static int getPow2(int x) {
        int v = UtilFunctions.nextIntPow2(x + 1);
        return Math.max(v, 4);
    }

    public static int[] genColsIndices(int numCols) {
        int[] colIndices = new int[numCols];
        for (int i = 0; i < numCols; ++i) {
            colIndices[i] = i;
        }
        return colIndices;
    }

    public static int[] genColsIndices(int cl, int cu) {
        int[] colIndices = new int[cu - cl];
        int i = 0;
        int j = cl;
        while (j < cu) {
            colIndices[i] = j++;
            ++i;
        }
        return colIndices;
    }

    public static int[] genColsIndicesOffset(int numCols, int start) {
        int[] colIndices = new int[numCols];
        int j = start;
        for (int i = 0; i < numCols; ++i) {
            colIndices[i] = j++;
        }
        return colIndices;
    }

    public static MatrixBlock matrixBlockFromDenseArray(double[] values, int nCol) {
        return Util.matrixBlockFromDenseArray(values, nCol, true);
    }

    public static MatrixBlock matrixBlockFromDenseArray(double[] values, int nCol, boolean check) {
        int nRow = values.length / nCol;
        DenseBlockFP64 dictV = new DenseBlockFP64(new int[]{nRow, nCol}, values);
        MatrixBlock ret = new MatrixBlock(nRow, nCol, dictV);
        if (check) {
            ret.recomputeNonZeros();
            ret.examSparsity(true);
        } else {
            ret.setNonZeros(-1L);
        }
        return ret;
    }

    public static MatrixBlock extractValues(double[] v, IColIndex colIndexes) {
        MatrixBlock rowVector = new MatrixBlock(1, colIndexes.size(), false);
        for (int i = 0; i < colIndexes.size(); ++i) {
            rowVector.quickSetValue(0, i, v[colIndexes.get(i)]);
        }
        return rowVector;
    }
}

