/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AColGroupCompressed;
import org.apache.sysds.runtime.compress.colgroup.ASDCZero;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingle;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCZeros;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffsetIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupSDCSingleZeros
extends ASDCZero {
    private static final long serialVersionUID = 8033235615964315078L;

    protected ColGroupSDCSingleZeros(int numRows) {
        super(numRows);
    }

    private ColGroupSDCSingleZeros(int[] colIndices, int numRows, ADictionary dict, AOffset offsets, int[] cachedCounts) {
        super(colIndices, numRows, dict, offsets, cachedCounts);
        this._zeros = true;
    }

    protected static AColGroup create(int[] colIndices, int numRows, ADictionary dict, AOffset offsets, int[] cachedCounts) {
        if (dict == null) {
            return new ColGroupEmpty(colIndices);
        }
        return new ColGroupSDCSingleZeros(colIndices, numRows, dict, offsets, cachedCounts);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.SDC;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.SDCSingleZeros;
    }

    @Override
    protected void decompressToDenseBlockDenseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, double[] values) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        } else {
            this.decompressToDenseBlockDenseDictionaryWithProvidedIterator(db, rl, ru, offR, offC, values, it);
        }
    }

    @Override
    public void decompressToDenseBlockDenseDictionaryWithProvidedIterator(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int last = this._indexes.getOffsetToLast();
        if (it == null || it.value() >= ru || rl > last) {
            return;
        }
        if (ru > this._indexes.getOffsetToLast()) {
            this.decompressToDenseBlockDenseDictionaryPost(db, rl, ru, offR, offC, values, it);
        } else {
            if (this._colIndexes.length == 1 && db.getDim(1) == 1) {
                this.decompressToDenseBlockDenseDictionaryPreSingleColOutContiguous(db, rl, ru, offR, offC, values, it);
            } else {
                this.decompressToDenseBlockDenseDictionaryPre(db, rl, ru, offR, offC, values, it);
            }
            this._indexes.cacheIterator(it, ru);
        }
    }

    private void decompressToDenseBlockDenseDictionaryPost(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int j;
        int maxOff = this._indexes.getOffsetToLast();
        int nCol = this._colIndexes.length;
        int row = offR + it.value();
        double[] c = db.values(row);
        int off = db.pos(row);
        for (j = 0; j < nCol; ++j) {
            int n = off + this._colIndexes[j] + offC;
            c[n] = c[n] + values[j];
        }
        while (it.value() < maxOff) {
            it.next();
            row = offR + it.value();
            c = db.values(row);
            off = db.pos(row);
            for (j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes[j] + offC;
                c[n] = c[n] + values[j];
            }
        }
    }

    private void decompressToDenseBlockDenseDictionaryPreSingleColOutContiguous(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        double[] c = db.values(0);
        double v = values[0];
        int r = it.value();
        while (r < ru) {
            int n = offR + r;
            c[n] = c[n] + v;
            r = it.next();
        }
    }

    private void decompressToDenseBlockDenseDictionaryPre(DenseBlock db, int rl, int ru, int offR, int offC, double[] values, AIterator it) {
        int nCol = this._colIndexes.length;
        int r = it.value();
        while (r < ru) {
            int row = offR + r;
            double[] c = db.values(row);
            int off = db.pos(row);
            for (int j = 0; j < nCol; ++j) {
                int n = off + this._colIndexes[j] + offC;
                c[n] = c[n] + values[j];
            }
            r = it.next();
        }
    }

    @Override
    protected void decompressToDenseBlockSparseDictionary(DenseBlock db, int rl, int ru, int offR, int offC, SparseBlock sb) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        } else {
            if (ru > this._indexes.getOffsetToLast()) {
                throw new NotImplementedException();
            }
            int apos = sb.pos(0);
            int alen = sb.size(0) + apos;
            int[] aix = sb.indexes(0);
            double[] avals = sb.values(0);
            while (it.isNotOver(ru)) {
                int row = offR + it.value();
                double[] c = db.values(row);
                int off = db.pos(row);
                for (int j = apos; j < alen; ++j) {
                    int n = off + this._colIndexes[aix[j]] + offC;
                    c[n] = c[n] + avals[j];
                }
                it.next();
            }
            this._indexes.cacheIterator(it, ru);
        }
    }

    @Override
    protected void decompressToSparseBlockSparseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, SparseBlock sb) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        } else {
            if (ru > this._indexes.getOffsetToLast()) {
                throw new NotImplementedException();
            }
            int apos = sb.pos(0);
            int alen = sb.size(0) + apos;
            int[] aix = sb.indexes(0);
            double[] avals = sb.values(0);
            while (it.isNotOver(ru)) {
                int row = offR + it.value();
                for (int j = apos; j < alen; ++j) {
                    ret.append(row, this._colIndexes[aix[j]] + offC, avals[j]);
                }
                it.next();
            }
            this._indexes.cacheIterator(it, ru);
        }
    }

    @Override
    protected void decompressToSparseBlockDenseDictionary(SparseBlock ret, int rl, int ru, int offR, int offC, double[] values) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() >= ru) {
            this._indexes.cacheIterator(it, ru);
        } else if (ru > this._indexes.getOffsetToLast()) {
            int j;
            int nCol = this._colIndexes.length;
            int lastOff = this._indexes.getOffsetToLast();
            int row = offR + it.value();
            for (j = 0; j < nCol; ++j) {
                ret.append(row, this._colIndexes[j] + offC, values[j]);
            }
            while (it.value() < lastOff) {
                it.next();
                row = offR + it.value();
                for (j = 0; j < nCol; ++j) {
                    ret.append(row, this._colIndexes[j] + offC, values[j]);
                }
            }
        } else {
            int nCol = this._colIndexes.length;
            while (it.isNotOver(ru)) {
                int row = offR + it.value();
                for (int j = 0; j < nCol; ++j) {
                    ret.append(row, this._colIndexes[j] + offC, values[j]);
                }
                it.next();
            }
            this._indexes.cacheIterator(it, ru);
        }
    }

    @Override
    public double getIdx(int r, int colIdx) {
        AIterator it = this._indexes.getIterator(r);
        if (it == null || it.value() != r) {
            return 0.0;
        }
        return this._dict.getValue(colIdx);
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        this.computeRowSum(c, rl, ru, preAgg[0]);
    }

    protected void computeRowSum(double[] c, int rl, int ru, double def) {
        AIterator it = this._indexes.getIterator(rl);
        if (it == null) {
            return;
        }
        if (it.value() > ru) {
            this._indexes.cacheIterator(it, ru);
        } else if (ru > this._indexes.getOffsetToLast()) {
            int maxOff = this._indexes.getOffsetToLast();
            while (true) {
                int n = it.value();
                c[n] = c[n] + def;
                if (it.value() != maxOff) {
                    it.next();
                    continue;
                }
                break;
            }
        } else {
            while (it.isNotOver(ru)) {
                int n = it.value();
                c[n] = c[n] + def;
                it.next();
            }
            this._indexes.cacheIterator(it, ru);
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        ColGroupSDCSingle.computeRowMxx(c, builtin, rl, ru, this._indexes, this._numRows, 0.0, preAgg[0]);
    }

    @Override
    public int[] getCounts(int[] counts) {
        counts[0] = this._indexes.getSize();
        return counts;
    }

    @Override
    protected void multiplyScalar(double v, double[] resV, int offRet, AIterator it) {
        this._dict.multiplyScalar(v, resV, offRet, 0, this._colIndexes);
    }

    @Override
    public void preAggregateDense(MatrixBlock m, double[] preAgg, int rl, int ru, int cl, int cu) {
        AIterator it = this._indexes.getIterator(cl);
        double[] vals = m.getDenseBlockValues();
        int nCol = m.getNumColumns();
        if (it == null) {
            return;
        }
        if (it.value() > cu) {
            this._indexes.cacheIterator(it, cu);
        } else if (cu < this._indexes.getOffsetToLast() + 1) {
            while (it.value() < cu) {
                int start = it.value() + nCol * rl;
                int end = it.value() + nCol * ru;
                int offOut = 0;
                for (int off = start; off < end; off += nCol) {
                    int n = offOut++;
                    preAgg[n] = preAgg[n] + vals[off];
                }
                it.next();
            }
            this._indexes.cacheIterator(it, cu);
        } else {
            int off;
            int of = it.value();
            int start = of + nCol * rl;
            int end = of + nCol * ru;
            int offOut = 0;
            for (off = start; off < end; off += nCol) {
                int n = offOut++;
                preAgg[n] = preAgg[n] + vals[off];
            }
            while (of < this._indexes.getOffsetToLast()) {
                it.next();
                of = it.value();
                start = of + nCol * rl;
                end = of + nCol * ru;
                offOut = 0;
                for (off = start; off < end; off += nCol) {
                    int n = offOut++;
                    preAgg[n] = preAgg[n] + vals[off];
                }
            }
        }
    }

    @Override
    public void preAggregateSparse(SparseBlock sb, double[] preAgg, int rl, int ru) {
        AOffsetIterator it = this._indexes.getOffsetIterator();
        if (rl == ru - 1) {
            ColGroupSDCSingleZeros.preAggregateSparseSingleRow(sb, preAgg, rl, this._indexes.getOffsetToLast(), it);
        } else {
            ColGroupSDCSingleZeros.preAggregateSparseMultiRow(sb, preAgg, rl, ru, this._indexes.getOffsetToLast(), it);
        }
    }

    private static void preAggregateSparseSingleRow(SparseBlock sb, double[] preAgg, int r, int last, AOffsetIterator it) {
        if (sb.isEmpty(r)) {
            return;
        }
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] avals = sb.values(r);
        double ret = 0.0;
        int i = it.value();
        int j = apos;
        while (i < last && j < alen) {
            int idx = aix[j];
            if (idx == i) {
                ret += avals[j++];
                i = it.next();
                continue;
            }
            if (idx < i) {
                ++j;
                continue;
            }
            i = it.next();
        }
        while (j < alen && aix[j] < last) {
            ++j;
        }
        if (j < alen && aix[j] == last) {
            ret += avals[j];
        }
        preAgg[0] = ret;
    }

    private static void preAggregateSparseMultiRow(SparseBlock sb, double[] preAgg, int rl, int ru, int last, AOffsetIterator it) {
        int apos;
        int[] aix;
        int alen;
        int off;
        int r;
        int i = it.value();
        int[] aOffs = new int[ru - rl];
        for (r = rl; r < ru; ++r) {
            aOffs[r - rl] = sb.pos(r);
        }
        while (i < last) {
            for (r = rl; r < ru; ++r) {
                off = r - rl;
                alen = sb.size(r) + sb.pos(r);
                aix = sb.indexes(r);
                for (apos = aOffs[off]; apos < alen && aix[apos] < i; ++apos) {
                }
                if (apos < alen && aix[apos] == i) {
                    int n = off;
                    preAgg[n] = preAgg[n] + sb.values(r)[apos];
                }
                aOffs[off] = apos;
            }
            i = it.next();
        }
        for (r = rl; r < ru; ++r) {
            off = r - rl;
            alen = sb.size(r) + sb.pos(r);
            aix = sb.indexes(r);
            for (apos = aOffs[off]; apos < alen && aix[apos] < last; ++apos) {
            }
            if (apos < alen && aix[apos] == last) {
                int n = off;
                preAgg[n] = preAgg[n] + sb.values(r)[apos];
            }
            aOffs[off] = apos;
        }
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        return size += this._indexes.getInMemorySize();
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double val0 = op.executeScalar(0.0);
        boolean isSparseSafeOp = op.sparseSafe || val0 == 0.0;
        ADictionary nDict = this._dict.applyScalarOp(op);
        if (isSparseSafeOp) {
            return new ColGroupSDCSingleZeros(this._colIndexes, this._numRows, nDict, this._indexes, this.getCachedCounts());
        }
        double[] defaultTuple = new double[this._colIndexes.length];
        Arrays.fill(defaultTuple, val0);
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, nDict, defaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        double val0 = op.fn.execute(0L);
        ADictionary nDict = this._dict.applyUnaryOp(op);
        if (val0 == 0.0) {
            return ColGroupSDCSingleZeros.create(this._colIndexes, this._numRows, nDict, this._indexes, this.getCachedCounts());
        }
        double[] defaultTuple = new double[this._colIndexes.length];
        Arrays.fill(defaultTuple, val0);
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, nDict, defaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        if (isRowSafe) {
            ADictionary ret = this._dict.binOpLeft(op, v, this._colIndexes);
            return ColGroupSDCSingleZeros.create(this._colIndexes, this._numRows, ret, this._indexes, this.getCachedCounts());
        }
        ADictionary newDict = this._dict.binOpLeft(op, v, this._colIndexes);
        double[] defaultTuple = new double[this._colIndexes.length];
        for (int i = 0; i < this._colIndexes.length; ++i) {
            defaultTuple[i] = op.fn.execute(v[this._colIndexes[i]], 0.0);
        }
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, newDict, defaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        if (isRowSafe) {
            ADictionary ret = this._dict.binOpRight(op, v, this._colIndexes);
            return new ColGroupSDCSingleZeros(this._colIndexes, this._numRows, ret, this._indexes, this.getCachedCounts());
        }
        ADictionary newDict = this._dict.binOpRight(op, v, this._colIndexes);
        double[] defaultTuple = new double[this._colIndexes.length];
        for (int i = 0; i < this._colIndexes.length; ++i) {
            defaultTuple[i] = op.fn.execute(0.0, v[this._colIndexes[i]]);
        }
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, newDict, defaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._indexes.write(out);
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._indexes = OffsetFactory.readIn(in);
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        return ret += this._indexes.getExactSizeOnDisk();
    }

    @Override
    public boolean sameIndexStructure(AColGroupCompressed that) {
        if (that instanceof ColGroupSDCSingleZeros) {
            ColGroupSDCSingleZeros th = (ColGroupSDCSingleZeros)that;
            return th._indexes == this._indexes;
        }
        return false;
    }

    @Override
    public void preAggregateThatDDCStructure(ColGroupDDC that, Dictionary ret) {
        AOffsetIterator itThis = this._indexes.getOffsetIterator();
        int nCol = that._colIndexes.length;
        int finalOffThis = this._indexes.getOffsetToLast();
        double[] rV = ret.getValues();
        if (nCol == 1) {
            this.preAggregateThatDDCStructureSingleCol(that, rV, itThis, finalOffThis);
        } else {
            this.preAggregateThatDDCStructureMultiCol(that, rV, itThis, finalOffThis, nCol);
        }
    }

    private void preAggregateThatDDCStructureSingleCol(ColGroupDDC that, double[] rV, AOffsetIterator itThis, int finalOffThis) {
        double rv = 0.0;
        double[] tV = that._dict.getValues();
        while (true) {
            int v = itThis.value();
            rv += tV[that._data.getIndex(v)];
            if (v >= finalOffThis) break;
            itThis.next();
        }
        rV[0] = rV[0] + rv;
    }

    private void preAggregateThatDDCStructureMultiCol(ColGroupDDC that, double[] rV, AOffsetIterator itThis, int finalOffThis, int nCol) {
        while (true) {
            int v = itThis.value();
            int fr = that._data.getIndex(v);
            that._dict.addToEntry(rV, fr, 0, nCol);
            if (v >= finalOffThis) break;
            itThis.next();
        }
    }

    @Override
    public void preAggregateThatSDCZerosStructure(ColGroupSDCZeros that, Dictionary ret) {
        AIterator itThat = that._indexes.getIterator();
        AOffsetIterator itThis = this._indexes.getOffsetIterator();
        int nCol = that._colIndexes.length;
        int finalOffThis = this._indexes.getOffsetToLast();
        int finalOffThat = that._indexes.getOffsetToLast();
        double[] rV = ret.getValues();
        if (nCol == 1) {
            this.preAggregateThatSDCZerosStructureSingleCol(that, rV, itThat, finalOffThat, itThis, finalOffThis);
        } else {
            this.preAggregateThatSDCZerosStructureMultiCol(that, rV, itThat, finalOffThat, itThis, finalOffThis, nCol);
        }
    }

    private void preAggregateThatSDCZerosStructureSingleCol(ColGroupSDCZeros that, double[] rV, AIterator itThat, int finalOffThat, AOffsetIterator itThis, int finalOffThis) {
        double rv = 0.0;
        double[] tV = that._dict.getValues();
        while (true) {
            int v;
            int tv;
            if ((tv = itThat.value()) == (v = itThis.value())) {
                rv += tV[that._data.getIndex(itThat.getDataIndex())];
                if (tv >= finalOffThat || v >= finalOffThis) break;
                itThat.next();
                itThis.next();
                continue;
            }
            if (tv < v) {
                if (tv >= finalOffThat) break;
                itThat.next();
                continue;
            }
            if (v >= finalOffThis) break;
            itThis.next();
        }
        rV[0] = rV[0] + rv;
    }

    private void preAggregateThatSDCZerosStructureMultiCol(ColGroupSDCZeros that, double[] rV, AIterator itThat, int finalOffThat, AOffsetIterator itThis, int finalOffThis, int nCol) {
        while (true) {
            int v;
            int tv;
            if ((tv = itThat.value()) == (v = itThis.value())) {
                that._dict.addToEntry(rV, that._data.getIndex(itThat.getDataIndex()), 0, nCol);
                if (tv >= finalOffThat || v >= finalOffThis) break;
                itThat.next();
                itThis.next();
                continue;
            }
            if (tv < v) {
                if (tv >= finalOffThat) break;
                itThat.next();
                continue;
            }
            if (v >= finalOffThis) break;
            itThis.next();
        }
    }

    @Override
    public void preAggregateThatSDCSingleZerosStructure(ColGroupSDCSingleZeros that, Dictionary ret) {
        int nCol = that._colIndexes.length;
        AOffsetIterator itThis = this._indexes.getOffsetIterator();
        AOffsetIterator itThat = that._indexes.getOffsetIterator();
        int finalOffThis = this._indexes.getOffsetToLast();
        int finalOffThat = that._indexes.getOffsetToLast();
        int count = 0;
        int tv = itThat.value();
        int v = itThis.value();
        while (tv < finalOffThat && v < finalOffThis) {
            if (tv == v) {
                ++count;
                tv = itThat.next();
                v = itThis.next();
                continue;
            }
            if (tv < v) {
                tv = itThat.next();
                continue;
            }
            v = itThis.next();
        }
        while (tv < finalOffThat && tv < v) {
            tv = itThat.next();
        }
        while (v < finalOffThis && v < tv) {
            v = itThis.next();
        }
        if (tv == v) {
            ++count;
        }
        that._dict.addToEntry(ret.getValues(), 0, 0, nCol, count);
    }

    @Override
    public int getPreAggregateSize() {
        return 1;
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        ADictionary replaced = this._dict.replace(pattern, replace, this._colIndexes.length);
        if (pattern == 0.0) {
            double[] defaultTuple = new double[this._colIndexes.length];
            for (int i = 0; i < this._colIndexes.length; ++i) {
                defaultTuple[i] = replace;
            }
            return ColGroupSDCSingle.create(this._colIndexes, this._numRows, replaced, defaultTuple, this._indexes, this.getCachedCounts());
        }
        return this.copyAndSet(replaced);
    }

    @Override
    protected void computeProduct(double[] c, int nRows) {
        c[0] = 0.0;
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = 0.0;
        }
    }

    @Override
    protected void computeColProduct(double[] c, int nRows) {
        for (int i = 0; i < c.length; ++i) {
            c[i] = 0.0;
        }
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        int nRowsScanned = this.getCounts()[0];
        return e.getCost(nRows, nRowsScanned, nCols, nVals, this._dict.getSparsity());
    }

    @Override
    protected int getIndexesSize() {
        return this.getCounts()[0];
    }

    @Override
    protected int numRowsToMultiply() {
        return this.getCounts()[0];
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s", "Indexes: "));
        sb.append(this._indexes.toString());
        return sb.toString();
    }
}

