/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.ForProgramBlock;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.WhileProgramBlock;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.lineage.LineageCache;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageDedupBlock;
import org.apache.sysds.runtime.lineage.LineageDedupUtils;
import org.apache.sysds.runtime.lineage.LineageEstimator;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.lineage.LineageMap;
import org.apache.sysds.runtime.lineage.LineageParser;
import org.apache.sysds.utils.Explain;

public class Lineage {
    private final LineageMap _map;
    private final Map<ProgramBlock, LineageDedupBlock> _dedupBlocks = new HashMap<ProgramBlock, LineageDedupBlock>();
    private LineageDedupBlock _activeDedupBlock = null;
    private LineageDedupBlock _initDedupBlock = null;

    public Lineage() {
        this._map = new LineageMap();
    }

    public Lineage(Lineage that) {
        this._map = new LineageMap(that._map);
    }

    public void trace(Instruction inst, ExecutionContext ec) {
        if (inst.getOpcode().equalsIgnoreCase("toString")) {
            return;
        }
        if (this._activeDedupBlock == null || !this._activeDedupBlock.isAllPathsTaken() || !LineageCacheConfig.ReuseCacheType.isNone()) {
            this._map.trace(inst, ec);
        }
    }

    public void traceCurrentDedupPath(ProgramBlock pb, ExecutionContext ec) {
        if (this._activeDedupBlock != null) {
            ArrayList<String> inputnames = pb.getStatementBlock().getInputstoSB();
            LineageItem[] liinputs = LineageItemUtils.getLineageItemInputstoSB(inputnames, ec);
            long lpath = this._activeDedupBlock.getPath();
            Map<String, Integer> dedupPatchHashList = LineageDedupUtils.setDedupMap(this._activeDedupBlock, lpath);
            LineageMap lm = this._activeDedupBlock.getMap(lpath);
            if (lm != null) {
                this._map.processDedupItem(lm, lpath, liinputs, pb.getStatementBlock().getName(), dedupPatchHashList);
            }
        }
    }

    public LineageItem getOrCreate(CPOperand variable) {
        return this._initDedupBlock == null ? this._map.getOrCreate(variable) : this._initDedupBlock.getActiveMap().getOrCreate(variable);
    }

    public boolean contains(CPOperand variable) {
        return this._initDedupBlock == null ? this._map.containsKey(variable.getName()) : this._initDedupBlock.getActiveMap().containsKey(variable.getName());
    }

    public LineageItem get(String varName) {
        return this._map.get(varName);
    }

    public void setDedupBlock(LineageDedupBlock ldb) {
        this._activeDedupBlock = ldb;
    }

    public LineageMap getLineageMap() {
        return this._map;
    }

    public Map<ProgramBlock, LineageDedupBlock> getDedupBlocks() {
        return this._dedupBlocks;
    }

    public void set(String varName, LineageItem li) {
        this._map.set(varName, li);
    }

    public void setLiteral(String varName, LineageItem li) {
        this._map.setLiteral(varName, li);
    }

    public LineageItem get(CPOperand variable) {
        return this._initDedupBlock == null ? this._map.get(variable) : this._initDedupBlock.getActiveMap().get(variable);
    }

    public void resetDedupPath() {
        if (this._activeDedupBlock != null) {
            this._activeDedupBlock.resetPath();
        }
    }

    public void setDedupPathBranch(int pos, boolean value) {
        if (this._activeDedupBlock != null && value) {
            this._activeDedupBlock.setPathBranch(pos, value);
        }
    }

    public void setInitDedupBlock(LineageDedupBlock ldb) {
        this._initDedupBlock = ldb;
    }

    public void initializeDedupBlock(ProgramBlock pb, ExecutionContext ec) {
        if (!(pb instanceof ForProgramBlock) && !(pb instanceof WhileProgramBlock)) {
            throw new DMLRuntimeException("Invalid deduplication block: " + pb.getClass().getSimpleName());
        }
        if (!this._dedupBlocks.containsKey(pb)) {
            boolean valid = LineageDedupUtils.isValidDedupBlock(pb, false);
            this._dedupBlocks.put(pb, valid ? LineageDedupUtils.initializeDedupBlock(pb, ec) : null);
        }
        this._activeDedupBlock = this._dedupBlocks.get(pb);
    }

    public void createDedupPatch(ProgramBlock pb, ExecutionContext ec) {
        if (this._activeDedupBlock != null) {
            LineageDedupUtils.setNewDedupPatch(this._activeDedupBlock, pb, ec);
        }
    }

    public void clearDedupBlock() {
        this._activeDedupBlock = null;
    }

    public void clearLineageMap() {
        this._map.resetLineageMaps();
    }

    public Map<String, String> serialize() {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, LineageItem> e : this._map.getTraces().entrySet()) {
            ret.put(e.getKey(), Explain.explain(e.getValue()));
        }
        return ret;
    }

    public static Lineage deserialize(Map<String, String> serialLineage) {
        Lineage ret = new Lineage();
        for (Map.Entry<String, String> e : serialLineage.entrySet()) {
            ret.set(e.getKey(), LineageParser.parseLineageTrace(e.getValue()));
        }
        return ret;
    }

    public static void resetInternalState() {
        LineageItem.resetIDSequence();
        LineageCache.resetCache();
        LineageCacheStatistics.reset();
        LineageEstimator.resetEstimatorCache();
    }

    public static void setLinReusePartial() {
        LineageCacheConfig.setConfigTsmmCbind(LineageCacheConfig.ReuseCacheType.REUSE_PARTIAL);
    }

    public static void setLinReuseFull() {
        LineageCacheConfig.setConfigTsmmCbind(LineageCacheConfig.ReuseCacheType.REUSE_FULL);
    }

    public static void setLinReuseFullAndPartial() {
        LineageCacheConfig.setConfigTsmmCbind(LineageCacheConfig.ReuseCacheType.REUSE_HYBRID);
    }

    public static void setLinReuseNone() {
        LineageCacheConfig.setConfigTsmmCbind(LineageCacheConfig.ReuseCacheType.NONE);
    }
}

