/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io.hdf5;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.util.BitSet;
import org.apache.sysds.runtime.io.hdf5.H5BufferBuilder;
import org.apache.sysds.runtime.io.hdf5.H5RuntimeException;
import org.apache.sysds.runtime.io.hdf5.Utils;

public class H5DoubleDataType {
    private int version;
    private int dataClass;
    private int size;
    protected BitSet classBits;
    private ByteOrder order;
    private boolean lowPadding;
    private boolean highPadding;
    private boolean internalPadding;
    private int mantissaNormalization;
    private int signLocation;
    private short bitOffset;
    private short bitPrecision;
    private byte exponentLocation;
    private byte exponentSize;
    private byte mantissaLocation;
    private byte mantissaSize;
    private int exponentBias;

    public H5DoubleDataType() {
    }

    public H5DoubleDataType(ByteBuffer bb) {
        BitSet classAndVersion = BitSet.valueOf(new byte[]{bb.get()});
        this.dataClass = Utils.bitsToInt(classAndVersion, 0, 4);
        this.version = Utils.bitsToInt(classAndVersion, 4, 4);
        byte[] classBytes = new byte[3];
        bb.get(classBytes);
        this.classBits = BitSet.valueOf(classBytes);
        this.size = Utils.readBytesAsUnsignedInt(bb, 4);
        if (this.classBits.get(6)) {
            throw new H5RuntimeException("VAX endian is not supported");
        }
        this.order = this.classBits.get(0) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        this.lowPadding = this.classBits.get(1);
        this.highPadding = this.classBits.get(2);
        this.internalPadding = this.classBits.get(3);
        this.mantissaNormalization = Utils.bitsToInt(this.classBits, 4, 2);
        this.signLocation = Utils.bitsToInt(this.classBits, 8, 8);
        this.bitOffset = bb.getShort();
        this.bitPrecision = bb.getShort();
        this.exponentLocation = bb.get();
        this.exponentSize = bb.get();
        this.mantissaLocation = bb.get();
        this.mantissaSize = bb.get();
        this.exponentBias = bb.getInt();
    }

    public void toBuffer(H5BufferBuilder bb) {
        int classAndVersion = 17;
        bb.writeByte(classAndVersion);
        byte[] classBytes = new byte[]{32, 63, 0};
        bb.writeBytes(classBytes);
        bb.writeInt(8);
        bb.writeShort((short)0);
        bb.writeShort((short)64);
        bb.writeByte(52);
        bb.writeByte(11);
        bb.writeByte(0);
        bb.writeByte(52);
        bb.writeInt(1023);
        bb.writeInt(0);
    }

    public void fillData(ByteBuffer buffer, double[] data) {
        DoubleBuffer db = buffer.asDoubleBuffer();
        db.get(data);
    }

    public int getVersion() {
        return this.version;
    }

    public int getDataClass() {
        return this.dataClass;
    }

    public int getSize() {
        return this.size;
    }

    public BitSet getClassBits() {
        return this.classBits;
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    public boolean isLowPadding() {
        return this.lowPadding;
    }

    public boolean isHighPadding() {
        return this.highPadding;
    }

    public boolean isInternalPadding() {
        return this.internalPadding;
    }

    public int getMantissaNormalization() {
        return this.mantissaNormalization;
    }

    public int getSignLocation() {
        return this.signLocation;
    }

    public short getBitOffset() {
        return this.bitOffset;
    }

    public short getBitPrecision() {
        return this.bitPrecision;
    }

    public byte getExponentLocation() {
        return this.exponentLocation;
    }

    public byte getExponentSize() {
        return this.exponentSize;
    }

    public byte getMantissaLocation() {
        return this.mantissaLocation;
    }

    public byte getMantissaSize() {
        return this.mantissaSize;
    }

    public int getExponentBias() {
        return this.exponentBias;
    }
}

