/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.compress.utils.ABitmap;
import org.apache.sysds.runtime.compress.utils.Bitmap;
import org.apache.sysds.runtime.compress.utils.BitmapLossy;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public class BitmapLossyEncoder {
    private static ThreadLocal<byte[]> memPoolByteArray = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return null;
        }
    };
    private static ThreadLocal<double[]> memPoolDoubleArray = new ThreadLocal<double[]>(){

        @Override
        protected double[] initialValue() {
            return null;
        }
    };

    public static ABitmap makeBitmapLossy(ABitmap ubm, int numRows) {
        throw new NotImplementedException();
    }

    private static BitmapLossy make8BitLossy(Bitmap ubm, Stats stats, int numRows) {
        double[] fp = ubm.getValues();
        int numCols = ubm.getNumColumns();
        double scale = BitmapLossyEncoder.get8BitScale(stats.min, stats.max);
        byte[] scaledValues = BitmapLossyEncoder.scaleValuesToByte(fp, scale);
        if (numCols == 1) {
            return BitmapLossyEncoder.makeBitmapLossySingleCol(ubm, scaledValues, scale, numRows);
        }
        return BitmapLossyEncoder.makeBitmapLossyMultiCol(ubm, scaledValues, scale, numRows);
    }

    private static double get8BitScale(double min, double max) {
        return Math.max(Math.abs(min), Math.abs(max)) / 127.0;
    }

    private static BitmapLossy makeBitmapLossySingleCol(Bitmap ubm, byte[] scaledValues, double scale, int numRows) {
        LinkedHashMap values = new LinkedHashMap();
        HashMap<Byte, Integer> lengths = new HashMap<Byte, Integer>();
        IntArrayList[] fullSizeOffsetsLists = ubm.getOffsetList();
        boolean somethingToMerge = false;
        for (int idx = 0; idx < scaledValues.length; ++idx) {
            if (scaledValues[idx] == 0) continue;
            if (values.containsKey(scaledValues[idx])) {
                ((Queue)values.get(scaledValues[idx])).add(fullSizeOffsetsLists[idx]);
                lengths.put(scaledValues[idx], (Integer)lengths.get(scaledValues[idx]) + fullSizeOffsetsLists[idx].size());
                somethingToMerge = true;
                continue;
            }
            LinkedList<IntArrayList> offsets = new LinkedList<IntArrayList>();
            offsets.add(fullSizeOffsetsLists[idx]);
            values.put(scaledValues[idx], offsets);
            lengths.put(scaledValues[idx], fullSizeOffsetsLists[idx].size());
        }
        if (somethingToMerge) {
            byte[] scaledValuesReduced = new byte[values.keySet().size()];
            IntArrayList[] newOffsetsLists = new IntArrayList[values.keySet().size()];
            Iterator x = values.entrySet().iterator();
            int idx = 0;
            while (x.hasNext()) {
                Map.Entry ent = x.next();
                scaledValuesReduced[idx] = (Byte)ent.getKey();
                Queue q = (Queue)ent.getValue();
                newOffsetsLists[idx] = q.size() == 1 ? (IntArrayList)q.remove() : BitmapLossyEncoder.mergeOffsets(q, new int[((Integer)lengths.get(ent.getKey())).intValue()]);
                ++idx;
            }
            return new BitmapLossy(ubm.getNumColumns(), newOffsetsLists, scaledValuesReduced, scale, numRows);
        }
        return new BitmapLossy(ubm.getNumColumns(), fullSizeOffsetsLists, scaledValues, scale, numRows);
    }

    private static BitmapLossy makeBitmapLossyMultiCol(Bitmap ubm, byte[] scaledValues, double scale, int numRows) {
        int numColumns = ubm.getNumColumns();
        HashMap values = new HashMap();
        HashMap lengths = new HashMap();
        IntArrayList[] fullSizeOffsetsLists = ubm.getOffsetList();
        boolean allZero = true;
        boolean somethingToMerge = false;
        for (int idx = 0; idx < scaledValues.length; idx += numColumns) {
            ArrayList<Byte> array = new ArrayList<Byte>();
            for (int off = 0; off < numColumns; ++off) {
                allZero = scaledValues[idx + off] == 0 && allZero;
                array.add(scaledValues[idx + off]);
            }
            if (!allZero) {
                IntArrayList entry = fullSizeOffsetsLists[idx / numColumns];
                if (values.containsKey(array)) {
                    ((Queue)values.get(array)).add(entry);
                    lengths.put(array, (Integer)lengths.get(array) + entry.size());
                    somethingToMerge = true;
                } else {
                    LinkedList<IntArrayList> offsets = new LinkedList<IntArrayList>();
                    offsets.add(entry);
                    values.put(array, offsets);
                    lengths.put(array, entry.size());
                }
            }
            allZero = true;
        }
        if (somethingToMerge) {
            byte[] scaledValuesReduced = new byte[values.keySet().size() * numColumns];
            IntArrayList[] newOffsetsLists = new IntArrayList[values.keySet().size()];
            Iterator x = values.entrySet().iterator();
            int idx = 0;
            while (x.hasNext()) {
                Map.Entry ent = x.next();
                List key = (List)ent.getKey();
                int row = idx * numColumns;
                for (int off = 0; off < numColumns; ++off) {
                    scaledValuesReduced[row + off] = (Byte)key.get(off);
                }
                Queue q = (Queue)ent.getValue();
                newOffsetsLists[idx] = q.size() == 1 ? (IntArrayList)q.remove() : BitmapLossyEncoder.mergeOffsets(q, new int[((Integer)lengths.get(key)).intValue()]);
                ++idx;
            }
            return new BitmapLossy(ubm.getNumColumns(), newOffsetsLists, scaledValuesReduced, scale, numRows);
        }
        return new BitmapLossy(ubm.getNumColumns(), fullSizeOffsetsLists, scaledValues, scale, numRows);
    }

    private static IntArrayList mergeOffsets(Queue<IntArrayList> offsets, int[] res) {
        int indexStart = 0;
        while (!offsets.isEmpty()) {
            IntArrayList h = offsets.remove();
            int[] v = h.extractValues();
            for (int i = 0; i < h.size(); ++i) {
                res[indexStart++] = v[i];
            }
        }
        Arrays.sort(res);
        return new IntArrayList(res);
    }

    private static byte[] scaleValuesToByte(double[] fp, double scale) {
        byte[] res = BitmapLossyEncoder.getMemLocalByteArray(fp.length, false);
        for (int idx = 0; idx < fp.length; ++idx) {
            res[idx] = (byte)Math.round(fp[idx] / scale);
        }
        return res;
    }

    private static byte[] getMemLocalByteArray(int length, boolean clean) {
        byte[] ar = memPoolByteArray.get();
        if (ar != null && ar.length >= length) {
            if (clean) {
                for (int i = 0; i < length; ++i) {
                    ar[i] = 0;
                }
            }
            return ar;
        }
        memPoolByteArray.set(new byte[length]);
        return memPoolByteArray.get();
    }

    private static double[] getMemLocalDoubleArray(int length, boolean clean) {
        double[] ar = memPoolDoubleArray.get();
        if (ar != null && ar.length >= length) {
            if (clean) {
                Arrays.fill(ar, 0.0);
            }
            return ar;
        }
        memPoolDoubleArray.set(new double[length]);
        return memPoolDoubleArray.get();
    }

    public static void cleanMemPools() {
        memPoolByteArray.remove();
        memPoolDoubleArray.remove();
    }

    private static class Stats {
        protected double max = Double.NEGATIVE_INFINITY;
        protected double min = Double.POSITIVE_INFINITY;
        protected double minDelta;
        protected double maxDelta = Double.NEGATIVE_INFINITY;
        protected boolean sameDelta = true;

        public Stats(double[] fp) {
            this.minDelta = Double.POSITIVE_INFINITY;
            if (fp.length > 1) {
                double delta = fp[0] - fp[1];
                for (int i = 0; i < fp.length - 1; ++i) {
                    if (fp[i] > this.max) {
                        this.max = fp[i];
                    }
                    if (fp[i] < this.min) {
                        this.min = fp[i];
                    }
                    double ndelta = fp[i] - fp[i + 1];
                    if (delta < this.minDelta) {
                        this.minDelta = delta;
                    }
                    if (delta > this.maxDelta) {
                        this.maxDelta = delta;
                    }
                    if (this.sameDelta && Math.abs(delta - ndelta) <= delta * 1.0E-8) {
                        this.sameDelta = false;
                    }
                    delta = ndelta;
                }
                if (fp[fp.length - 1] > this.max) {
                    this.max = fp[fp.length - 1];
                }
                if (fp[fp.length - 1] < this.min) {
                    this.min = fp[fp.length - 1];
                }
            } else {
                this.max = fp[0];
                this.min = fp[0];
                this.maxDelta = 0.0;
                this.minDelta = 0.0;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Stats{" + this.hashCode() + "}");
            sb.append(" max: " + this.max);
            sb.append(" min: " + this.min);
            sb.append(" min\u0394: " + this.minDelta);
            sb.append(" max\u0394: " + this.maxDelta);
            sb.append(" same\u0394: " + this.maxDelta);
            return sb.toString();
        }
    }
}

