/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.workload;

import java.util.ArrayList;
import java.util.List;
import org.apache.sysds.hops.Hop;

public class WTreeNode {
    private final WTNodeType _type;
    private final List<WTreeNode> _childs = new ArrayList<WTreeNode>();
    private final List<Hop> _cops = new ArrayList<Hop>();
    private int _beginLine = -1;
    private int _endLine = -1;

    public WTreeNode(WTNodeType type) {
        this._type = type;
    }

    public WTNodeType getType() {
        return this._type;
    }

    public List<WTreeNode> getChildNodes() {
        return this._childs;
    }

    public void addChild(WTreeNode node) {
        this._childs.add(node);
    }

    public List<Hop> getCompressedOps() {
        return this._cops;
    }

    public void addCompressedOp(Hop hop) {
        this._cops.add(hop);
    }

    public void setLineNumbers(int begin, int end) {
        this._beginLine = begin;
        this._endLine = end;
    }

    public String explain(int level) {
        StringBuilder sb;
        block6: {
            block5: {
                sb = new StringBuilder();
                for (int i = 0; i < level; ++i) {
                    sb.append("--");
                }
                sb.append(this._type.name());
                if (this._beginLine >= 0 && this._endLine >= 0) {
                    sb.append(" (lines ");
                    sb.append(this._beginLine);
                    sb.append("-");
                    sb.append(this._endLine);
                    sb.append(")");
                }
                sb.append("\n");
                if (this._childs.isEmpty()) break block5;
                for (WTreeNode n : this._childs) {
                    sb.append(n.explain(level + 1));
                }
                break block6;
            }
            if (this._cops.isEmpty()) break block6;
            for (Hop hop : this._cops) {
                for (int i = 0; i < level + 1; ++i) {
                    sb.append("--");
                }
                sb.append(hop.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Workload Tree:\n");
        sb.append("--------------------------------------------------------------------------------\n");
        sb.append(this.explain(1));
        sb.append("--------------------------------------------------------------------------------\n");
        return sb.toString();
    }

    public static enum WTNodeType {
        MAIN,
        FCALL,
        IF,
        WHILE,
        FOR,
        PARFOR,
        BASIC_BLOCK;


        public boolean isLoop() {
            return this == WHILE || this == FOR || this == PARFOR;
        }
    }
}

