/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToInt
extends AMapToData {
    private final int[] _data;

    public MapToInt(int unique, int size) {
        super(unique);
        this._data = new int[size];
    }

    private MapToInt(int unique, int[] data) {
        super(unique);
        this._data = data;
    }

    @Override
    public int getIndex(int n) {
        return this._data[n];
    }

    @Override
    public void fill(int v) {
        Arrays.fill(this._data, v);
    }

    @Override
    public long getInMemorySize() {
        return MapToInt.getInMemorySize(this._data.length);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 24L;
        size = (long)((double)size + MemoryEstimates.intArrayCost(dataLength));
        return size;
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data.length * 4;
    }

    @Override
    public void set(int n, int v) {
        this._data[n] = v;
    }

    @Override
    public int size() {
        return this._data.length;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.INT.ordinal());
        out.writeInt(this.getUnique());
        out.writeInt(this._data.length);
        for (int i = 0; i < this._data.length; ++i) {
            out.writeInt(this._data[i]);
        }
    }

    public static MapToInt readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        int[] data = new int[length];
        for (int i = 0; i < length; ++i) {
            data[i] = in.readInt();
        }
        return new MapToInt(unique, data);
    }
}

